<? # txt2tags.php - a handy web interface for the txt2tags conversion tool
   # 20020322 aurlio marinho jargas <aurelio@verde666.org>

### CONFIG
## customize here your settings
#
# define here where's the txt2tags program location
$prog = "./txt2tags";
# the default text for the user's textarea
$dfttxt = "= my title =\nThis is a __sample__ text line, with **bold** and ";
$dfttxt.= "//italic//.\n\n|   a   | nice |\n| table | here |\n\n";
#
### end CONFIG


function HtmlHelpTable($arr) {
$init = "<center><table align=\"center\" cellpadding=5 cellspacing=5 border=0>";
$tropen = '<tr>'; $trclose = '</tr>';
$tdopen = '<td nowrap bgcolor="orange" valign="top"><font size=2>';
$tdclose = '</font></td>'; $end = '</center></table>';

$r = "\n$init\n";                        # open table
while (list($key, $celldata) = each($arr)) {
  $r .= "$tropen\n";                     # open line
  for ($j=0;$j<count($celldata);$j++) {
    $data = $celldata; if (is_array($celldata)) $data = $celldata[$j];
    $r .= "$tdopen$data$tdclose\n";      # full cell
  }
  $r .= "$trclose\n";                    # close line
}
$r .= "$end\n\n";                        # close table
return $r;
}
function FormSelect($name,$arr,$selected='',$size=0) {
  $dft_size = 10;
  if ($size == 0){  # case not specified, $size = $array size
    $arrsize = count($arr);
    if ($arrsize < $dft_size) $size = $arrsize;
    else $size = $dft_size;
  }
  $r = "\n<select name=\"$name\" size=$size class=\"Form\">\n";
  while (list($key, $data) = each($arr)) {
    $id = $txt = $data; if (is_array($data)) list($id, $txt) = $data;
    $sel = ''; if ($id == $selected) $sel .= " selected";
    $r .= "<option value=\"$id\"$sel>$txt</option>\n";
  }
  $r .= "</select>\n";
  return $r;
}
function FormClose()   { print "\n</form>"; }
function FormOpen($url){ print "\n<form method=\"post\" action=\"$url\">"; }
function FormHidden($name, $value){
  return "\n<input type=\"hidden\" name=\"$name\" value=\"$value\">"; }
function FormSubmit($txt){
  return "\n<input type=\"submit\" value=\"$txt\">"; }
function FormTextarea($name, $txt, $cols=40, $lines=3){
  return "\n<textarea name=\"$name\" cols=$cols rows=$lines>$txt</textarea>"; }
function FormCheck($name, $value, $on=0){ if ($on) $state = 'checked';
  return "\n<input type=\"checkbox\" name=\"$name\" value=\"$value\" $state>"; }
?>

<html>
<head><title>txt2tags // ONE source, MULTI targets</title></head>
<body bgcolor="white" text="black">
<pre><? if ($SCRIPT_FILENAME == '/home/groups/t/tx/txt2tags/htdocs/index.php')
require "../cgi-bin/txt2tags.cnt";?></pre>

<h1>txt2tags WEB Interface</h1>


<ul>
<li><a href="http://txt2tags.sf.net">Txt2tags</a> is a text formatting
    and conversion tool and this is its WEB Interface.

<li>On this page you can try it out <b>before</b> download.

<li>This page is included on the program distribution, so you can
    install and use it on your own intranet!</p>
</ul>

<p>
<hr>
<center><p align="center">

<?
if (!$txt) $txt = $dfttxt;

#--[ help ]----------------------------------------------------------
$arr_simplehelp[] = array(
   '<code>**bold**</code>', '<code>//italic//</code>',
   '<code>__underline__</code>', '<code>`code`</code>',
   '<code>[image.jpg]</code>', '<code>%%date</code>');
$arr_multihelp[] = array(
   "<pre>- list\n  - sublist\n    - subsu...</pre>",
   "<pre>---\nverbatim area\n---</pre>",
   "<pre>= title =\n== subtitle ==\n=== subsub...===</pre>",
   "<pre>|| title | title |\n|  cell  | cell  |\n|  cell  | cell  |</pre>");

print "\n".'<table cellspacing=0 cellpadding=2 border=0 bgcolor="black">';
print "\n".'<tr><td><p align="center"><font color="white"><b>- TAGS -</b></font></p></td></tr>';
print "\n".'<tr><td>'.HtmlHelpTable($arr_simplehelp).'</td></tr>';
print "\n".'<tr><td>'.HtmlHelpTable($arr_multihelp ).'</td></tr>';
print "\n".'<tr><td><p align="right"><font color="white"><b>in doubt see the <a href="http://txt2tags.sf.net/sample.t2t">TXT sample file</a>&nbsp;</td></tr>';
print "\n</table>\n";
#--------------------------------------------------------------------

print FormOpen($PHP_SELF);
print '<p>'.FormTextarea('txt', $txt, 72, 10);
print '<br>Convert to:'.FormSelect('target', array(
       array('html', 'HTML page'),
       array('sgml', 'SGML document'),
       array('tex' , 'LaTeX document'),
       array('man' , 'UNIX Manual page'),
       array('mgp' , 'Magic Point presentation'),
       array('moin', 'MoinMoin page'),
       array('pm6' , 'PageMaker 6.0 document')
       ), $target,1);
print FormCheck('noheaders', '--noheaders', $noheaders)." No headers";
print '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
print FormSubmit('Do it now!');
print FormClose();
print '</p></center><hr>';

if ($target){
  $txt = escapeshellarg("\n$txt"); # always empty headers
  $cmd = ereg_replace('[^a-z6 -]','',"$noheaders -t $target -");
  print "\n<h2>$target</h2>\n<hr>\n\n<pre><code>";
  print "COMMAND: $prog $cmd\nOUTPUT:\n";
  print htmlspecialchars(`echo $txt | $prog $cmd`);
  print "\n</code></pre><hr>";
}
?>

<br>
Author: <i>Aurlio Marinho Jargas</i><br>
Homepage: <a href="http://txt2tags.sf.net">http://txt2tags.sf.net</a>
</body>
</html>
