/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XSLTInputSource {
    private StreamSource streamSource = null;
    private SAXSource saxSource = null;
    private DOMSource domSource = null;
    private String encoding = null;
    private String baseID = null;

    public XSLTInputSource() {
        this.saxSource = new SAXSource();
    }

    public XSLTInputSource(InputStream inputStream) {
        this.streamSource = new StreamSource();
        this.streamSource.setInputStream(inputStream);
    }

    public XSLTInputSource(Reader reader) {
        this.streamSource = new StreamSource();
        this.streamSource.setReader(reader);
    }

    public XSLTInputSource(String string) {
        this.saxSource = new SAXSource();
        this.setSystemId(string);
    }

    public XSLTInputSource(Node node) {
        this.domSource = new DOMSource();
        this.domSource.setNode(node);
    }

    public XSLTInputSource(InputSource inputSource) {
        this.saxSource = new SAXSource();
        this.saxSource.setInputSource(inputSource);
        this.setEncoding(inputSource.getEncoding());
        this.setSystemId(inputSource.getSystemId());
    }

    public Reader getCharacterStream() {
        if (this.streamSource != null) {
            return this.streamSource.getReader();
        }
        return null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public InputStream getInputStream() {
        if (this.streamSource != null) {
            return this.streamSource.getInputStream();
        }
        return null;
    }

    public Node getNode() {
        if (this.domSource != null) {
            return this.domSource.getNode();
        }
        return null;
    }

    public Source getSourceObject() {
        if (this.streamSource != null) {
            return this.streamSource;
        }
        if (this.domSource != null) {
            return this.domSource;
        }
        return this.saxSource;
    }

    public String getSystemId() {
        return this.baseID;
    }

    public void setCharacterStream(Reader reader) {
        if (this.streamSource == null) {
            this.streamSource = new StreamSource();
        }
        this.streamSource.setReader(reader);
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setInputStream(InputStream inputStream) {
        if (this.streamSource == null) {
            this.streamSource = new StreamSource();
        }
        this.streamSource.setInputStream(inputStream);
    }

    public void setNode(Node node) {
        if (this.domSource == null) {
            this.domSource = new DOMSource();
        }
        this.domSource.setNode(node);
    }

    public void setSystemId(String string) {
        this.baseID = string;
        if (this.saxSource != null) {
            this.saxSource.setSystemId(string);
        } else if (this.domSource != null) {
            this.domSource.setSystemId(string);
        } else if (this.streamSource != null) {
            this.streamSource.setSystemId(string);
        }
    }
}

