/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import org.enhydra.instantdb.db.Column;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Transaction;
import org.enhydra.instantdb.db.idbDataOutputStream;

class LongColumn
extends Column {
    long nextIncrement;
    static final long NULL_VALUE = Long.MIN_VALUE;
    boolean autoIncrement;
    static int time;
    static final char[] digits;
    static final String[] strCache;

    static {
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        strCache = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    }

    LongColumn(Table table, String string) throws SQLException, NumberFormatException {
        super(table, string, 8);
        this.nullObj = new Long(Long.MIN_VALUE);
        this.nextIncrement = 10000000000L;
        this.type = 4;
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
        super.close(randomAccessFile);
        randomAccessFile.writeBoolean(this.autoIncrement);
        randomAccessFile.writeLong(this.nextIncrement);
    }

    boolean compare(int n, Object object, int n2, boolean bl) throws SQLException {
        if (n2 == 1) {
            if (this.equalToRow(n, (Number)object)) {
                if (bl) {
                    return true;
                }
                return LongColumn.compareVals(this.getByRow(n), object, n2, bl);
            }
            return false;
        }
        return LongColumn.compareVals(this.getByRow(n), object, n2, bl);
    }

    static boolean compareVals(Object object, Object object2, int n, boolean bl) throws SQLException {
        long l = ((Number)object).longValue();
        long l2 = ((Number)object2).longValue();
        if (!(bl || l != Long.MIN_VALUE && l2 != Long.MIN_VALUE)) {
            return false;
        }
        switch (n) {
            case 1: {
                return l == l2;
            }
            case 4: {
                return l != l2;
            }
            case 7: {
                return l < l2;
            }
            case 8: {
                return l <= l2;
            }
            case 5: {
                return l > l2;
            }
            case 6: {
                return l >= l2;
            }
        }
        throw new SQLException("Internal error: undefined operation: " + n, "XOPEN?");
    }

    private boolean equalToRow(int n, Number number) throws SQLException {
        long l = number.longValue();
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                long l2 = this.cTable.dataIn.readLong();
                this.cTable.rndFile.freeReadAhead();
                if (l2 != l) {
                    return false;
                }
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
            return true;
        }
        return (Long)object == l;
    }

    Object getByRow(int n) throws SQLException {
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                long l = this.cTable.dataIn.readLong();
                this.cTable.rndFile.freeReadAhead();
                object = new Long(l);
            }
            catch (Exception exception) {
                this.cTable.rndFile.freeReadAhead();
                throw new SQLException("Problem reading column, " + this.colName + ", in table, " + this.cTable.tableName + ", " + exception.toString());
            }
            this.rowCache.add(object, n);
        }
        return object;
    }

    int getHash(Object object) {
        long l = ((Number)object).longValue();
        return (int)(l >> 32 ^ l);
    }

    boolean hashPreservesOrder() {
        return false;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isNull(Object object) {
        Long l = (Long)object;
        return l.equals(this.nullObj);
    }

    boolean numeric() {
        return true;
    }

    void read(RandomAccessFile randomAccessFile) throws IOException {
        super.read(randomAccessFile);
        this.autoIncrement = randomAccessFile.readBoolean();
        this.nextIncrement = randomAccessFile.readLong();
        if (this.autoIncrement) {
            this.requiresRecovery = true;
        }
    }

    void recover(Object object) {
        if (!this.autoIncrement) {
            return;
        }
        long l = (Long)object;
        if (l >= this.nextIncrement) {
            this.nextIncrement = l + 1L;
        }
    }

    void setBooleanProperty(int n, boolean bl) {
        switch (n) {
            case 5: {
                this.autoIncrement = bl;
                break;
            }
            default: {
                super.setBooleanProperty(n, bl);
            }
        }
    }

    void setProperty(int n, Object object) {
        switch (n) {
            case 4: {
                if (object == null) {
                    super.setProperty(n, null);
                    return;
                }
                Long l = new Long((String)object);
                if (l == Long.MIN_VALUE) {
                    throw new NumberFormatException(object.toString());
                }
                super.setProperty(n, l);
                break;
            }
            case 7: {
                long l;
                if (object == null) {
                    int n2 = 1;
                    while (n2 <= this.cTable.rowCount) {
                        try {
                            if (!this.cTable.rowDeleted(n2)) {
                                Object object2 = this.getByRow(n2);
                                if (object == null) {
                                    object = object2;
                                } else {
                                    long l2 = ((Number)object).longValue();
                                    long l3 = ((Number)object2).longValue();
                                    if (l3 >= l2) {
                                        object = new Long(l3 + 1L);
                                    }
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            System.out.println(sQLException.toString());
                        }
                        ++n2;
                    }
                    if (object == null) {
                        object = new Long(10000000000L);
                    }
                }
                this.nextIncrement = l = ((Number)object).longValue();
                break;
            }
            default: {
                super.setProperty(n, object);
            }
        }
    }

    Object toObject(Object object) {
        Long l;
        if (this.autoIncrement && !this.cTable.noAutoInc && !this.cTable.autoIncOff) {
            return new Long(this.nextIncrement++);
        }
        if (object == null) {
            return this.nullObj;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return this.nullObj;
            }
            try {
                l = new Long(string);
            }
            catch (Exception exception) {
                return null;
            }
        } else {
            if (object instanceof Long) {
                Long l2 = (Long)object;
                return l2;
            }
            if (object instanceof Number) {
                long l3 = ((Number)object).longValue();
                l = new Long(l3);
            } else {
                return null;
            }
        }
        long l4 = l;
        if (l4 == Long.MIN_VALUE && !this.allowAccidentalNulls) {
            return null;
        }
        if (l4 > this.nextIncrement) {
            this.nextIncrement = l4 + 1L;
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    public String toString(Object var1_1) {
        block3: {
            block4: {
                block2: {
                    var3_2 = ((Number)var1_1).longValue();
                    if (var3_2 != -9223372036854775808L) break block2;
                    var2_3 = "NULL";
                    break block3;
                }
                var5_4 = this.dbase.getStringBuffer();
                v0 = var6_5 = var3_2 < 0L;
                if (!var6_5) break block4;
                var3_2 = -var3_2;
                ** GOTO lbl17
            }
            if (var3_2 >= 10L) ** GOTO lbl17
            return LongColumn.strCache[(int)var3_2];
lbl-1000:
            // 1 sources

            {
                var5_4.append(LongColumn.digits[(int)(var3_2 % 10L)]);
                var3_2 /= 10L;
lbl17:
                // 3 sources

                ** while (var3_2 >= 10L)
            }
lbl18:
            // 1 sources

            var5_4.append(LongColumn.digits[(int)(var3_2 % 10L)]);
            if (var6_5) {
                var5_4.append('-');
            }
            var2_3 = var5_4.reverse().toString();
            this.dbase.returnStringBuffer(var5_4);
        }
        return var2_3;
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
        super.write(randomAccessFile);
        randomAccessFile.writeBoolean(this.autoIncrement);
        randomAccessFile.writeLong(this.nextIncrement);
    }

    void writeObject(idbDataOutputStream idbDataOutputStream2, Object object, Transaction transaction, int n) throws IOException {
        long l = (Long)object;
        idbDataOutputStream2.writeLong(l);
    }
}

