/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class WalkingIterator
extends LocPathIterator {
    protected AxesWalker m_lastUsedWalker;
    protected AxesWalker m_firstWalker;

    WalkingIterator(Compiler compiler, int opPos, int analysis, boolean shouldLoadWalkers) throws TransformerException {
        super(compiler, opPos, analysis, shouldLoadWalkers);
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        if (shouldLoadWalkers) {
            this.m_lastUsedWalker = this.m_firstWalker = WalkerFactory.loadWalkers(this, compiler, firstStepPos, 0);
        }
    }

    protected WalkingIterator(PrefixResolver nscontext) {
        super(nscontext);
    }

    public Object clone() throws CloneNotSupportedException {
        WalkingIterator clone = (WalkingIterator)super.clone();
        if (null != this.m_firstWalker) {
            clone.m_firstWalker = this.m_firstWalker.cloneDeep(clone, null);
        }
        return clone;
    }

    public void reset() {
        super.reset();
        if (null != this.m_firstWalker) {
            this.m_lastUsedWalker = this.m_firstWalker;
            this.m_firstWalker.setRoot(this.m_context);
        }
    }

    public int nextNode() {
        if (null != this.m_cachedNodes) {
            if (this.m_next < this.m_cachedNodes.size()) {
                this.m_lastFetched = this.m_currentContextNode = this.m_cachedNodes.elementAt(this.m_next);
                int next = this.m_currentContextNode;
                this.incrementNextPosition();
                return next;
            }
            if (this.m_foundLast) {
                this.m_lastFetched = -1;
                return -1;
            }
        }
        if (-1 == this.m_stackFrame) {
            if (-1 == this.m_firstWalker.getRoot()) {
                this.setNextPosition(0);
                this.m_firstWalker.setRoot(this.m_context);
                this.m_lastUsedWalker = this.m_firstWalker;
            }
            return this.returnNextNode(this.m_firstWalker.nextNode());
        }
        VariableStack vars = this.m_execContext.getVarStack();
        int savedStart = vars.getStackFrame();
        vars.setStackFrame(this.m_stackFrame);
        if (-1 == this.m_firstWalker.getRoot()) {
            this.setNextPosition(0);
            this.m_firstWalker.setRoot(this.m_context);
            this.m_lastUsedWalker = this.m_firstWalker;
        }
        int n = this.returnNextNode(this.m_firstWalker.nextNode());
        vars.setStackFrame(savedStart);
        return n;
    }

    public final AxesWalker getFirstWalker() {
        return this.m_firstWalker;
    }

    public final void setLastUsedWalker(AxesWalker walker) {
        this.m_lastUsedWalker = walker;
    }

    public final AxesWalker getLastUsedWalker() {
        return this.m_lastUsedWalker;
    }

    public void detach() {
        this.m_lastUsedWalker = null;
        super.detach();
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        this.m_predicateIndex = -1;
        AxesWalker walker = this.m_firstWalker;
        while (null != walker) {
            walker.fixupVariables(vars, globalsSize);
            walker = walker.getNextWalker();
        }
    }
}

