/* 
   xls2xml: Converts from Microsoft Excel files to XML.
   Copyright 1999  Roberto Arturo Tena Sanchez

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published  by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
/* 
   Roberto Arturo Tena Sanchez <arturo@directmail.org>
 */
   
#ifndef FIL_DEFINES_H
#define FIL_DEFINES_H

#ifdef __cplusplus 
extern "C" {
#endif

   

/* to use as options in xls2xml() */
/* how much info will be extracted
   for parameters->extract_level */
#define EXTRACT_ALL    0
#define EXTRACT_NORMAL 1
/* how the reference mode will be reported */
/* leave as is in the original file */
#define REFMODE_AS_IS 0
/* always use letter for column and number for row */
#define REFMODE_A1    1
/* always use number for both column and row */
#define REFMODE_R1C1  2



/* max record size */
#define MAX_RECORD_SIZE 0x2024
/* = 8228, in BIFF8 */


/* biff versions
   this must agree with info saved in `p809.c'
   for parameters->biff_version */
#define BIFF_5_7 0x0500
#define BIFF_8   0x0600 



#ifdef __cplusplus
}
#endif

#endif /* FIL_DEFINES_H */
