set binder_clipList {}
set binder_clipMode copy

proc binder_send {c wx wy appName} {
	global ttblibPath stageColor panelColor binder_fStat
	global binder_browseMode binder_selList

	if {$binder_browseMode=="listMode"} {
		set starter $binder_selList
		set fname $starter
	} else {
		set starter [string range [lindex [$c gettags \
			[$c find overlapping $wx $wy $wx $wy]] 0] 3 end]
		set fname $binder_fStat($starter,path)
	}

	if {$starter==""} return

	eval exec $appName $fname &
}

proc binder_common_chDir {dir} {
	global binder_listMode_Current
	global binder_browseMode binder_title
	global binder_currentDir

	set dir [file nativename $dir]

	wm title . "$binder_title:$dir"

	binder_folderList $dir
	set binder_currentDir $dir

	if {$binder_browseMode=="listMode"} {
		binder_listMode $dir new
	} else {
		binder_iconMode $dir noInit
	}
}

proc binder_sendToTrash fName {
	send recycler.app trash_doDelete [list $fName]
	binder_reDraw
}

proc binder_acceptSel {c top} {
	global uim_selList

	catch [foreach i $uim_selList {
		$c itemconfigure txt$i -fill blue}]
}

proc binder_exec {} {
	global binder_selCurrentTag binder_fStat
	global binder_browseMode binder_listMode_Lists
	global binder_listMode_Current binder_listMode_dir

	if {$binder_browseMode=="listMode"} {
		set selList [.binder_container.f.l$binder_listMode_Current curselection]

		if {[llength $selList]==1} {
			if {[file isdirectory $binder_selCurrentTag]} {
				binder_common_chDir $binder_selCurrentTag
			} else {
				if2_execIF2 $binder_selCurrentTag exec
			}
		} elseif {[llength $selList]>1} {
			set binder_selCurrentTag {}

			foreach i $selList {
				set dname $binder_listMode_dir($binder_listMode_Current)
				set fname [lindex $binder_listMode_Lists($binder_listMode_Current) $i]
				set temp $dname/$fname

				if {[file isfile $temp]} {
					set binder_selCurrentTag [concat $binder_selCurrentTag $temp]
				}
			}

			binder_select multiExec {} 0 0
		}
	} else {
		if {[llength $binder_selCurrentTag]==1} {
			if {$binder_fStat($binder_selCurrentTag,stat)=="dir"} {
				binder_common_chDir $binder_fStat($binder_selCurrentTag,path)
			} else {
				if2_execIF2 $binder_fStat($binder_selCurrentTag,path) exec
			}

			binder_resetSel
		} elseif {[llength $binder_selCurrentTag]>1} {
			binder_select multiExec {} 0 0		
		}
	}
}

proc binder_cut {} {
	global binder_clipList binder_selCurrentTag
	global binder_fStat binder_clipMode binder_browseMode
	global binder_listMode_Current binder_listMode_Lists
	global binder_listMode_dir

	set binder_clipMode cut

	set binder_clipList {}
#	binder_acceptSel $tl $top

	if {$binder_browseMode=="listMode"} {
		set selList [.binder_container.f.l$binder_listMode_Current \
			curselection]
		if {$selList==""} {
			set binder_clipList $binder_selCurrentTag
		} else {
			set temp $binder_listMode_Lists($binder_listMode_Current)
			set temp2 $binder_listMode_dir($binder_listMode_Current)/
			foreach i $selList {
				set binder_clipList [concat $binder_clipList \
					$temp2[lindex $temp $i]]
			}
		}
	} else {
		foreach i $binder_selCurrentTag {
			set binder_clipList \
				[concat $binder_clipList $binder_fStat($i,path)]
		}
	}
}

proc binder_copy {} {
	global binder_clipList binder_selCurrentTag
	global binder_fStat binder_clipMode binder_browseMode
	global binder_listMode_Current binder_listMode_Lists
	global binder_listMode_dir

	set binder_clipMode copy

	set binder_clipList {}
#	binder_acceptSel $tl $top

	if {$binder_browseMode=="listMode"} {
		set selList [.binder_container.f.l$binder_listMode_Current \
			curselection]
		if {$selList==""} {
			set binder_clipList $binder_selCurrentTag
		} else {
			set temp $binder_listMode_Lists($binder_listMode_Current)
			set temp2 $binder_listMode_dir($binder_listMode_Current)/
			foreach i $selList {
				set binder_clipList [concat $binder_clipList \
					$temp2[lindex $temp $i]]
			}
		}
	} else {
		foreach i $binder_selCurrentTag {
			set binder_clipList \
				[concat $binder_clipList $binder_fStat($i,path)]
		}
	}
}

proc binder_inspector {c x y wx wy} {
	global ttblibPath stageColor panelColor binder_fStat
	global binder_browseMode binder_selList
	global binder_selCurrentTag binder_fStat
	global binder_browseMode binder_listMode_Lists
	global binder_listMode_Current binder_listMode_dir

	if {$binder_browseMode=="listMode"} {
		set starter $binder_selList
		set fname $starter
	} else {
		set starter [string range [lindex [$c gettags \
			[$c find overlapping $wx $wy $wx $wy]] 0] 3 end]
		set fname $binder_fStat($starter,path)
	}

	if {$starter==""} return

	if {[llength $fname]==1} {
		binder_showInspector $fname
	}
}

proc binder_paste {} {
	global binder_clipList binder_currentDir binder_clipMode

	if {$binder_clipMode=="copy"} {
		eval file copy -force -- $binder_clipList $binder_currentDir/
	} else {
		eval file rename -force -- $binder_clipList $binder_currentDir/
	}

	set binder_clipList {}

	binder_reDraw
}

proc binder_delete {} {
	global binder_clipList binder_selCurrentTag
	global binder_listMode_Current binder_listMode_Lists
	global binder_fStat binder_clipMode binder_browseMode
	global binder_listMode_dir

	if {$binder_browseMode=="listMode"} {
		set selList [.binder_container.f.l$binder_listMode_Current \
			curselection]
		if {$selList==""} {
			set ret [tk_dialog .deleteOK "Delete file" \
				"Delete file $binder_selCurrentTag ?" \
				info 0 Cancel OK]

			if {$ret!=0} {
				eval file delete -force -- $binder_selCurrentTag
			}
		} else {
			set temp $binder_listMode_Lists($binder_listMode_Current)
			foreach i $selList {
				set tempFName $binder_listMode_dir($binder_listMode_Current)/[lindex $temp $i]

				set ret [tk_dialog .deleteOK "Delete file" \
					"Delete file $tempFName ?" \
					info 0 Cancel OK]

				if {$ret!=0} {
					eval file delete -force -- $tempFName
				}
			}
		}
	} else {
		foreach i $binder_selCurrentTag {
			set ret [tk_dialog .deleteOK "Delete file" \
				"Delete file $binder_fStat($i,path) ?" \
				info 0 Cancel OK]

			if {$ret!=0} {
				eval file delete -force -- $binder_fStat($i,path)
			}
		}
	}

	binder_reDraw
}

proc binder_mkAlias {fname} {
	if {[file isfile $fname]==1} {
		exec ln -s $fname "$fname.aliasFile"
	} else {
		exec ln -s $fname "$fname.aliasFolder"
	}

	binder_reDraw
}

proc binder_mkCopy {fname} {
	if {[file isfile $fname]==1} {
		file copy -force -- $fname "$fname.copyFile"
	} else {
		file copy -force -- $fname "$fname.copyFolder"
	}

	binder_reDraw
}

proc binder_rename_sub {fname} {
	set newName [.inputNewName.enter get]

	file rename -force -- $fname [file dirname $fname]/$newName

	binder_reDraw
	destroy .inputNewName
}

proc binder_rename {c x y wx wy} {
	global ttblibPath stageColor panelColor binder_fStat
	global binder_browseMode binder_selList

	if {$binder_browseMode=="listMode"} {
		set starter $binder_selList
		set fname $starter
	} else {
		set starter [string range [lindex [$c gettags \
			[$c find overlapping $wx $wy $wx $wy]] 0] 3 end]
		set fname $binder_fStat($starter,path)
	}

	if {$starter==""} return

	toplevel .inputNewName -bd 10 -relief flat -bg $panelColor
	wm geometry .inputNewName +$x+$y
	grab .inputNewName

	wm title .inputNewName "rename"

	label .inputNewName.label -text "Enter new file name" \
		-bd 0 -bg $panelColor

	entry .inputNewName.enter -width 32 -relief sunken -bd 2
	.inputNewName.enter insert end [file tail $fname]

	pack .inputNewName.label .inputNewName.enter -fill both

	bind .inputNewName.enter <Any-Return>  "binder_rename_sub $fname"
}

proc sub_touchFile {mode} {
	global binder_currentDir

	set touchName [.inputTouchName.enter get]

	switch $mode {
		"file" {
			exec touch $binder_currentDir/$touchName
		}
		"folder" {
			catch "file mkdir $binder_currentDir/$touchName"
		}
	}

	binder_reDraw
	destroy .inputTouchName
}

proc binder_touchFile {mode x y} {
	global ttblibPath stageColor panelColor

	toplevel .inputTouchName -bd 10 -relief flat -bg $panelColor
	wm geometry .inputTouchName +$x+$y
	grab .inputTouchName

	wm title .inputTouchName "create"

	label .inputTouchName.label -text "Enter new file name" -bd 0 -bg $panelColor

	entry .inputTouchName.enter -width 32 -relief sunken -bd 2
	pack .inputTouchName.label .inputTouchName.enter -fill both

	bind .inputTouchName.enter <Any-Return>  "sub_touchFile $mode"
}

