#
# if2 the suffix database system module
#
#					Copyleft 1998,1999 Jun Wakaya
#

set if2_newType(dummy) {}

proc binder_if2Conf_accept {} {
	global if2Ext if2Mod if2Icn if2Com if2Opt if2Inf
	global if2_newType GLPath

	set if2_newType(com) [.if2.f0.e0 get]
	set if2_newType(opt) [.if2.f0.e1 get]
	set if2_newType(inf) [.if2.f0.e2 get]

	if {$if2_newType(com)==""} {
		if {$if2_newType(icn)==""} {
			set if2_newType(icn) "File"
		}

		if {$if2_newType(inf)==""} {
			set if2_newType(inf) "Autobinded to Muggy"
		}

		set if2_newType(com) "Muggy.app"
	}

	set if2Ext [concat $if2Ext $if2_newType(ext)]
	set if2Mod [concat $if2Mod $if2_newType(mod)]
	set if2Icn [concat $if2Icn $if2_newType(icn)]
	set if2Com [concat $if2Com $if2_newType(com)]
	set if2Opt [concat $if2Opt $if2_newType(opt)]
	set if2Inf [concat $if2Inf \{$if2_newType(inf)\}]

	set if2fs [open $GLPath/suffix.if2 w]

	for {set i 0} {$i<[llength $if2Ext]} {incr i} {
		if {[lindex $if2Ext $i]==""} continue
		puts $if2fs "[lindex $if2Ext $i],[lindex $if2Mod $i],[lindex $if2Icn $i],[lindex $if2Com $i],[lindex $if2Opt $i],[lindex $if2Inf $i]"
	}

	close $if2fs

	destroy .if2
	binder_reDraw
}

proc binder_if2Conf_selIcon_sub icnName {
	global if2_newType

	if {![winfo exists .if2]} {
		destroy .iconL
		return
	}

	set if2_newType(icn) $icnName

	.if2.f0.b0 configure -image $if2_newType(icn)
	destroy .iconL
	return
}

proc binder_if2Conf_selIcon {} {
	global if2Ext if2Mod if2Icn if2Com if2Opt if2Inf
	global panelColor panelText stageColor stageText

	set tl .iconL

	if {[winfo exists $tl]} {
		raise $tl
		return
	}

	toplevel $tl
	wm title $tl "Icon selector"

	grid [scrollbar $tl.sb0 -orient vertical -command "$tl.c0 yview"] \
		-column 0 -row 0 -sticky news

	grid [canvas $tl.c0 -yscrollcommand "$tl.sb0 set"] \
		-column 1 -row 0 -sticky news

	for {set i 0} {$i<[llength [image names]]} {incr i} {
		set temp [lindex [lsort [image names]] $i]

		$tl.c0 create text 16 [expr 80+$i*80] \
			-text $i -tags if$i
		$tl.c0 create image 80 [expr 80+$i*80] \
			-image $temp -tags if$i
		$tl.c0 create text 180 [expr 80+$i*80] \
			-text $temp -tags if$i
		$tl.c0 configure -scrollregion "0 0 0 [expr 128+$i*80]"

		$tl.c0 bind if$i <Double-ButtonRelease-1> "binder_if2Conf_selIcon_sub $temp"
	}
}

proc binder_if2Conf {mode suf} {
	global if2Ext if2Mod if2Icn if2Com if2Opt if2Inf
	global panelColor panelText stageColor stageText
	global autoUpdateFlag
	global if2_newType

	set autoUpdateFlag false

	set suf [string range [file extension $suf] 1 end]

	set tl .if2

	if {[winfo exists $tl]} {raise $tl;return}

	set if2_newType(ext) $suf
	set if2_newType(mod) "00"
	set if2_newType(icn) "FileUnknown"
	set if2_newType(com) {}
	set if2_newType(opt) {}
	set if2_newType(inf) {Unknown type}

	toplevel $tl -bd 5 -bg $panelColor

	wm title $tl "IF2 suffix database system configurator:$suf"
	wm protocol $tl WM_DELETE_WINDOW "binder_if2Conf_exit $tl"

	if {$mode!="new"} {
		grid [scrollbar .if2.sb0 -orient vertical -command ".if2.lb0 yview"] \
			-column 0 -row 0 -sticky news
		grid [listbox .if2.lb0 -width 32 -bg $stageColor -fg $stageText\
			-xscrollcommand ".if2.sb1 set" \
			-yscrollcommand ".if2.sb0 set"] \
			-column 1 -row 0 -sticky news
		grid [scrollbar .if2.sb1 -orient horizontal -command ".if2.lb0 xview"] \
			-column 1 -row 1 -sticky news

		foreach i $if2Ext {
			.if2.lb0 insert end $i
		}
#		.if2.lb0 yview moveto 1.0
#		.if2.lb0 selection set end end
	}

	grid [frame .if2.f0 -bg $panelColor -width 128 -bd 5] \
		-column 2 -row 0 -sticky news

	pack [label .if2.f0.l0 -text "File Type: $suf"] -fill both
	pack [button .if2.f0.b0 -image FileUnknown \
		-command binder_if2Conf_selIcon]

	binder_coolbutton .if2.f0.b0

	pack [label .if2.f0.l1 -text "Command :"] -fill both
	pack [entry .if2.f0.e0] -fill both
	pack [label .if2.f0.l2 -text "Option :"] -fill both
	pack [entry .if2.f0.e1] -fill both
	pack [label .if2.f0.l3 -text "Comments"] -fill both
	pack [entry .if2.f0.e2] -fill both

	.if2.f0.e2 insert end $if2_newType(inf)

	grid [frame .if2.f1 -bg $panelColor -bd 5] \
		-column 0 -row 2 -columnspan 3 -sticky news

	pack [button .if2.f1.b1 -text "Cancel" -command "destroy .if2" \
		-fg $panelText -bg $panelColor] \
		[button .if2.f1.b0 -text "Ok" -default active \
		-fg $panelText -bg $panelColor -command "binder_if2Conf_accept"] \
		-padx 5 -side right -fill both
}

proc binder_if2Conf_exit {tl} {
	global autoUpdateFlag autoUpdateFlagDefault

	set autoUpdateFlag $autoUpdateFlagDefault
	destroy $tl

	if {[winfo exists .iconL]} {
		destroy .iconL
	}
}

proc if2_truncateList {pList} {

	set retList {}

	foreach i $pList {
		if {$i == {}} {
			continue
		}

		catch [set retList [concat $retList $i]]
	}

	return $retList
}

proc if2_clearIF2 {} {
	global if2Ext if2Mod if2Icn if2Com if2Opt if2Inf

	foreach i {if2Ext if2Mod if2Icn if2Com if2Opt if2Inf} {
		set $i {}
	}
}

proc if2_readIF2 {} {

	global ttblibPath if2Ext if2Mod if2Icn if2Com if2Opt if2Inf
	global if2_allExt GLPath

	if2_clearIF2

	set if2fs [open $GLPath/suffix.if2 r]
	set line [gets $if2fs]

	if {[string index $line 0]!="#"} {
		set temp [split $line ,]

		set if2Ext "$if2Ext [list [lindex $temp 0]]"
		set if2Mod "$if2Mod [list [lindex $temp 1]]"
		set if2Icn "$if2Icn [list [lindex $temp 2]]"
		set if2Com "$if2Com [list [lindex $temp 3]]"
		set if2Opt "$if2Opt [list [lindex $temp 4]]"
		set if2Inf "$if2Inf [list [lindex $temp 5]]"
	}

	while {![eof $if2fs]} {
		set line [gets $if2fs]

		if {[string range $line 0 0]!="#"} {
			set temp [split $line ,]

			set if2Ext "$if2Ext [list [lindex $temp 0]]"
			set if2Mod "$if2Mod [list [lindex $temp 1]]"
			set if2Icn "$if2Icn [list [lindex $temp 2]]"
			set if2Com "$if2Com [list [lindex $temp 3]]"
			set if2Opt "$if2Opt [list [lindex $temp 4]]"
			set if2Inf "$if2Inf [list [lindex $temp 5]]"
		} else {
			continue
		}
	}
	close $if2fs

	foreach i [split $if2Ext :] {
		set if2_allExt [concat $if2_allExt $i]
	}

#	set if2Ext [if2_truncateList $if2Ext]
#	set if2Mod [if2_truncateList $if2Mod]
#	set if2Icn [if2_truncateList $if2Icn]
#	set if2Com [if2_truncateList $if2Com]
#	set if2Opt [if2_truncateList $if2Opt]
#	set if2Inf [if2_truncateList $if2Inf]
}

proc if2_exchangeIF2 {sufG if2List} {
	global if2_allExt GLPath

	set if2fs [open $GLPath/suffix.if2 r]
	set if2Buf [read -nonewline $if2fs]
	set if2Out {}

	set if2fs [open $GLPath/suffix.if2 w]

	foreach i [split $if2Buf \n] {
		if {[string range $i 0 0]!="#"} {
			if {[string first $sufG $i]=="0"} {
				puts $if2fs $if2List
			} else {
				puts $if2fs $i
			}
		}
	}

	close $if2fs

	if2_readIF2
}

proc if2_execIF2 {flist mode} {

	global ttblibPath if2Ext if2Mod if2Icn if2Com if2Opt if2Inf

	set dataList {}
	set cmdLines {}
	set success {}

	eval set flist $flist

	foreach k $flist {
	  set ext [string range [file extension $k] 1 end]

	  for {set i 0} {$i<[llength $if2Ext]} {incr i} {
	    foreach j [split [lindex $if2Ext $i] :] {
	      if {$ext == $j} {
	        switch $mode {
		  "exec" {
			if {[file extension $k]!=".sh"} {
				eval exec $cmdLines [lindex [split [lindex $if2Com $i] :] 0] $k [lindex [lindex $if2Opt $i] 0] &
			}
			set success 1
		  }

		  "edit" {
			eval exec $cmdLines [lindex [split [lindex $if2Com $i] :] 1] $k [lindex [lindex $if2Opt $i] 1] &
			set success 1
		  }
	        }
	      }
	    }
	  }

	  if {$success==""} {
		if {[string range [file tail $k] 0 0]=="."} {
			eval exec Muggy.app $k &
			return
		}

		if {[file executable $k]} {
			eval exec $k &
		} elseif {[file extension $k]=={}} {
			eval exec Muggy.app $k &
		} else {
			binder_if2Conf new $k
		}
	  }

	  set success {}
	}
}

proc if2_getIcon {flist} {

	global ttblibPath if2Ext if2Mod if2Icn if2Com if2Opt if2Inf
	global if2_allExt

	set icnLists {}
	set extLists {}

	foreach i $flist {
		set extLists [concat $extLists [list [string range [file extension $i] 1 end]]]
	}

	set tempVal [llength $if2Ext]

	foreach i $extLists {
	  if {[string range $i end end] == {}} {
		set icnLists [concat $icnLists File]
		continue
	  }

	  if {[string range $i end end] == "~"} {
		set icnLists [concat $icnLists FileBlank]
		continue
	  }

	  set k 0
	  foreach j $if2Ext {
	    foreach l [split $j :] {
		if {[string match $i $l]} {
			set icnLists [concat $icnLists [lindex $if2Icn $k]]
			continue
		}
	    }
	    incr k
	  }
	}

	for {set i 0} {$i<[llength [list $icnLists]]} {incr i} {
		if {[lindex [list $icnLists] $i]=={}} {
			set icnLists [lreplace $icnLists $i $i FileUnknown]
		}
	}

	return $icnLists
}

proc if2_getAppName {flist} {

	global ttblibPath if2Ext if2Mod if2Icn if2Com if2Opt if2Inf
	global if2_allExt

	set appLists {}
	set extLists {}

	foreach i $flist {
		set extLists [concat $extLists [list [string range [file extension $i] 1 end]]]
	}

	set tempVal [llength $if2Ext]

	foreach i $extLists {
	  if {[string range $i end end] == {}} {
		set appLists [concat $appLists Muggy.app]
		continue
	  }

	  if {[string range $i end end] == "~"} {
		set appLists [concat $appLists Muggy.app]
		continue
	  }

	  set k 0
	  foreach j $if2Ext {
	    foreach l [split $j :] {
		if {[string match $i $l]} {
			set appLists [concat $appLists [lindex $if2Com $k]]
			continue
		}
	    }
	    incr k
	  }
	}

	for {set i 0} {$i<[llength [list $appLists]]} {incr i} {
		if {[lindex [list $appLists] $i]=={}} {
			set appLists [lreplace $appLists $i $i None]
		}
	}

	return $appLists
}

proc if2_getSufNames {flist} {

	global ttblibPath if2Ext if2Mod if2Icn if2Com if2Opt if2Inf
	global if2_allExt

	set ext [string range [file extension $flist] 1 end]

	if {[string range $ext end end] == {}} {return}

	if {[string range $ext end end] == "~"} {
		return Muggy.app
	}

	set k 0
	foreach j $if2Ext {
		foreach l [split $j :] {
			if {[string match $ext $l]} {
				return $j
			}
		}
		incr k
	}

	return error
}

proc if2_getOptions {flist} {
	global ttblibPath if2Ext if2Mod if2Icn if2Com if2Opt if2Inf
	global if2_allExt

	set ext [string range [file extension $flist] 1 end]

	if {[string range $ext end end] == {}} {return {}}
	if {[string range $ext end end] == "~"} {return {}}

	set k 0
	foreach j $if2Ext {
		foreach l [split $j :] {
			if {[string match $ext $l]} {
				return [lindex $if2Opt $k]
			}
		}
		incr k
	}

	return error
}

proc if2_getInfomation {flist} {
	global ttblibPath if2Ext if2Mod if2Icn if2Com if2Opt if2Inf
	global if2_allExt

	set ext [string range [file extension $flist] 1 end]

	if {[string range $ext end end] == {}} {return {}}
	if {[string range $ext end end] == "~"} {return {}}

	set k 0
	foreach j $if2Ext {
		foreach l [split $j :] {
			if {[string match $ext $l]} {
				return [lindex $if2Inf $k]
			}
		}
		incr k
	}

	return error
}

proc if2_call {command param} {

#	The command name is binded to $command.
#	The list of the filenames are binded to $param.

	switch $command {
		"exec" {
			if2_execIF2 $param exec
		}


		"edit" {
			if2_execIF2 $param edit
		}


		"icon" {
			return [if2_getIcon $param]
		}

		"refresh" {
			if2_readIF2
		}
	}
}

set ttbTerm {}
if2_clearIF2
set if2_allExt {}
if2_readIF2

