#
# List Mode
#
#				Copyleft 1999.03.03~ Jun Wakaya
#

set binder_listMode_Current 0
set binder_listMode_focus(dummy) {}
set binder_listMode_Max 3
set binder_listMode_Lists(dummy) {}
set binder_listMode_dir(dummy) {}

proc binder_listMode_disp {dir} {
	global env binder_browseMode binder_title
	global stageColor stageText
	global binder_listMode_Current binder_listMode_Max
	global binder_listMode_Lists binder_listMode_dir
	global binder_selCurrentTag
	global autoUpdateFlag autoUpdateFlagDefault

	set tl .binder_container.f.c

	set pList [file split $dir]

	for {set j 0} {$j<[llength $pList]} {incr j} {
		set ltemp l$j

		set ltemp [listbox $f.l$j -bg $stageColor -fg $stageText \
			-width 27 -yscrollcommand "$f.sb$j set" \
			-selectmode multiple]

		set stemp [scrollbar $f.sb$j -orient vertical \
			-command "$f.l$j yview"]

		$tl create window [expr $j*160] 0 -anchor nw -window stemp
		$tl create window [expr $j*160] 0 -anchor nw -window ltemp

		scrollbar $f.sb$j -orient vertical -command "$f.l$j yview"
		pack $f.sb$j -side left -fill both
		pack $f.l$j -side left -fill both
	}
}

proc binder_listMode {dir switch} {
return

	global env binder_browseMode binder_title
	global stageColor
	global binder_listMode_Current binder_listMode_Max
	global binder_listMode_Lists binder_listMode_dir
	global binder_selCurrentTag
	global autoUpdateFlag autoUpdateFlagDefault

	set autoUpdateFlag false

	set dir [file nativename $dir]

	wm title . "$binder_title:$dir"

	set binder_selCurrentTag {}
	set binder_browseMode listMode
	set f .binder_container.f

	if {$switch=="new"} {
		set binder_listMode_Current 0
	} elseif {$switch=="upDate"} {
		$f.l$binder_listMode_Current delete 0 end

		binder_listMode_disp $f $binder_listMode_Current $dir
		return
	}

	if [winfo exists $f] {
		destroy $f
	}

	pack [frame $f -bg $stageColor] -fill both -expand true

	pack [canvas $f.c -xscrollcommand "$f.sb set"] \
		-fill both -expand true
	pack [scrollbar $f.sb -command "$f.c xview" -orient horizontal] \
		-fill x

	binder_listMode_disp $dir

	set autoUpdateFlag $autoUpdateFlagDefault
}
