set binder_shortCut_currentItem {}
set binder_shortCut_itemTitle(dummy) {}
set binder_shortCut_itemFile(dummy) {}
set binder_shortCut_itemIcon(dummy) {}
set binder_shortCut_specialID 0

proc binder_shortCut_linuxSpecial_sub {} {
	global binder_shortCut_specialID

	set mList {}

	set procFP [open /proc/mounts r]

	foreach i [split [read -nonewline $procFP] \n] {
		if {[lindex $i 0]!="none"} {
			if {[lindex $i 0]!="/dev/root"} {
				set mList [concat $mList [list $i]]
			}
		}
	}

	close $procFP

	return $mList
}

proc binder_shortCut_linuxSpecial {} {
	global ttblibPath env
	global binder_shortCut_itemTitle
	global binder_shortCut_itemFile
	global binder_shortCut_itemIcon
	global binder_shortCut_specialID
	global panelText

	set iconDir $ttblibPath/icons
	set c .binder_container.shortcuts

	set margin1 12
	set margin2 40
	set margin3 24

	set mList [binder_shortCut_linuxSpecial_sub]
	set backmList $mList
	set binder_shortCut_specialID [llength $mList]

	set ID 1

	foreach i $mList {
		if {![file exists [lindex $i 0]]} {
			continue
		}

		set tempTitle [string range [lindex $i 0] 5 end]

		set binder_shortCut_itemTitle($ID) $tempTitle
		set binder_shortCut_itemFile($ID) [lindex $i 1]

		if {[string range $tempTitle 0 1]=="sd"} {
			set binder_shortCut_itemIcon($ID) DiskSCSI
		} elseif {[string range $tempTitle 0 1]=="hd"} {
			set binder_shortCut_itemIcon($ID) DiskSCSI
		} elseif {[string range $tempTitle 0 1]=="fd"} {
			set binder_shortCut_itemIcon($ID) DiskFloppy
		} elseif {[string range $tempTitle 1 2]=="cd"} {
			set binder_shortCut_itemIcon($ID) DiskCD
		}

		$c create image [expr 112*$ID+$margin1+$margin2] $margin3 \
			-tags binder_shortCutG$ID -image $binder_shortCut_itemIcon($ID)
		$c create text [expr 112*$ID+$margin1+$margin2] [expr $margin3+36] \
			-tags binder_shortCutT$ID -fill $panelText\
			-text $binder_shortCut_itemTitle($ID)

		if {[file isdirectory $binder_shortCut_itemFile($ID)]} {
			$c bind binder_shortCutG$ID <Double-ButtonRelease-1> \
				"binder_common_chDir $binder_shortCut_itemFile($ID)"
		} else {
			$c bind binder_shortCutG$ID <Double-ButtonRelease-1> \
				"if2_execIF2 $binder_shortCut_itemFile($ID) exec"
		}

		$c bind binder_shortCutG$ID <Enter> "\
			binder_shortCut_itemEnter $c $ID"

		$c bind binder_shortCutG$ID <Leave> "\
			binder_shortCut_itemLeave $c $ID"

		incr ID
	}

	return $ID
}

proc binder_shortCut_FreeBSDSpecial_sub {} {
	global binder_shortCut_specialID

	set mList {}

	set mounted [split [exec mount] \n]

	foreach i $mounted {
		if {[lindex $i 2]!="/"} {
			if {[string range $i 0 0]=="/"} {
				set mList [concat $mList \{[lindex $i 0] [file nativename [lindex $i 2]/] dummy dummy 0 0\}]
			}
		}
	}

	return $mList
}

proc binder_shortCut_FreeBSDSpecial {} {
	global ttblibPath env
	global binder_shortCut_itemTitle
	global binder_shortCut_itemFile
	global binder_shortCut_itemIcon
	global binder_shortCut_specialID
	global panelText

	set iconDir $ttblibPath/icons
	set c .binder_container.shortcuts

	set margin1 12
	set margin2 40
	set margin3 24

	set mList [binder_shortCut_FreeBSDSpecial_sub]
	set backmList $mList
	set binder_shortCut_specialID [llength $mList]

	set ID 1

	foreach i $mList {
		set i [join $i]

		if {![file exists [lindex $i 0]]} {
			continue
		}

		set tempTitle [string range [lindex $i 0] 5 end]

		set binder_shortCut_itemTitle($ID) $tempTitle
		set binder_shortCut_itemFile($ID) [lindex $i 1]

		if {[string range $tempTitle 0 1]=="fd"} {
			set binder_shortCut_itemIcon($ID) DiskFloppy
		} elseif {[string range $tempTitle 0 1]=="cd"} {
			set binder_shortCut_itemIcon($ID) DiskCD
		} else {
			continue
		}

		$c create image [expr 112*$ID+$margin1+$margin2] $margin3 \
			-tags binder_shortCutG$ID -image $binder_shortCut_itemIcon($ID)
		$c create text [expr 112*$ID+$margin1+$margin2] [expr $margin3+36] \
			-tags binder_shortCutT$ID -fill $panelText\
			-text $binder_shortCut_itemTitle($ID)

		if {[file isdirectory $binder_shortCut_itemFile($ID)]} {
			$c bind binder_shortCutG$ID <Double-ButtonRelease-1> \
				"binder_common_chDir $binder_shortCut_itemFile($ID)"
		} else {
			$c bind binder_shortCutG$ID <Double-ButtonRelease-1> \
				"if2_execIF2 $binder_shortCut_itemFile($ID) exec"
		}

		$c bind binder_shortCutG$ID <Enter> "\
			binder_shortCut_itemEnter $c $ID"

		$c bind binder_shortCutG$ID <Leave> "\
			binder_shortCut_itemLeave $c $ID"

		incr ID
	}

	return $ID
}

proc binder_shortCut_itemEnter {c ID} {
	global binder_shortCut_currentItem

	set binder_shortCut_currentItem $ID
	$c itemconfigure binder_shortCutT$ID -fill #00ff00
}

proc binder_shortCut_itemLeave {c ID} {
	global binder_shortCut_currentItem
	global panelText

	set binder_shortCut_currentItem {}
	$c itemconfigure binder_shortCutT$ID -fill $panelText
}

proc binder_shortCut_deleteShortCut {widget ID} {
	global ttblibPath GLPath
	global binder_shortCut_currentItem
	global binder_shortCut_itemTitle
	global binder_shortCut_itemFile
	global binder_shortCut_itemIcon
	global binder_shortCut_specialID

	set binder_shortCut_currentItem {}
	set binder_shortCut_itemTitle($ID) {}
	set binder_shortCut_itemFile($ID) {}
	set binder_shortCut_itemIcon($ID) {}

	if [file exists $GLPath/shortcut] {
		set ttbitm [open $GLPath/shortcut r]
		set ttbitmBuf [read -nonewline $ttbitm]
		close $ttbitm
	} else {
		puts error
		return
	}
	set ttbitmBuf [split $ttbitmBuf \n]

	set ttbitm [open $GLPath/shortcut w]

	for {set i 0} {$i<[llength $ttbitmBuf]} {incr i} {
		if {[expr $ID - (1+$binder_shortCut_specialID)]!=$i} {
			puts $ttbitm [lindex $ttbitmBuf $i]
		}
	}

	close $ttbitm

	$widget delete all
	binder_shortCut
}

proc binder_shortCut_makeNewShortCut {data} {
	global ttblibPath GLPath

	set iconDir $ttblibPath/icons

	if [file exists $GLPath/shortcut] {
		set ttbitm [open $GLPath/shortcut a]
	} else {
		set ttbitm [open $GLPath/shortcut w]
	}

	if {[file isdirectory $data]} {
		if {[file exists $data/.dir.gif]} {
			if {![winfo exists dir$data]} {
				image create photo dir$data -file $data/.dir.gif
			}
			set icnName $data
		} else {
			set icnName Folder
		}
	} else {
		if {[file executable $data]} {
			set icnName [binder_appIconInfo $data]
		} else {
			set icnName [if2_call icon $data]
		}
	}

	puts $ttbitm "[file tail $data];$data;$icnName"

	close $ttbitm
}

proc binder_shortCut_send {fName dist} {
	switch [file type $dist] {
		file {
			if {[file executable $dist]} {
				eval exec $dist $fName &
			}
		}

		directory {
			eval file copy -force -- $fName $dist
		}

		default {
			eval exec $dist $fName &
		}
	}
}

proc binder_shortCut_Drop {data type widget} {
	global binder_shortCut_currentItem
	global binder_shortCut_itemTitle
	global binder_shortCut_itemFile
	global binder_shortCut_itemIcon

	if {$type!="File"} return

	set label [$widget itemcget binder_shortCutT$binder_shortCut_currentItem -text]

	if {$binder_shortCut_currentItem=={}} {
		binder_shortCut_makeNewShortCut $data
	} else {
		binder_shortCut_send $data $binder_shortCut_itemFile($binder_shortCut_currentItem)
	}

	$widget delete all
	binder_shortCut
}

proc binder_shortCut {} {
	global ttblibPath GLPath env
	global binder_shortCut_itemTitle
	global binder_shortCut_itemFile
	global binder_shortCut_itemIcon
	global panelText

	set iconDir $ttblibPath/icons
	set c .binder_container.shortcuts

	$c delete all

	set margin1 12
	set margin2 40
	set margin3 24

	set ID 0

	set binder_shortCut_itemTitle(0) [exec whoami]
	set binder_shortCut_itemFile(0) $env(HOME)
	set binder_shortCut_itemIcon(0) Home

	$c create image [expr $margin1+$margin2] $margin3 \
		-tags binder_shortCutG0 -image $binder_shortCut_itemIcon(0)
	$c create text [expr $margin1+$margin2] [expr $margin3+36] \
		-fill $panelText \
		-tags binder_shortCutT0 -text $binder_shortCut_itemTitle(0)

	$c bind binder_shortCutG0 <Double-ButtonRelease-1> {
		binder_common_chDir $binder_shortCut_itemFile(0)
	}

	$c bind binder_shortCutG0 <Enter> "\
		binder_shortCut_itemEnter $c 0"

	$c bind binder_shortCutG0 <Leave> "\
		binder_shortCut_itemLeave $c 0"

	incr ID


	switch [exec uname] {
		"Linux" {
			set ID [binder_shortCut_linuxSpecial]
		}

		"FreeBSD" {
			set ID [binder_shortCut_FreeBSDSpecial]
		}
	}

	if [file exists $GLPath/shortcut] {

		set ttbitm [open $GLPath/shortcut r]
		set line [split [gets $ttbitm] \;]

		while {![eof $ttbitm]} {
			set binder_shortCut_itemTitle($ID) [lindex $line 0]
			set binder_shortCut_itemFile($ID) [lindex $line 1]
			set binder_shortCut_itemIcon($ID) [lindex $line 2]

	if {[string range [lindex $line 2] 0 0]=="/"} {
		if {![winfo exists dir[lindex $line 2]]} {
			image create photo dir[lindex $line 2] -file [lindex $line 2]/.dir.gif
		}
		set binder_shortCut_itemIcon($ID) dir[lindex $line 2]
	}












			$c create image [expr 112*$ID+$margin1+$margin2] $margin3 \
				-tags binder_shortCutG$ID -image $binder_shortCut_itemIcon($ID)
			$c create text [expr 112*$ID+$margin1+$margin2] [expr $margin3+36] \
				-tags binder_shortCutT$ID -text $binder_shortCut_itemTitle($ID)

			if {[file isdirectory $binder_shortCut_itemFile($ID)]} {
				$c bind binder_shortCutG$ID <Double-ButtonRelease-1> \
					"binder_common_chDir $binder_shortCut_itemFile($ID)"
			} else {
				$c bind binder_shortCutG$ID <Double-ButtonRelease-1> \
					"if2_execIF2 $binder_shortCut_itemFile($ID) exec"
			}

			$c bind binder_shortCutG$ID <Enter> "\
				binder_shortCut_itemEnter $c $ID"

			$c bind binder_shortCutG$ID <Leave> "\
				binder_shortCut_itemLeave $c $ID"

#			$c bind binder_shortCutG$ID <ButtonRelease-3> "\
#				binder_shortCut_deleteShortCut $c $ID"


			set line [split [gets $ttbitm] \;]
			incr ID
		}
		close $ttbitm
	}

	bind $c <Drop> "binder_shortCut_Drop %D %P %W"
}

