proc binder_coolbutton {b} {
	$b configure -relief flat -highlightthickness 0

	bind $b <Enter> {
		if {[%W cget -state]!="disabled"} {
			%W configure -relief raise
		}
	}
	bind $b <Leave> {%W configure -relief flat}
}

proc binder_Pref {} {
	set ret [binder_Preference]

	if {$ret=="0"} {
		binder_rePref
	}
}

proc binder_rePref {} {
	global ttblibPath
	global panelColor stageColor
	global panelText stageText
	global frameWidth frameHeight
	global stageWidth stageHeight
	global itemWidth itemHeight
	global binder_title binder_browseMode
	global binder_currentDir LANG
	global binder_upDateInterval
	global applicon

	source $ttblibPath/modules/title.$LANG
	source $ttblibPath/modules/filter$LANG.m
	source $ttblibPath/modules/inspector$LANG.m
	source $ttblibPath/modules/prefBinder$LANG.m

	wm title . "$binder_title:$binder_currentDir"

	.binder_spacerTop configure -bg $panelColor
	.binder_spacerLeft configure -bg $panelColor
	.binder_container configure -bg $panelColor
	.binder_container.shortcuts configure -bg $panelColor
	.binder_container.folderS configure -bg $stageColor
	.binder_spacerMiddle configure -bg $panelColor
	.binder_spacerRight configure -bg $panelColor

	binder_folderList $binder_currentDir
	binder_$binder_browseMode $binder_currentDir new

	if {$applicon=="true"} {
		wm group . .
	} else {
		wm group . {}
	}
}

proc binder_SequencialUpDate {} {
	global binder_upDateInterval autoUpdateFlag

	if {$autoUpdateFlag} {
		binder_reDraw
	}

	after $binder_upDateInterval binder_SequencialUpDate
}

proc binder_Configure {} {
	global frameWidth frameHeight stageWidth stageHeight

	set configured false
	set width [winfo width .];set height [winfo height .]

	if {$width!=$frameWidth} {
		set frameWidth $width;set configured true
	}

	if {$height!=$frameHeight} {
		set frameHeight $height;set configured true
	}

	if {$configured} {
		set stageWidth [expr $frameWidth-32]
		set stageHeight [expr $frameHeight-200]
		binder_reDraw
	}
}

proc binder_reDraw {} {
	global binder_browseMode binder_currentDir

	binder_shortCut

	if {$binder_browseMode=="listMode"} {
		binder_listMode $binder_currentDir upDate
	} else {
		binder_iconMode $binder_currentDir noInit
	}
}

proc binder_reDraw2 {} {
	global binder_currentDir

	binder_shortCut

	binder_listMode $binder_currentDir new
}

proc binder_exit {} {
	exit
#	return
}

wm protocol . WM_DELETE_WINDOW {binder_exit}
