set binder_iconMode_dir {}
set binder_selCurrentTag {}

proc binder_iconMode_Drop {data c x y btn} {
	global binder_selCurrentTag binder_fStat
	global binder_browseMode binder_selList
	global binder_currentDir

	set x [$c canvasx $x]
	set y [$c canvasy $y]

	switch $btn {
		1 {set fMode "rename"}
		2 {set fMode "copy"}
	}

	if {$binder_browseMode=="listMode"} {
		set starter $binder_selList
	} else {
		set starter [string range [lindex [$c gettags \
			[$c find overlapping $x $y $x $y]] 0] 3 end]

		if {$starter==""} {
			set starter $binder_currentDir
		} else {
			set starter $binder_fStat($starter,path)
		}
	}

	foreach i [join $data] {
		if {$binder_selCurrentTag=={}} {
			set distdir $starter
		} else {
			set distdir $binder_fStat($binder_selCurrentTag,path)
		}

		if {[file isdirectory $distdir]} {
			file $fMode -force --  $i $distdir
		} else {
			if {[llength [join $data]]==1} {
				if {![file exists $distdir.copyFile]} {
					file rename -force -- $distdir $distdir.copyFile
					file rename -force -- $i $distdir
				}
			} else {
				if {![file exists $distdir.copyFile]} {
					file rename -force -- $distdir $distdir.copyFile
					file mkdir $distdir
				}

				file $fMode -force -- $i $distdir
			}
		}
	}

	binder_reDraw
}

proc binder_makeItems {c dir binder_dlist} {
	global binder_fStat
	global binder_dlist_Length
	global panelColor stageColor stageWidth stageHeight
	global frameWidth frameHeight itemWidth itemHeight binder_title

	set dir [file nativename $dir]

	$c delete all

	bind $c <ButtonPress-1> "binder_squareSel %x %y sel"

	set counter 0
	foreach u $binder_dlist {
		if {[file exists $dir/$u/.dir.gif]} {
			image create photo dir$u -file $dir/$u/.dir.gif
			set binder_fStat(fileS$counter,icn) dir$u
			set binder_fStat(fileS$counter,stat) dir
			set binder_fStat(fileS$counter,path) $dir/$u
			set binder_fStat(fileS$counter,fName) $u

			incr counter
			continue
		}

		if {[string range $u 0 0]=="."} {
			if {[file type $dir/$u]=="directory"} {
				set binder_fStat(fileS$counter,icn) FolderWrench
				set binder_fStat(fileS$counter,stat) dir
			} else {
				set binder_fStat(fileS$counter,icn) Wrench
				set binder_fStat(fileS$counter,stat) file
			}

			set binder_fStat(fileS$counter,path) $dir/$u
			set binder_fStat(fileS$counter,fName) $u

			incr counter
			continue
		}

		switch [file type $dir/$u] {
			directory {
				set binder_fStat(fileS$counter,icn) Folder
				set binder_fStat(fileS$counter,stat) dir
			}

			file {
				if {[file executable $dir/$u]} {
					set binder_fStat(fileS$counter,icn) [binder_appIconInfo $dir/$u]
				} else {
					set binder_fStat(fileS$counter,icn) [if2_call icon $u]
				}
				set binder_fStat(fileS$counter,stat) file
			}

			link {
				if {[file isdirectory $dir/$u]} {
					set binder_fStat(fileS$counter,icn) FolderLink
					set binder_fStat(fileS$counter,stat) dir
				} elseif {[file isfile $dir/$u]} {
					set binder_fStat(fileS$counter,icn) FileLink
					set binder_fStat(fileS$counter,stat) file
				} else {
					set binder_fStat(fileS$counter,icn) BulletHole
					set binder_fStat(fileS$counter,stat) file
				}
			}
		}

		set binder_fStat(fileS$counter,path) $dir/$u
		set binder_fStat(fileS$counter,fName) $u

		incr counter
	}

	set itemXMax [expr $stageWidth/$itemWidth]

	set binder_dlist_Length [llength [split $binder_dlist]]
	if {[expr $binder_dlist_Length%$itemXMax] == 0} {
		set itemYMax [expr $binder_dlist_Length/$itemXMax]
	} else {
		set itemYMax [expr $binder_dlist_Length/$itemXMax+1]
	}

	for {set i 0} {$i<$itemYMax} {incr i} {
		for {set j 0} {$j<$itemXMax} {incr j} {
			set temp [expr $i*$itemXMax+$j]
			if {[lindex $binder_dlist $temp]=={}} break

			set tag [binder_showItems $c fileS $i $j $temp \
				$binder_fStat(fileS$temp,fName) \
				$binder_fStat(fileS$temp,icn) \
				arrowDisable]

			binder_iconMode_makeBinds $c $tag
		}
	}

	$c configure -scrollregion \
		"0 0 [expr $itemXMax*$itemWidth] [expr 64+$itemYMax*$itemHeight]"
}

proc binder_iconMode_makeBinds {c tag} {
	global binder_fStat

	set itList {img txt}

	foreach i $itList {
		$c bind $i$tag <ButtonRelease-1> \
			"binder_select singleSel $tag %x %y"
		$c bind $i$tag <ButtonRelease-2>\
			"binder_select multiSel $tag %x %y"
		$c bind $i$tag <ButtonPress-3> \
			"binder_select popup $tag %x %y"
		$c bind $i$tag <Double-ButtonRelease-1> \
			"binder_select singleExec $binder_fStat($tag,path) %x %y"
		$c bind $i$tag <Double-ButtonRelease-2> \
			"binder_select singleEdit $binder_fStat($tag,path) %x %y"
		$c bind $i$tag <Drag> \
			"binder_select drag $tag %x %y"
	}
}

proc binder_iconMode {dir switch} {
	global binder_iconMode_dir binder_browseMode
	global panelColor stageColor stageWidth stageHeight
	global frameWidth frameHeight itemWidth itemHeight binder_title
	global binder_selCurrentTag
	global autoUpdateFlag autoUpdateFlagDefault
	global binder_filt_s binder_filt_f

	set autoUpdateFlag false

	set dir [file nativename $dir]

	wm title . "$binder_title:$dir"

	set binder_selCurrentTag {}

	set binder_browseMode iconMode
	set binder_iconMode_dir $dir

	set f .binder_container.f

	if {$switch=="noInit"} {
		$f.fileS delete all
	} else {
		destroy $f

		pack [frame $f] -expand true -fill both
		scrollbar $f.vscroll -command "$f.fileS yview" -orient vertical
		scrollbar $f.hscroll -command "$f.fileS xview" -orient horizontal
		canvas $f.fileS \
			-yscrollcommand "$f.vscroll set" \
			-xscrollcommand "$f.hscroll set" \
			-bd 2 -relief sunken -bg $stageColor -height 960

		pack $f.vscroll -in $f -side left -fill y
		pack $f.hscroll -in $f -side bottom -fill x
		pack $f.fileS -expand 1 -in $f -fill both

		bind $f.fileS <Drop> "binder_iconMode_Drop %D %W %x %y %b"
	}

	binder_makeItems $f.fileS $dir [binder_dLister_getList $dir 1 $binder_filt_s $binder_filt_f]

	set autoUpdateFlag $autoUpdateFlagDefault
}

