set binder_selList {}

############ Square selection

proc binder_squareSel {x y mode} {
	set c .binder_container.f.fileS

	set x [$c canvasx $x]
	set y [$c canvasy $y]

	if {[$c find overlapping $x $y $x $y] != ""} return
	bind $c <Any-Motion> "binder_selectRect $x $y %x %y"
	bind $c <Any-ButtonRelease-1> "binder_getRectTags $x $y %x %y"
}

proc binder_selectRect {x1 y1 x2 y2} {
	set c .binder_container.f.fileS

	$c delete rect

	set x2 [$c canvasx $x2]
	set y2 [$c canvasy $y2]

	$c addtag rect withtag \
		[$c create rect $x1 $y1 $x2 $y2 -outline black]
}

proc binder_sub_getRectTags {idList} {
	global binder_selList
	global stageText

	set c .binder_container.f.fileS

	set temp2 {}

	foreach i $idList {
		set temp [$c gettags $i]

		if {[string first img $temp] == -1} {
			set temp2 [concat $temp2 [string range $temp 3 end]]
		}
	}

	foreach i $temp2 {
		if {[string first $i $binder_selList]!=-1} {
			set temp [lsearch $binder_selList $i]
			set binder_selList [lreplace $binder_selList $temp $temp]
			$c itemconfigure txt$i -fill $stageText
		} else {
			set binder_selList [concat $binder_selList $i]
			$c itemconfigure txt$i -fill red
		}
	}
}

proc binder_getRectTags {x1 y1 x2 y2} {
	set c .binder_container.f.fileS

	$c delete rect

	set x2 [$c canvasx $x2]
	set y2 [$c canvasy $y2]

	set idList [$c find overlapping $x1 $y1 $x2 $y2]
	binder_sub_getRectTags $idList
	bind $c <Any-Motion> ""
	bind $c <Any-ButtonRelease-1> ""
}

#############

proc binder_resetSel {} {
	set c .binder_container.f.fileS
	global binder_selList
	global stageText

	catch [foreach i $binder_selList {
		$c itemconfigure txt$i -fill $stageText}]
	set binder_selList {}
}

proc binder_select {mode tag x y} {
	global binder_selList binder_fStat
	global binder_selCurrentTag
	global stageText binder_browseMode

	set c .binder_container.f.fileS

	set x [$c canvasx $x]
	set y [$c canvasy $y]

	if {$binder_browseMode=="listMode"} {
		set starter $binder_selList
	} else {
		set starter [string range [lindex [$c gettags \
			[$c find overlapping $x $y $x $y]] 0] 3 end]
	}

	switch $mode {
		"popup" {
			set binder_selCurrentTag {}
			if {$binder_selList==""} {
				if {$starter!=""} {
					set binder_selList $starter
				} else {
					return
				}
			}
			set binder_selCurrentTag $binder_selList
			binder_resetSel
		}

		"singleSel" {
			binder_resetSel

			set binder_selList [concat $binder_selList $tag]
 			$c itemconfigure txt$tag -fill red
		}

		"multiSel" {
			set idx [lsearch $binder_selList $tag]                  

			if {$idx != -1} {
				set binder_selList [lreplace $binder_selList $idx $idx]

				$c itemconfigure txt$tag -fill $stageText
				return
			}
			set binder_selList [concat $binder_selList $tag]
			$c itemconfigure txt$tag -fill red
		}

		"singleExec" {
			if {$binder_fStat($binder_selList,stat)=="dir"} {
				binder_common_chDir $binder_fStat($binder_selList,path)
			} else {
				if2_execIF2 $binder_fStat($binder_selList,path) exec
			}

			binder_resetSel
		}

		"singleEdit" {
			if {$binder_fStat($binder_selList,stat)=="dir"} {
				binder_common_chDir $binder_fStat($binder_selList,path)
			} else {
				if2_execIF2 $binder_fStat($binder_selList,path) edit
			}

			binder_resetSel
		}

		"multiExec" {
			set execList {}

			foreach i $binder_selCurrentTag {
				if {$binder_browseMode=="listMode"} {
					set temp $i
				} else {
					set temp $binder_fStat($i,path)
				}

				if {[file isfile $temp]} {
					set execList [concat $execList $temp]
				}
			}

			if2_execIF2 [list $execList] exec
			binder_resetSel
		}

		"drag" {
			if {$binder_selList==""} {
				if {$starter!=""} {
					set binder_selList $starter
				} else {
					return
				}
			}

			set dragList {}

			foreach i $binder_selList {
				set dragList [concat $dragList $binder_fStat($i,path)]
			}

			if {[llength $dragList]<2} {
				dnd_setdata File $binder_fStat($binder_selList,path)
			} else {
				dnd_setdata Files [list $dragList]
			}

			binder_resetSel
			dnd_handledrag
			binder_reDraw
		}
	}
}

