proc binder_proclist_sendfilename {} {

	global ttblibPath procIcon

	set cursolPoint [.plisttop.plist curselection]
	if {$cursolPoint==""} return

	set procname [string trim [lindex [.plisttop.plist get $cursolPoint] 0]]

	if {[string last / $procname]!=-1} {
		.plisttop.processName configure -text \
			[string range $procname \
			[expr [string last / $procname]+1] \
			end]
		.plisttop.plistbody3.pathStr configure -text \
			$procname
		set procIcon \
			[binder_appIconInfo [string range \
			$procname [expr [string last / $procname]+1] end]]

		.plisttop.processIcon configure -image $procIcon

	} elseif {[string first - $procname]==0} {
		set procIcon \
			[binder_appIconInfo [string range $procname 1 end]]

		.plisttop.processName configure -text [string range $procname 1 end]
		.plisttop.plistbody3.pathStr configure -text [exec which [string range $procname 1 end]]

		.plisttop.processIcon configure -image $procIcon
	} else {
		set procIcon [binder_appIconInfo $procname]

		.plisttop.processName configure -text $procname
		.plisttop.plistbody3.pathStr configure -text [exec which $procname]
		.plisttop.processIcon configure -image $procIcon
	}

	switch [.plisttop.plistHide2 get $cursolPoint] {
		T {
			.plisttop.plistbody3.statStr configure -text ""
		}
		R {
			.plisttop.plistbody3.statStr configure -text "¹"
		}
		S {
			.plisttop.plistbody3.statStr configure -text "¹"
		}
		Z {
			.plisttop.plistbody3.statStr configure -text ""
		}
	}



}

proc binder_proclist {} {

	global ttblibPath panelColor stageColor procIcon
	global panelText stageText

	toplevel .plisttop -bg $panelColor
	wm title .plisttop "ץ"

	frame .plisttop.toolbar -bg $panelColor
	frame .plisttop.separator -bd 1 -relief sunken -height 2 -width 300 -bg $panelColor
	frame .plisttop.plistbody -bd 10 -bg $panelColor
	frame .plisttop.plistbody1 -bg $panelColor
	frame .plisttop.spacer -height 10 -bg $panelColor
	frame .plisttop.plistbody2 -bg $panelColor
	frame .plisttop.plistbody3 -bd 10 -bg $panelColor

	tk_optionMenu .plisttop.toolbar.menu menubuttonoptions ץꥱ

	scrollbar .plisttop.plistscroll -command ".plisttop.plist yview"
	listbox .plisttop.plist -width 50 -height 4 -yscrollcommand ".plisttop.plistscroll set" \
		-selectborderwidth 0 -fg $stageText -bg $stageColor
	listbox .plisttop.plistHide -selectborderwidth 0
	listbox .plisttop.plistHide2 -selectborderwidth 0

	bind .plisttop.plist <ButtonRelease-1> "binder_proclist_sendfilename"
	bind .plisttop.plist <Double-ButtonRelease-1> "binder_killproc"

	set procIcon {}

	label .plisttop.processIcon -image $procIcon -bg $panelColor
	label .plisttop.processName -font "-adobe-helvetica-bold-r-*--18-*" -text {} -bg $panelColor

	button .plisttop.plistrefresh -text refresh -image {} -command binder_showproclist -bg $panelColor
	button .plisttop.plistkill -image Kill -command binder_killproc -bg $panelColor

	label .plisttop.plistbody3.baseL -width 100 -bg $panelColor
	label .plisttop.plistbody3.baseR -bg $panelColor

	label .plisttop.plistbody3.path -font "-adobe-helvetica-bold-r-*--14-*" \
		-text  "ѥ" -bg $panelColor
	label .plisttop.plistbody3.pathStr -text {} -font "-adobe-helvetica-*-r-*--14-*" \
		-bg $panelColor

	label .plisttop.plistbody3.stat -font "-adobe-helvetica-bold-r-*--14-*" \
		-text  "֡" -bg $panelColor

	label .plisttop.plistbody3.statStr -text {} -font "-adobe-helvetica-*-r-*--14-*" \
		-bg $panelColor

	pack .plisttop.toolbar
	pack .plisttop.separator -fill both
	pack .plisttop.plistbody
	pack .plisttop.plistbody1 .plisttop.spacer .plisttop.plistbody2 \
		-in .plisttop.plistbody -side top -fill both
	pack .plisttop.plistbody3 -fill both
	pack .plisttop.toolbar.menu -in .plisttop.toolbar
	pack .plisttop.plistscroll .plisttop.plist -in .plisttop.plistbody1 -side left -fill both
	pack .plisttop.processIcon .plisttop.processName -side left -in .plisttop.plistbody2 -anchor e
	pack .plisttop.plistkill .plisttop.plistrefresh -fill y -side right -in .plisttop.plistbody2 -anchor ne
	pack .plisttop.plistbody3.baseL .plisttop.plistbody3.baseR \
		 -side left -fill both -in .plisttop.plistbody3 -anchor nw
	pack .plisttop.plistbody3.path -side top -in .plisttop.plistbody3.baseL
	pack .plisttop.plistbody3.stat -side top -in .plisttop.plistbody3.baseL

	pack .plisttop.plistbody3.pathStr -side top -in .plisttop.plistbody3.baseR
	pack .plisttop.plistbody3.statStr -side top -in .plisttop.plistbody3.baseR

	binder_showproclist
}




