#!/bin/sh
# the next line restarts using wish \
exec wishstep8.0jp "$0" "$@"

image create photo DarkForest -data {
	R0lGODlhMAAwAKUAAAAAACBBYTAwKGFRQVFBWShphvfrtrLA3EEQKEFBtr7LtrbDrs/Ltllx
	1//772EgUXFhx+/737aiz8/Dju/r3xBBcVFRUTBhrtfrxzAYIN/LzyAwEOfjngA4cTAwUVEg
	YVkIaXlBce/710lJaSAoMHl1jq66rnlJtq6qriAQCP/73//r30kYUWlRWTB5nmFBUe/Tz0FB
	WUEwODAgEFkQKJ6qlr6KjufDtmFpcd/r3//X18/bzyAYIM+6rihBjgAAACH5BAEAAAcALAAA
	AAAwADAAAAb+wINwSCwaj8ikcslsFi8NSAMqhaqu2Kw2uxLBvBgN5oZhKHoTNCpwmLqh0MZ2
	vo2oRHhReFxmMBYLEx0HFyeFDQkQiSJ0jVgiXTAGMHw3CjcMPQs9bBAXnp4JU46OkAACIhQY
	lGJkCn4LFYQJnxeJFyWkjgMAADxglGR+DGmyoLW0Eiu6WwI8vaciOaxlfWZshbYJJy4nNcxZ
	G9DQGdOTlQocmWy03Ia04FgbFuO9AxR4e8KvsQc+ECMSFDiBI0G8LPUARFql79UZbP8iJsBx
	8EpCVHr0ULP0RxYOgglGADRYsZ6ALzAkBRtzScEEWQl8hIw5sWS9CF3w6REjhkH+GQVsRpwI
	+DHgQXEJRegApm9HJqAHZgacCo5eQmj5qLVyGHQEjhFgvzrQdbWeF0orLVl6eSDgTB8nfJAt
	Oy6rvmpmZIHdu1fFMjp066FkKGyYoLYhp4ZEYWdO4HoDdu7xOWxB1xEg9n6wsfQvwsfjGLZi
	yeGV3qlgQ4aIkMNOYxWge9XohbZp5aAfRoTAvLeLb0giHi/oZaPXKgZkOL5a13bEBx9gQUCf
	Ji2PVbrDAcwGIAbGOD/8ZOV2ztt5iUl4voBekAFAcbpPObUdP955DBg59OAT3oME6MriEZDb
	gOSFAAMKKMUWWyabsCGgcw9+MCAOO/SCgoL/AdLPCx/aCCghhxwK2IJ3GK6HhnwdfgBiigIK
	uAo0ApR4lSaBDELAAwSwkOMLOuLIAo98yFjWJhOgIMsDMTzggY8x6MhCk88IiR0gbMnwIwss
	PCDDAzR8kIKUoKVRQz9alrlllGCCJsEmNciS5ZZfponhBCZM0IIsMqApJ4YL1IDDA2zsKSUN
	DyBAwyCCCsnClgLIkmiJPCDAgqGOPhpbpDIgkGmllj6GAAIZfIoAop0+JkOommbAaalX8RDq
	q6MewCpdsL666qzjgJrBrrsGimtCM/DKK6m/PubEscgWEQQAOw==
}

image create photo SelectFiles -data {
	R0lGODlhMAAkAKUAAHFhWTBFOIZ5eRAMAAgsIDBxeRAMIDBlOBAAADAYOGG+nsffzzh5UTg8
	UWnXx3nz13n3pnHrlmnLaSAYIDhhWXn3557j91F1nlGaQVFpMDAoWWm213nT95b7hjhBaYbv
	eY7vcYbrcYbzeY77eY7raYbreWlZtnma95aC90lFhoai/3l112GG1551UYZBKEEkGFEUAP/X
	tteqjqZh17aWcaaC//fDpv/LpkEMAO/Dnu+6nnlJjtd19////////////yH+Dk1hZGUgd2l0
	aCBHSU1QACH5BAEKAD8ALAAAAAAwACQAAAb+wJ9wSCwahQBA4MhsOpmCAaFgOBwQAcFzu00U
	EgjDlKBYKBiERoLLLiIIDsdjfoZEIAuIBIGYtLlvBRQVhBUWFxgQinYMGBgIAwhaf0QCGQga
	GxYcFA+EDw4Md4oRBxgdHRgFEgQIAJRCCB4OFrUbFHKeCgd2ilaoEakMigiwP16btLcOhQEK
	iwwZHR8gISIjGaIExj8GHN8Wy54OvL4ZIx0iESQlwRgEk5QCBheb4Z0PFhTPENEdIyACRhAB
	Al2GAbAAEDBBwYIyXBUcBFAUbcSIEiBKECyB8UOqYm0UnkCRQtM9Zhck9DtHQkQJdiLYfWDn
	DuQWhShUnLhQj8P+LU8Fzkgb8aGo0Q8EI1AzaLMJzhMrVpzwoOlWBQUFKl4E8QGjxoxcS4SI
	gI7AqyYCELBQgSLqiRT1NhR4UODXNIwWYbJTwK6Exz3xmLQgwGLkChQsNPjEdYZAAHQWMUgY
	IYLazK5/JQGaUPiwipKcDFlQQOHAvwQuXggg2hWE0g6A2YTxUBjFCRMNODhTEMdBaQkwYsjI
	ACGmXxIjYss2MUMDC9soqPKkQMBAAw18aMSI8eIfRxGw4f0ZgKLGigZrUVwowIFnitspDGSI
	YSMGDAkdXu/J8AeABhTl4bYWCw14kAILh6RgwgAy3FAfDAmUgIoEOMBAiQEm1ABgW87+qRCV
	ThekgIIGA+Rwww0ywDDAKRJMAIOF/RmQwgwAmoceW595gMIMCOCggw030KBiAgEMYIAfCQ2w
	g4I11DDDjRfoWEN8CDQYg5ATvHDkCzDCogEPO/hnwo4eGDiDkxrsUOWJWGY5wQA0cJMAD3TO
	sEMDJpiwQ407ePDCmkC6gMMEExjQFCVzzkAnnX0qWB6JObjQoIk3CEooDi3IueimPNjpQZou
	xNCCDDbkQKmlLyBkTKIztOpqnTvM0MKVMuhgqw4opsolN9YF0ICvv/oKbAMwnHirrTno0MKL
	MODADRctuGCDDT+aqoMMNHCZQZfPOtHCrDoka6sNMkQr6A413W6RQQ7U3jptuS3gwF+6TgDQ
	wg3ihksuDdm6QO8TLziYLLvsYuuCv/86RcOxyGLbwllMBAEAOw==
}

proc forest_truncateList {list} {

	set retList {}

	foreach i $list {
		if {$i == {}} {
			continue
		}

		catch [set retList [concat $retList $i]]
	}

	return $retList
}

proc forest_startCompress {mode fileName} {

	global forestDir

	set fName [file tail [file rootname [file rootname $fileName]]]
	set oldPwd [pwd]

	file mkdir $forestDir/$fName

	switch $mode {
		tgz {
			cd [file dirname $fileName]
			exec tar zcf $forestDir/$fName/$fName.tar.gz [file tail $fileName]
			cd $oldPwd
		}

		mtgz {
			set fName 
			cd $forestDir [exec date +%s]
			eval exec tar zcf $forestDir/$fName/$fName.tar.gz $fileName
			cd $oldPwd
		}

		gz  {
			exec gzip -c $fileName > $forestDir/$fName/$fName.gz
		}
	}

	tk_dialog .dialog Result "Compressed to $forestDir/$fName/" {} 0 ok
	destroy .
}

proc forest_startDecompress {mode fileName} {

	global forestDir

	set fName [file tail [file rootname [file rootname $fileName]]]
	file mkdir $forestDir/$fName

	switch $mode {
		utar {exec tar xf $fileName -C $forestDir/$fName}
		utgz {exec tar zxf $fileName -C $forestDir/$fName}
		ugz  {exec gzip -cd $fileName > $forestDir/$fName/$fName}

		ulzh  {
			set pwd [pwd]
			cd $forestDir/$fName/
			exec lha x $fileName
			cd $pwd
		}

		uzoo  {
			set pwd [pwd]
			cd $forestDir/$fName/
			exec zoo e $fileName
			cd $pwd
		}

		uzip {exec unzip $fileName -d $forestDir/$fName}
	}

	tk_dialog .dialog Result "Decompressed to $forestDir/$fName/" {} 0 ok
	destroy .
}

proc forest_openWindow {mode dataList} {

	global panelColor stageColor

	wm title . "Deep forest the JDE compress utilt"

	set iList {}

	. configure -bg $stageColor -bd 10 -relief flat -width 480 -height 320

	pack [frame .u -bg $stageColor] -fill both
	pack [frame .l -bg $stageColor]
	pack [label .u.logo -image DarkForest] -side left
	pack [label .u.title -bg $panelColor] -side left -padx 20
	pack [scrollbar .l.innerListScroll] \
		[listbox .l.innerList -bg $stageColor] \
		-pady 5 -side left -fill both
	pack [button .cancel -bg $panelColor] \
		[button .ok -bg $panelColor] \
		-fill both -side right -anchor s -padx 5

	.l.innerList configure -yscrollcommand ".l.innerListScroll set" \
		-width 48
	.l.innerListScroll configure -command ".l.innerList yview"
	.cancel configure -text "Cancel" -command "destroy ."
	.u.title configure -font {Helvetica 18 bold}

	switch $mode {
		gz {
			.u.title configure -text "Compress:$dataList"
			.l.innerList insert end $dataList
			.ok configure -text "Compress" -command \
				"forest_startCompress $mode $dataList" \
				-default active
		}

		tgz {
			.u.title configure -text "Compress:$dataList"
			.l.innerList insert end $dataList
			.ok configure -text "Compress" -command \
				"forest_startCompress $mode $dataList" \
				-default active
		}

		mtgz {
			.u.title configure -text "Compress:$dataList"
			foreach i $dataList {.l.innerList insert end $i}

			.ok configure -text "Compress" -command \
				"forest_startCompress $mode $dataList" \
				-default active
		}

		utar {
			.u.title configure -text "Decompress:$dataList"

			set temp [split [exec tar tf $dataList] \n]
			foreach i $temp {.l.innerList insert end $i}

			.ok configure -text "Decompress" -command \
				"forest_startDecompress $mode $dataList" \
				-default active
		}

		utgz {
			.u.title configure -text "Decompress:$dataList"

			set temp [split [exec tar ztf $dataList] \n]
			foreach i $temp {.l.innerList insert end $i}

			.ok configure -text "Decompress" -command \
				"forest_startDecompress $mode $dataList" \
				-default active
		}

		ulzh {
			.u.title configure -text "Decompress:$dataList"

			set temp [split [exec lha l $dataList] \n]

			set temp2 {}

			foreach i $temp {set temp2 "$temp2 [lindex $i 6]"}

			set temp2 [forest_truncateList $temp2]

			for {set i 1} {$i<[expr [llength $temp2]-1]} {incr i} {
				.l.innerList insert end [lindex $temp2 $i]
			}

			.ok configure -text "Decompress" -command \
				"forest_startDecompress $mode $dataList"\
				-default active
		}

		uzoo {
			.u.title configure -text "Decompress:$dataList"

			set temp [split [exec zoo l $dataList] \n]
			set temp2 {}
			set temp3 {}
			for {set i 4} {$i<[expr [llength $temp]-2]} {incr i} {
				set temp2 [concat $temp2 [list \
				 [forest_truncateList [lindex $temp $i]]]]
			}

			foreach i $temp2 {set temp3 [concat $temp3 [lindex $i 7]]}
			foreach i $temp3 {.l.innerList insert end $i}

			.ok configure -text "Decompress" -command \
				"forest_startDecompress $mode $dataList" \
				-default active
		}

		uzip {
			.u.title configure -text "Decompress:$dataList"

			set temp [split [exec unzip -l $dataList] \n]
			set temp2 {}
			set temp3 {}

			for {set i 3} {$i<[expr [llength $temp]-2]} {incr i} {
				 set temp2 [concat $temp2 [lindex [forest_truncateList [lindex $temp $i]] 3]]
			}

			foreach i $temp2 {.l.innerList insert end $i}

			.ok configure -text "Decompress" -command \
				"forest_startDecompress $mode $dataList" \
				-default active
		}

		ugz {
			.u.title configure -text "Decompress:$dataList"

			set temp [split [exec gzip -l $dataList] \n]

			for {set i 1} {$i<[llength $temp]} {incr i} {
				catch [set iList [concat $iList [lindex [lindex $temp $i] 3]]]
			}

			set iList [forest_truncateList $iList]

			foreach i $iList {.l.innerList insert end $i}

			.ok configure -text "Decompress" \
			-command "forest_startDecompress $mode $dataList"\
			-default active
		}

		default {
			destroy .
		}
	}
}

proc forest_decode {datas} {
	set dataList [split $datas]

	if {[llength $dataList]==1} {
		switch [file type $dataList] {
			file {set mode [forest_fileModeType $dataList]}
			directory {set mode tgz}
			default {puts error}
		}
	} else {
		set mode mtgz
	}

	forest_openWindow $mode $dataList
}

proc forest_fileModeType {data} {
	if {[file extension $data]!=".gz"} {
		set mode gz
	} else {
		if {[file extension [file rootname $data]]==".tar"} {
			set mode utgz
		} else {
			set mode ugz
		}
	}

	switch [file extension $data] {
		".Z" {
			if {[file extension [file rootname $data]]==".tar"} {
				set mode utgz
			} else {
				set mode ugz
			}
		}

		".tar" {set mode utar}
		".tgz" {set mode utgz}
		".taz" {set mode utgz}
		".lzh" {set mode ulzh}
		".zoo" {set mode uzoo}
		".zip" {set mode uzip}
	}

	return $mode
}

wm group . .
wm command . "DeepForest"
set stageColor #c0c0c0
set panelColor #c0c0c0
set forestDir $env(HOME)/Forest

if {![file exists $forestDir]} {
	file mkdir $forestDir
}

forest_decode $argv

