#!/bin/sh
# the next line restarts using wish \
exec wishstep8.0jp "$0" "$@"

set JGVver 0.1c

package require Img

set ImagickC [catch "exec convert"]
set ImagickD [catch "exec display -?"]

wm group . .
wm command . "JGV.app"
wm title . "Jun's Graphics Viewer $JGVver"

set Current -1
set imageNames {}

set breakVal 0

set panel {#c0c0c0}
set text {black}
set interval {5000}
set animFlag 0
set lang {en}
set logoData {}

set Jdefault "$env(HOME)/GNUstep/Defaults"
set Jlib "/usr/X11R6/JDE/JGV"
image create photo default -file "$Jlib/icons/logo.xpm"

if {![file exists "$Jdefault/JGV"]} {
	file mkdir $Jdefault
	file copy -force -- $Jlib/defaults/JGV \
		$Jdefault
}

source "$Jdefault/JGV"
source "$Jlib/menu/menu.$lang"
source "$Jlib/modules/PrefJGV.m"

proc jgv_about {} {
	global Jlib logoData animFlag JGVver

	toplevel .about -bd 10 -bg black
	grab .about

	pack [label .about.l1 -bg black -fg #c0c0c0 \
		-text "Jun's graphics viewer $JGVver"]
	pack [canvas .about.c -bd 2 -relief groove -bg black \
		-width 120 -height 120]
	pack propagate .about.c false
	pack [label .about.l2 -bg black -fg #c0c0c0 -text "Jun Wakaya 1998"]
	bind .about <Any-ButtonPress> "set animFlag 0;destroy .about"

	jgv_makeAnimGIF .about .about.c "$Jlib/icons/logo.gif" \
		-noresize -about
}

proc jgv_preference {} {
	global button

	jgv_Preference
	if {$button==0} {
		jgv_rePref
	}

	set button -1
	return
}

proc jgv_wall {} {
	global Current imageNames ImagickD

	if {$ImagickD=="0"} {
		exec display -window root [lindex $imageNames $Current]
	}
}

proc jgv_openFile {} {
	global imageINF animFlag

	set animFlag 0

	set types {
		{"All supported" {.jpg .jpeg .JPG .gif .GIF .xpm .png .pnm .ppm .tif .tiff .ps}}
		{"All files"	 *}
	}

	set file [tk_getOpenFile -filetypes $types -parent .]
	if {$file==""} return

	wm title . $file

	if {[file extension $file]==".gif"} {
		jgv_makeAnimGIF . .area1.c0 $file -resize -normal
	} else {
		jgv_makeGraphics $file
	}
}

proc jgv_openFiles {} {
	global imageINF breakVal

	set breakVal 0
	set fList {}

	set types {
		{"All supported" {.jpg .jpeg .JPG .gif .GIF .xpm .png .pnm .ppm .tif .tiff .ps}}
		{"All files"	 *}
	}

	set file [tk_getOpenFile \
		-title "Serialized:Any file is ok.I just want the directory." \
		-filetypes $types -parent .]
	if {$file==""} return

	set temp [glob [file dirname $file]/*]

	foreach i $temp {
		foreach j {.jpg .jpeg .JPG .gif .GIF .xpm .png .pnm .ppm .tif .tiff .ps} {
			if {[file extension $i]!=$j} {
				continue
			}
			lappend fList $i
		}
	}

	set fList [lsort $fList]

	foreach i $fList {
		jgv_makeGraphics $i
		update
		if {$breakVal!=0} break
		after 5000
	}

	set breakVal 0
	jgv_showGraphics . .area1.c0 default 320 240 -resize
}

proc jgv_showGraphics {tl c name width height opt} {

	$c delete all

	set oldGeom [split [wm geometry .] +]
	set oldGeomX [lindex $oldGeom 1]
	set oldGeomY [lindex $oldGeom 2]

	set sWidth [winfo screenwidth .]
	set sHeight [winfo screenheight .]

	set X [expr $width/2]
	set Y [expr $height/2]
	$c create image $X $Y -image $name
	$c configure -scrollregion "0 0 $width $height"

	set addX 0;set addY 0

	if {$tl=="."} {

	pack forget .area1.sby.s .area1.sbx.s
	.area1.sbx configure -height 2
	.area1.sby configure -width 2

	if {[expr $width+20]>$sWidth} {
		set width [expr $sWidth-48]
		set addY 20
		.area1.sbx configure
		pack .area1.sbx.s -in .area1.sbx -side bottom -fill both
		set oldGeomX 0
	}

	if {[expr $height+48]>$sHeight} {
		set height [expr $sHeight-64]
		set addX 20
		.area1.sby configure
        	pack .area1.sby.s -in .area1.sby -side left -fill both
		set oldGeomY 0
	}

 	} else {
		set oldGeomX [expr ($sWidth-$width)/2+6]
		set oldGeomY [expr ($sHeight-$height)/2+6]
	}

	set width [expr $width+$addX];set height [expr $height+$addY]

	if {$opt=="-noresize"} {
		wm geometry $tl +$oldGeomX+$oldGeomY
	} else {
		wm geometry $tl [format "%dx%d" $width $height]+$oldGeomX+$oldGeomY
	}
}

proc jgv_makeGraphics {file} {
	global Current imageNames

	lappend imageNames $file
	incr Current

	wm title . $file

	if {[string first / $file]==-1} {
		set file [pwd]/$file
	}

	catch "image delete img"

	image create photo img -file $file

	set width [image width img]
	set height [image height img]

	jgv_showGraphics . .area1.c0 img $width $height -resize
}

proc jgv_caliFrames {image file} {

	global Current imageNames animFlag

	if {$animFlag!="1"} return

	set i 0;set ret 0

	while {$ret==0} {
		if {$animFlag!="1"} return
		set ret [catch {$image configure -file $file -format "gif -index $i"}]
		if {$ret} "return $i"
		after 100
		update
		incr i
	}
}

proc jgv_makeAnimGIF {tl c file opt flag} {
	global Current imageNames animFlag Jlib ImagickC
	set i 0;set ret 0

	set animFlag 1

	lappend imageNames $file
	incr Current

	if {$flag=="-about"} {
		set image about
	} else {
		set image img
	}

	catch "image delete $image"

	if {[catch "image create photo $image \
			-file $file -format {gif -index $i}"]!=0} {
		if {$ImagickC!=0} break
		exec convert $file [file nativename ~/.JGVtemp.tif]
		set file ~/.JGVtemp.tif

		jgv_makeGraphics $file
		return
	}

	set width [image width $image]
	set height [image height $image]
	jgv_showGraphics $tl $c $image $width $height $opt
	set frames [jgv_caliFrames $image $file]

	if {$animFlag!="1"} return

	while {$animFlag} {
	for {set i 0} {$i<$frames} {incr i} {
		if {$animFlag!="1"} return
		$image configure -file $file -format "gif -index $i"
		after 100
		update
		incr i
	}}
}

proc jgv_makeMenu {mode x y} {
	switch $mode {
		popup {
			tk_popup .popup $x $y
		}
	}
}

proc jgv_makeBind {} {
	bind . <Any-ButtonRelease-3> "jgv_makeMenu popup %X %Y"
}

proc jgv_rePref {} {
	global panel text lang interval Jdefault Jlib


	source "$Jdefault/JGV"
	source "$Jlib/menu/menu.$lang"

	.area1 configure -bg $panel

	.area1.sby configure -bg $panel
	.area1.sbx configure -bg $panel
	.area1.c0  configure -bg $panel
	.area1.sbx.s configure -trough $panel
	.area1.sby.s configure -trough $panel
}

proc jgv_makeSkelton {} {
	global panel text

	frame .area1 -width 320 -height 240 -bg $panel
	pack .area1 -fill both -expand 1
	pack propagate .area1 false

	frame .area1.sby
	frame .area1.sbx
	canvas .area1.c0 -xscrollcommand ".area1.sbx.s set" \
		-yscrollcommand ".area1.sby.s set" -bg $panel
	scrollbar .area1.sbx.s -orient horizontal \
		-trough $panel -command ".area1.c0 xview"
	scrollbar .area1.sby.s -orient vertical \
		-trough $panel -command ".area1.c0 yview"

	pack .area1.sby -in .area1 -side left -fill y
	pack .area1.sbx -in .area1 -side bottom -fill x

	pack .area1.sby.s -in .area1.sby -side left -fill y
	pack .area1.sbx.s -in .area1.sbx -side bottom -fill x
	pack .area1.c0   -fill both -in .area1 -expand 1

	pack forget .area1.sby.s .area1.sbx.s

	jgv_showGraphics . .area1.c0 default 320 240 -resize
}

jgv_makeSkelton
jgv_makeBind

if {$argc>0} {
	set arg {}

	for {set j 0} {$j<[llength $argv]} {incr j} {
		set i [lindex $argv $j]

		if {[string index $i 0]=="-"} {
			set arg [string range $i 1 end]
			if {$arg=="wall"} {
				jgv_makeGraphics [lindex $argv [expr $j+1]]
				jgv_wall
				exit
			}
		} else {
			if {$i!=""} {
				jgv_makeGraphics $i
			}
		}
	}
}
