' $Id: lifo.n,v 1.1 1995/06/12 08:59:07 jfontain Exp $
.TH lifo tcl
.BS
.SH NAME
lifo \- last in first out data buffer
.SH SYNOPSIS
\fBnew lifo \fI?size?\fR
.in
\fBdelete lifo \fIlifoId\fR
.SH DESCRIPTION
.PP
A \fBlifo\fR object is used to store data on a last in, first out basis. Data is pushed onto the \fBlifo\fR, then can be retrieved, last data first with a pop command.
.PP
By default, there is no limit, except memory limitations, to the number of data elements that can be stored in the \fBlifo\fR. The \fBlifo\fR, then behaves as a stack. If a size limit is set, then the oldest data element are discarded the the \fBlifo\fR fills up.
.PP
When the \fBlifo\fR is deleted, all the memory used for the data elements is freed.
.SH CREATION PARAMETERS
.PP
The constructor takes one optional argument: the \fIsize\fR or maximum number of data elements stored in the \fBlifo\fR.
.SH DATA MANAGEMENT
.PP
Data is pushed using:
.sp
.RS
.nf
\fBlifo::push \fI$id "some data..."\fR
.fi
.RE
.PP
Data is retrieved using:
.sp
.RS
.nf
set data [\fBlifo::pop \fI$id\fR]
.fi
.RE
.PP
An error is generated when trying to pop from an empty \fBlifo\fR object.
.PP
The \fBlifo\fR object can be emptied using:
.sp
.RS
.nf
\fBlifo::empty \fI$id\fR
.fi
.RE
.SH KEYWORDS
.PP
lifo, stack, new, delete
