#
#    PrefMuggy Muggy preference module
#
#			Wed Nov 18 01:37:51 JST 1998 Jun Wakaya
#

set button -1

set MuggyPrefernceTestText {
The Muggy is the text editor.
1234567890@
This is the selected strings.
}

proc pref_save {tl} {
	global tBg tText mBg mText fontName lang tCur sBg sFg bSuf
	global button
	global Jdef

	set bSuf [$tl.u.lang.f2.e1 get]

	set fp [open $Jdef/Muggy w]

	puts $fp "global tBg tText mBg mText fontName lang tCur sBg sFg bSuf"
	foreach i {tBg tText mBg mText fontName lang tCur sBg sFg bSuf} {
		eval puts $fp \"set $i \{\$$i\}\"
	}

	set button 0
}

proc pref_cancel {tl} {
	global tBg tText mBg mText fontName lang tCur sBg sFg button

	set button 1
}

proc pref_setColor {w name} {
	global tBg tText mBg mText sFg sBg tCur

	eval set backup \$$name

	set $name [tk_chooseColor -title "Choose a color" -parent . \
		-initialcolor $backup]

	eval set temp \$$name

	if {$temp==""} {
		set $name $backup
		set temp $backup
	}

	$w configure -bg $temp
}

proc pref_fontPrev {w} {
	global tBg tText mBg mText fontName sFg sBg tCur
	global MuggyPrefernceTestText

	set fontName [$w.u.lang.f3.i1 get]

	if {[winfo exists .font]} {
		raise .font
		destroy .font.m
	} else {
		toplevel .font -bd 5 -bg $mBg
	}

	grab .font

	text .font.t -fg $tText -bg $tBg -font $fontName -relief sunken \
		-state normal -width 48 -height 8 \
		-selectforeground $sFg -selectbackground $sBg \
		-insertbackground $tCur

	.font.t insert end $MuggyPrefernceTestText
	pack .font.t

	.font.t tag add sel 4.0 5.0

	.font.t configure -state disabled

	bind .font <Any-ButtonRelease-1> "destroy .font"
	bind .font <Any-Key> "destroy .font"
}

proc muggy_Preference {} {

	global button step l10n

	set oldFocus [focus]
	set tl ".prefer"

	if {[winfo exists $tl]} {
		raise $tl
		return
	} else {
		toplevel $tl
	}

	grab $tl

	global tBg tText mBg mText tCur sBg sFg bSuf lang fontName Jlib
	set FG $mText;set BG $mBg

	set xFont "-adobe-courier-medium-r-normal--18-*"
	set lFont "-adobe-fixed-medium-r-normal--14-*"
	set mFont "-adobe-fixed-medium-r-normal--12-*"

	wm title $tl "Muggy preferences"

	$tl configure -bd 10 -bg $BG

	##################### Frames #########################

	frame $tl.u -bg $BG
	frame $tl.b -bg $BG
	pack $tl.u $tl.b -fill both

	frame $tl.u.color -bg $BG -bd 2 \
		-width 192 -height 240 -relief groove
	frame $tl.u.lang -bg $BG -bd 2 \
		-width 192 -height 240 -relief groove

	if {$step=="1"} {
		$tl.u.color configure -font $xFont -fg $FG -text Color
		$tl.u.lang configure -font $xFont -fg $FG -text Linguas
	}

	pack $tl.u.color $tl.u.lang -fill both -side left
	pack propagate $tl.u.color false
	pack propagate $tl.u.lang false

	######################## frame 0 #######################

	frame $tl.u.color.f5 -bd 5 -bg $BG
	frame $tl.u.color.f4 -bd 5 -bg $BG
	frame $tl.u.color.f3 -bd 5 -bg $BG
	frame $tl.u.color.f2 -bd 5 -bg $BG
	frame $tl.u.color.f1 -bd 5 -bg $BG
	frame $tl.u.color.f0 -bd 5 -bg $BG
	frame $tl.u.color.f6 -bd 5 -bg $BG

	pack $tl.u.color.f6 $tl.u.color.f0 $tl.u.color.f1 $tl.u.color.f2 \
		$tl.u.color.f3 $tl.u.color.f4 $tl.u.color.f5 -fill both -side bottom

	label $tl.u.color.f5.l1 -fg $FG -bg $BG -font $lFont \
		-text "Press a button to config."
	pack $tl.u.color.f5.l1

	label $tl.u.color.f4.l1 -font $mFont -text "The body of Muggy" \
		-fg $BG -bg $FG -width 48
	pack $tl.u.color.f4.l1

	button $tl.u.color.f3.bg -fg black -bg $mBg -text "bg color" \
		-command  "pref_setColor $tl.u.color.f3.bg mBg"
	button $tl.u.color.f3.fg -fg #c0c0c0 -bg $mText -text "text color" \
		-command  "pref_setColor $tl.u.color.f3.fg mText"

	pack $tl.u.color.f3.bg $tl.u.color.f3.fg -side left

	label $tl.u.color.f2.l1 -font $mFont -text "The text box" \
		-fg $BG -bg $FG -width 48
	pack $tl.u.color.f2.l1

	button $tl.u.color.f1.bg -fg black -bg $tBg -text "bg color" \
		-command  "pref_setColor $tl.u.color.f1.bg tBg"
	button $tl.u.color.f1.fg -fg #c0c0c0 -bg $tText -text "text color" \
		-command  "pref_setColor $tl.u.color.f1.fg tText"

	pack $tl.u.color.f1.bg $tl.u.color.f1.fg -side left

	label $tl.u.color.f0.l1 -font $mFont -text "The cursol & selection" \
		-fg $BG -bg $FG -width 48
	pack $tl.u.color.f0.l1

	button $tl.u.color.f6.cur -fg #c0c0c0 -bg $tCur -text "cursol" \
		-command  "pref_setColor $tl.u.color.f6.cur tCur"
	button $tl.u.color.f6.sbg -fg white -bg $sBg -text "selBG" \
		-command  "pref_setColor $tl.u.color.f6.sbg sBg"
	button $tl.u.color.f6.sfg -fg black -bg $sFg -text "selFG" \
		-command  "pref_setColor $tl.u.color.f6.sfg sFg"

	pack $tl.u.color.f6.cur $tl.u.color.f6.sbg $tl.u.color.f6.sfg \
		-side left

	######################## Frame 1 ######################

	frame $tl.u.lang.f4 -bd 5 -bg $BG
	frame $tl.u.lang.f3 -bd 5 -bg $BG
	frame $tl.u.lang.f2 -bd 5 -bg $BG
	frame $tl.u.lang.f1 -bd 5 -bg $BG
	frame $tl.u.lang.f0 -bd 5 -bg $BG

	if {$l10n==1} {
		pack [frame $tl.u.lang.f5 -bd 5 -bg $BG] -fill both -side bottom
	}

	pack $tl.u.lang.f0 $tl.u.lang.f1 $tl.u.lang.f2 $tl.u.lang.f3 $tl.u.lang.f4 \
		-fill both -side bottom

	label $tl.u.lang.f2.l1 -font $mFont -text "Backup suffix" \
		-fg $BG -bg $FG -width 48
	pack $tl.u.lang.f2.l1

	entry $tl.u.lang.f2.e1 -width 48
	$tl.u.lang.f2.e1 insert end $bSuf
	pack $tl.u.lang.f2.e1 -pady 5


	label $tl.u.lang.f4.l1 -font $mFont -text "Font" \
		-fg $BG -bg $FG -width 48
	pack $tl.u.lang.f4.l1

	entry $tl.u.lang.f3.i1
	$tl.u.lang.f3.i1 insert end $fontName
	button $tl.u.lang.f3.b1 -font $mFont -text "prev" \
		-command "pref_fontPrev $tl" -bg $BG

	bind $tl.u.lang.f3.i1 <Any-Return> "pref_fontPrev $tl"

	pack $tl.u.lang.f3.i1 $tl.u.lang.f3.b1 -side left -fill both

	label $tl.u.lang.f1.l1 -font $mFont -text "Default language" \
		-fg $BG -bg $FG -width 48
	pack $tl.u.lang.f1.l1

	source "$Jlib/modules/MuggyPrefIcons.m"

	label $tl.u.lang.f0.l1 -image ja -width 48 -bg $BG
	label $tl.u.lang.f0.l3 -image en -width 48 -bg $BG

	radiobutton $tl.u.lang.f0.l2 -relief flat -value ja\
		-variable lang -bg $BG
	radiobutton $tl.u.lang.f0.l4 -relief flat -value en\
		-variable lang -bg $BG

	pack $tl.u.lang.f0.l2 $tl.u.lang.f0.l1 -side left
	pack $tl.u.lang.f0.l4 $tl.u.lang.f0.l3 -side left

	if {$l10n==1} {
		label $tl.u.lang.f5.l1 -font $mFont \
			-text "KANJI encode" \
			-fg $BG -bg $FG -width 48
		pack $tl.u.lang.f5.l1
	}

	##################### bottom #########################

	button $tl.b.ok -text save -font $lFont -default active \
		-command "pref_save $tl" -bg $BG -fg $FG
	button $tl.b.cancel -text cancel -font $lFont -default normal \
		-command "pref_cancel $tl" -bg $BG -fg $FG

	pack $tl.b.cancel $tl.b.ok -side right -padx 5 -pady 5
	tkwait variable button
	destroy $tl
	focus $oldFocus
	return $button
}
