#
#    PrefMuggy Muggy preference module
#
#			Wed Nov 18 01:37:51 JST 1998 Jun Wakaya
#

global panel text interval lang

set button -1

proc pref_save {tl} {
	global panel text interval lang
	global button

	set fp [open ~/GNUstep/Defaults/JGV w]

	foreach i {panel text interval lang} {
		eval puts $fp \"set $i \{\$$i\}\"
	}

	close $fp

	set button 0
}

proc pref_cancel {tl} {
	global button

	set button 1
}

proc jgv_setInterval {val} {
	global interval

	set interval $val
}

proc pref_setColor {w name} {
	global panel text

	eval set backup \$$name

	set $name [tk_chooseColor -title "Choose a color" -parent . \
		-initialcolor $backup]

	eval set temp \$$name

	if {$temp==""} {
		set $name $backup
		set temp $backup
	}

	$w configure -bg $temp
}

proc jgv_Preference {} {

	global button Jlib

	set oldFocus [focus]
	set tl ".prefer"

	if {[winfo exists $tl]} {
		raise $tl
		return
	} else {
		toplevel $tl
	}

	grab $tl

	global panel text interval lang

	set FG $text;set BG $panel

	set xFont "Courier 18"
	set lFont "Fixed 14"
	set mFont "Fixed 12"

	wm title $tl "JV preferences"

	$tl configure -bd 10 -bg $BG

	label $tl.l0 -font $lFont -text "Color setting" \
		-fg $BG -bg $FG -width 32
	pack $tl.l0

	frame $tl.u -bd 5 -bg $BG
	pack $tl.u

	button $tl.u.bg -fg black -bg $panel -text "bg color" \
		-command  "pref_setColor $tl.u.bg panel"
	button $tl.u.fg -fg #c0c0c0 -bg $text -text "text color" \
		-command  "pref_setColor $tl.u.fg text"

	pack $tl.u.bg $tl.u.fg -side left -fill both -padx 5

	label $tl.l1 -font $lFont -text "Default language" \
		-fg $BG -bg $FG -width 32
	pack $tl.l1

	frame $tl.m -bd 5 -bg $BG
	pack $tl.m

	image create photo ja -file "$Jlib/icons/Pref.ja.gif"
	image create photo en -file "$Jlib/icons/Pref.en.gif"

	label $tl.m.l2 -image ja -bg $BG
	label $tl.m.l3 -image en -bg $BG

	radiobutton $tl.m.l4 -relief flat -value ja\
		-variable lang -bg $BG
	radiobutton $tl.m.l5 -relief flat -value en\
		-variable lang -bg $BG

	pack $tl.m.l4 $tl.m.l2 $tl.m.l5 $tl.m.l3 -side left

	label $tl.l5 -font $lFont -text "Serial load's interval(ms)" \
		-fg $BG -bg $FG -width 32
	pack $tl.l5

	scale $tl.s -trough $BG -from 1000 -to 5000 -length 200 \
		-resolution 20 -showvalue yes -orient horizontal \
		-tickinterval 1000 -command jgv_setInterval \
		-fg $FG -bg $BG
	pack $tl.s

	$tl.s set $interval

	##################### bottom #########################

	button $tl.ok -text save -font $lFont -default active \
		-command "pref_save $tl" -bg $BG -fg $FG
	button $tl.cancel -text cancel -font $lFont -default normal \
		-command "pref_cancel $tl" -bg $BG -fg $FG

	pack $tl.cancel $tl.ok -side right -padx 5 -pady 5
	tkwait variable button
	destroy $tl
	focus $oldFocus
	return $button
}
