#!/bin/sh
# the next line restarts using wish \
exec wishstep8.0 "$0" "$@"

package require Img

set muggy_currentVersion 1.3

######################################################################
#
# About
#			Wed Sep 23 21:46:40 JST 1998:Jun Wakaya
#

proc muggy_about {} {
	if [winfo exists .mAbout] return

	toplevel .mAbout -bd 10 -relief flat -bg #3f3f3f

	wm title .mAbout "About Muggy."
	bind .mAbout <Any-Button> "destroy .mAbout"
	bind .mAbout <Any-Key> "destroy .mAbout"
	label .mAbout.l -image muggyAbout -highlightthickness 0 \
		-relief sunken
	pack .mAbout.l
}

proc muggy_help {} {
	global locale Jlib muggyMode
#	muggy_file $Jlib/hamsters/index.hamster html
	muggy_about
}

###################################################################
#
# Buffer manipuration
#
#

proc muggy_close {} {
	global Current Max muggyMode
	global muggy_textModes
	global muggy_textBuffer muggy_textCodes muggy_textModified
	global muggy_textName
	global textFg textBg id

	if {$Max>0} {
		if {$Current!=$Max} {
			for {set i [expr $Current+1]} {$i<[expr $Max+1]} {incr i} {
				set I [expr $i-1]

				set muggy_textModes($I) $muggy_textModes($i)
				set muggy_textBuffer($I) $muggy_textBuffer($i)
				set muggy_textCodes($I) $muggy_textCodes($i)
				set muggy_textModified($I) $muggy_textModified($i)
				set muggy_textName($I) $muggy_textName($i)
			}

			set muggy_textModes($i) {}
			set muggy_textBuffer($i) {}
			set muggy_textCodes($i) {}
			set muggy_textModified($i) {}
			set muggy_textName($i) {}

			incr Max -1

			.middle.bed.f.text configure -state normal
			.middle.bed.f.text delete 1.0 end
			muggy_hOpen
		} else {
			set muggy_textModes($Max) {}
			set muggy_textBuffer($Max) {}
			set muggy_textCodes($Max) {}
			set muggy_textModified($Max) {}
			set muggy_textName($Max) {}

			incr Max -1
			incr Current -1

			.middle.bed.f.text configure -state normal
			.middle.bed.f.text delete 1.0 end
			muggy_hOpen
		}
	} else {
		set muggy_textModes($Max) {edit}
		set muggy_textBuffer($Max) {}
		set muggy_textCodes($Max) {ANY}
		set muggy_textModified($Max) {0}
		set muggy_textName($Max) {Untitled.txt}

		.middle.bed.f.text configure -state normal
		.middle.bed.f.text delete 1.0 end

		.upper.l.ball configure -image MmuggyGBall
		muggy_editMode
	}
}

proc muggy_newBuffer {name} {
	global Current Max muggyMode
	global muggy_textModes
	global muggy_textBuffer muggy_textCodes muggy_textModified muggy_textName
	global textFg textBg id

	.middle.bed.f.text delete 1.0 end

	set muggyMode edit
	set Current [incr Max]
	set muggy_textName($Current) $name
	set muggy_textBuffer($Current) ""
	set muggy_textModes($Current) edit
	set muggy_textModified($Current) 0
	set muggy_textCodes($Current) EUC

	wm title . $muggy_textName($Current)

	muggy_buttonCnt
}

proc muggy_buttonCnt {} {
	global Max Current

	if {$Current!=0} {
		.upper.m.prev configure -state normal
	} else {
		.upper.m.prev configure -state disabled
	}

	if {$Current<$Max} {
		.upper.m.next configure -state normal
	} else {
		.upper.m.next configure -state disabled
	}
}

proc muggy_hOpen {} {
	global Current muggyMode
	global muggy_textModes
	global muggy_textBuffer muggy_textModified muggy_textName
	global textFg textBg id

	textUndoer--reset $id
	delete textUndoer $id

	wm title . $muggy_textName($Current)
	.middle.bed.f.text delete 1.0 end

	switch $muggy_textModes($Current) {
		"view" {
			.middle.bed.f.text configure -state normal
			.middle.bed.f.text configure -fg $textFg -bg $textBg
			.middle.bed.f.text insert end $muggy_textBuffer($Current)
			muggy_viewMode
		}

		"edit" {
			.middle.bed.f.text configure -state normal
			.middle.bed.f.text configure -fg $textFg -bg $textBg
			.middle.bed.f.text insert end $muggy_textBuffer($Current)
			muggy_editMode
		}
	}

	if {$muggy_textModified($Current)==1} {
		.upper.l.ball configure -image MmuggyRBall
	} else {
		.upper.l.ball configure -image MmuggyGBall
	}

#	muggy_jump 1.0
	muggy_buttonCnt

	set id [new textUndoer .middle.bed.f.text]
}

proc muggy_hist mode {
	global Max Current
	global muggy_textModes
	global muggy_textBuffer muggy_textModified muggy_textName
	global muggyMode

	if {$muggyMode!="edit"} {
		.middle.bed.f.text configure -state normal
	}

	set muggy_textBuffer($Current) [.middle.bed.f.text get 1.0 "end -1 chars"]

	switch $mode {
		n {
			if {$Max>$Current} {incr Current} else return
			muggy_hOpen
		}
		p {
			if {$Current!=0} {incr Current -1}
			muggy_hOpen
		}
	}

	if {$muggyMode!="edit"} {
		.middle.bed.f.text configure -state disabled
	}
}

####################################################################
#
# Locale
#
#

proc muggy_Locale para {
	global locale Jlib
	global fontName Cur SelFg SelBg textFg textBg bSuffix
	global mBg tText tBg tCur sFg sBg lang bSuf
	global bgColor fgColor
	global tcl_platform

	set locale $para
	if {$tcl_platform(platform) == "macintosh"} {
		source $Jlib:menu:menu.$locale
	} else {
		source $Jlib/menu/menu.$locale
	}
}

####################################################################
#
# Misc
#
#

proc muggy_insertDate {t} {
	$t insert insert [exec date]
}

####################################################################
#
# Exit
#
#

proc muggy_exit {} {
	global Current Max muggyMode
	global muggy_textBuffer muggy_textModified muggy_textName

	if {$muggyMode=="view"} {
		.middle.bed.f.text configure -state normal
	}

	set muggy_textBuffer($Current) [.middle.bed.f.text get 1.0 "end -1 chars"]

	if {$Current!=0} {set Current 0}

	muggy_hOpen

	for {set i 0} {$i<=$Max} {incr i} {
		if {$muggy_textModified($i)==1} {
			set Current $i
			muggy_hOpen

			set ans [tk_dialog .d exit \
			"Save $muggy_textName($i)?" warning 0 "save" "skip" "cancel"]

			if {$ans=="0"} {
				muggy_file {} save
				muggy_hist n
			} elseif {$ans=="1"} {
				muggy_hist n
			} elseif {$ans=="2"} {
				if {$muggyMode=="view"} {
					.middle.bed.f.text configure -state disabled
				}
				return
			}
		}
	}

	exit
}

####################################################################
#
# Jump
#
#

proc muggy_jump dist {
	global muggyMode

	focus .middle.bed.f.text

	.middle.bed.f.text configure -state normal
	.middle.bed.f.text mark set insert $dist
	.middle.bed.f.text tag remove sel 1.0 end
	.middle.bed.f.text see insert

	tkTextSetCursor .middle.bed.f.text $dist

	if {$muggyMode=="view"} {
		.middle.bed.f.text configure -state disabled
	}
}

#######################################################################
#
# Cut and paste
#
#

proc muggy_copyString {t} {
	global buffer
	set index [$t tag nextrange sel 1.0]
	if {$index == ""} return
	set buffer [eval $t get $index]
	clipboard clear
	clipboard append $buffer
}

proc muggy_cutString {t} {
	global buffer
	global Current muggy_textModified

	set index [$t tag nextrange sel 1.0]
	if {$index == ""} return
	set buffer [eval $t get $index]
	eval $t delete $index
	clipboard clear
	clipboard append $buffer

	set muggy_textModified($Current) 1
	.upper.l.ball configure -image MmuggyRBall
}

proc muggy_pasteString {t} {
	global buffer
	global Current muggy_textModified

	if [catch {selection get} sel] {
		if [catch {selection get -selection CLIPBOARD} sel] {
			$t insert insert $buffer
		}
	}
	$t insert insert $sel

	set muggy_textModified($Current) 1
	.upper.l.ball configure -image MmuggyRBall
}

proc muggy_KcopyString {t} {
	global buffer
	if {[$t tag ranges sel] != ""} {
		muggy_copyString $t
	} else {
		set idx [$t index insert]
		set txt [$t get "insert linestart" "insert lineend +1char"]
		set buffer $txt
		scan $idx "%d.%d" line char
		set new [$t index [expr $line + 1].0]
		if {[$t compare $new == end] || \
			[$t compare $new == "insert linestart"]} {
			set new $idx
		}
		set tkPriv(prevPos) $new
		$t insert $new $txt
	}
}

proc muggy_KcutString {t} {
	global buffer tkPriv
	if {[$t tag ranges sel] != ""} {
		muggy_cutString $t
	} else {
		set idx [$t index insert]
		set txt [$t get "insert linestart" "insert lineend +1char"]
		set buffer $txt
		$t delete "insert linestart" "insert lineend +1char"
		scan $idx "%d.%d" line char
		set new [$t index [expr $line + 1].$char]
		if {[$t compare $new == end] || \
			[$t compare $new == "insert linestart"]} {
			set new $idx
		}
		set tkPriv(prevPos) $new
	}
}

#######################################################################
#
# File manipuration
#
#

proc muggy_fileDialog {w operation} {

	set types {
		{"All files"		*}
		{"Text files"		{.txt .text .1}	}
		{"Tcl/Tk Source files"	{.tcl .tk}	}
		{"C Source files"	{.c .h}		}		
	}

	switch $operation {
		open "set file [tk_getOpenFile -filetypes $types -parent $w]"

		saveas "set file [tk_getSaveFile -filetypes $types -parent $w \
			-initialfile Untitled -defaultextension .txt]"
	}
}

proc muggy_file {fName fMode} {

	.upper.m.file configure -relief flat

	global Current Max muggyMode argv0 bSuffix
	global muggy_textModes
	global muggy_textName muggy_textModified muggy_textBuffer
	global textFg textBg l10n

	.middle.bed.f.text configure -state normal

	if {$fMode=="newopen"} {

		if {$fName=={}} {
			set fName [muggy_fileDialog . $fMode]
			if {$fName=={}} return
		}

		if {![file exists $fName]} return

		set fName [file nativename $fName]
		.middle.bed.f.text configure -state normal
		
		set Current [incr Max]

		for {set i 0} {$i<$Max} {incr i} {
			if {$muggy_textName($i)==$fName} {
				if {$Max==1} break
				incr Max -1
				set Current $i
				muggy_hOpen
				return
			}
		}

		set muggy_textName($Current) $fName
		set muggy_textModes($Current) view
		.middle.bed.f.text delete 1.0 end

		set textFile [open $fName r]
		set muggy_textBuffer($Current) [read $textFile]
		if {$l10n==1} {
			global muggy_textCodes
			set muggy_textCodes($Current) [kanji code $muggy_textBuffer($Current)]
		}
		.middle.bed.f.text configure -fg $textFg -bg $textBg
		.middle.bed.f.text insert end $muggy_textBuffer($Current)
		close $textFile

		muggy_jump 1.0

		wm title . $muggy_textName($Current)

		muggy_buttonCnt
		muggy_viewMode

		update

	} elseif {$fMode=="open"} {
		set muggy_textBuffer($Current) \
			[.middle.bed.f.text get 1.0 "end -1 chars"]

		if {$fName=={}} {
			set fName [muggy_fileDialog . $fMode]
			if {$fName=={}} return
		}

		if {![file exists $fName]} return

		set fName [file nativename $fName]
		.middle.bed.f.text configure -state normal
		
		set Current [incr Max]

		for {set i 0} {$i<$Max} {incr i} {
			if {$muggy_textName($i)==$fName} {
				if {$Max==1} break
				incr Max -1
				set Current $i
				muggy_hOpen
				return
			}
		}

		set muggy_textName($Current) $fName
		set muggy_textModes($Current) view
		.middle.bed.f.text delete 1.0 end

		set textFile [open $fName r]
		set muggy_textBuffer($Current) [read $textFile]
		if {$l10n==1} {
			global muggy_textCodes
			set muggy_textCodes($Current) [kanji code $muggy_textBuffer($Current)]
		}
		.middle.bed.f.text configure -fg $textFg -bg $textBg
		.middle.bed.f.text insert end $muggy_textBuffer($Current)
		close $textFile

		muggy_jump 1.0
		muggy_viewMode

		wm title . $muggy_textName($Current)

		muggy_buttonCnt
	} elseif {$fMode=="save"} {
		if {$muggyMode=="view"} {
			.middle.bed.f.text configure -state disabled
			return
		}

		set fName $muggy_textName($Current)
		set text [.middle.bed.f.text get 1.0 end]

		if {[file exists $fName]} {
			file copy -force -- $fName $fName$bSuffix
		}

		if {$l10n==1} {
			global muggy_textCodes
			if {$muggy_textCodes($Current)=="ANY"} {
				set muggy_textCodes($Current) EUC
			}
		}

		set dirBack [pwd]
		cd [file dirname $fName]

		set textFile [open [file tail $fName] w]
		if {$l10n==1} {
			kanji outputCode $textFile $muggy_textCodes($Current)
		}
		puts -nonewline $textFile $text
		close $textFile

		cd $dirBack
	} elseif {$fMode=="saveas"} {
		if {$muggyMode=="view"} {
			.middle.bed.f.text configure -state disabled
			return
		}

		if {$fName=={}} {
			set fName [muggy_fileDialog . $fMode]
			if {$fName=={}} return
		}

		set text [.middle.bed.f.text get 1.0 end]

		if {[file exists $fName]} {
			file copy -force -- $fName $fName$bSuffix
		}

		if {$l10n==1} {
			global muggy_textCodes
			if {$muggy_textCodes($Current)=="ANY"} {
				set muggy_textCodes($Current) EUC
			}
		}

		set textFile [open $fName w]
		if {$l10n==1} {
			kanji outputCode $textFile $muggy_textCodes($Current)
		}

		puts -nonewline $textFile $text
		close $textFile

		set muggy_textModified($Current) 0
		set Current [incr Max]
		set muggy_textName($Current) $fName
		set muggy_textBuffer($Current) [.middle.bed.f.text get 1.0 "end -1 chars"]
		set muggy_textModes($Current) view

		wm title . $muggy_textName($Current)

		muggy_buttonCnt
	}

	if {$muggyMode=="view"} {
		.middle.bed.f.text configure -state disabled
	}

	set muggy_textModified($Current) 0
	.upper.l.ball configure -image MmuggyGBall

}

proc muggy_popFile {fMode} {

	global muggyMode Current muggy_textModified

	if {$fMode=="open"} {
		if {$muggyMode!="view"} {
			.middle.bed.f.text configure -state normal
		} else return

		catch ".middle.bed.f.text delete sel.first sel.last"

		set fName [muggy_fileDialog . $fMode]

		set textFile [open $fName r]
		set text [read -nonewline $textFile]

		.middle.bed.f.text insert insert $text
		close $textFile

		set muggy_textModified($Current) 1
		.upper.l.ball configure -image MmuggyRBall

	} elseif {$fMode=="saveas"} {
		set text [.middle.bed.f.text get sel.first sel.last]

		set fName [muggy_fileDialog . $fMode]
		if {$fName=={}} return

		set textFile [open $fName w]
		puts -nonewline $textFile $text
		close $textFile
	}
}

proc muggy_viewMode {} {
	global Current muggyMode muggy_textModes

	set muggyMode view
	set muggy_textModes($Current) view
	.upper.m.mode configure -image muggyview
	.middle.bed.f.text configure -state disabled
}

proc muggy_editMode {} {
	global Current muggyMode muggy_textModes

	set muggyMode edit
	set muggy_textModes($Current) edit
	.upper.m.mode configure -image muggyedit
}

proc muggy_modeChange {} {
	global muggyMode Current

	switch $muggyMode {
		view {
			muggy_editMode
		}

		edit {
			muggy_viewMode
		}
	}

	muggy_jump insert
	muggy_binding
}

#######################################################################
#
# Make skelton
#                       Wed Sep  2 22:42:28 JST 1998:Jun Wakaya
#

proc muggy_coolbutton {b} {
	$b configure -relief flat -highlightthickness 0

	bind $b <Enter> {
		if {[%W cget -state]!="disabled"} {
			%W configure -relief raise
		}
	}
	bind $b <Leave> {%W configure -relief flat}
}

proc muggy_binding {} {
	global muggyMode tcl_platform step l10n

	if {$muggyMode=="edit"} {
		bind . <Key-q> ""
		bind . <Key-Up> ""
		bind . <Key-Down> ""
	} else {
		bind . <Key-q> muggy_exit
		bind . <Key-Up> ".middle.bed.f.text yview scroll -1 units"
		bind . <Key-Down> ".middle.bed.f.text yview scroll 1 units"
	}

	bind all <F10> {}
	bind all <Control-o> {}

#	bind . <Alt-o> "muggy_file {} open"
#	bind . <Alt-s> "muggy_file {} save"

#	bind . <Key-Alt> "muggy_AccessToAlt"

	bind . <F1> ".upper.m.mode invoke"
	bind . <F2> "tk_popup .upper.u.file.menu %X %Y"
	bind . <Alt-f> "tk_popup .upper.u.file.menu %X %Y"
	bind . <F3> "tk_popup .upper.u.edit.menu %X %Y"
	bind . <Alt-e> "tk_popup .upper.u.edit.menu %X %Y"
	bind . <F4> "tk_popup .upper.u.search.menu %X %Y"
	bind . <Alt-s> "tk_popup .upper.u.search.menu %X %Y"
	bind . <F5> ".upper.m.prev invoke"
	bind . <F6> ".upper.m.next invoke"

	bind .middle.bed.f.text <F7> "muggy_KcutString .middle.bed.f.text"
	bind .middle.bed.f.text <Control-x> "muggy_KcutString .middle.bed.f.text"
	bind .middle.bed.f.text <F8> "muggy_KcopyString .middle.bed.f.text"
	bind .middle.bed.f.text <Control-c> "muggy_KcopyString .middle.bed.f.text"
	bind .middle.bed.f.text <F9> "muggy_pasteString .middle.bed.f.text"
	bind .middle.bed.f.text <Control-v> "muggy_pasteString .middle.bed.f.text"
	bind .middle.bed.f.text <Shift-F10> "tk_popup .upper.u.edit.menu %X %Y"

	bind .middle.bed.f.text <Alt-t> "muggy_jump 1.0"
	bind .middle.bed.f.text <Alt-b> "muggy_jump end"

	bind .middle.bed.f.text <Alt-d> "muggy_insertDate .middle.bed.f.text"

	bind . <KeyPress-Escape> ".upper.m.logo invoke"

	bind .middle.bed.f.text <ButtonRelease-3> "tk_popup .upper.u.edit.menu %X %Y"

	if {$step == "1"} {
		bind . <Drop> "muggy_file %D open"
	}

	if {$l10n == "1"} {
		bind .middle.bed.f.text <Shift-space> "kinput_start %W over"
		bind .middle.bed.f.text <Control-o> "kinput_start %W over"
		bind .middle.bed.f.text <Mod1-Zenkaku_Hankaku> "kinput_start %W over"
	}

	bind . <Alt-F4> "muggy_exit"

	bind .middle.bed.f.text <Any-Key> "muggy_identifyModified %N"

	wm protocol . WM_DELETE_WINDOW {muggy_exit}
}

proc muggy_AccesedToAlt {} {
	global isAlt

	set isAlt 1
}

proc muggy_identifyModified keySym {
	global Max Current muggy_textModified muggyMode isAlt

	if {$muggyMode=="view"} return

	if {$keySym==65513} {
		set isAlt 1
		return
	}

	if {$isAlt==1} {
		set isAlt 0
		return
	}

	if {$keySym>31&&$keySym<123} {
		set muggy_textModified($Current) 1
		.upper.l.ball configure -image MmuggyRBall
	} elseif {$keySym==65288||$keySym==65289||$keySym==65293||$keySym==65535} {
		set muggy_textModified($Current) 1
		.upper.l.ball configure -image MmuggyRBall
	}
}

proc muggy_rePref {} {
	global locale Jlib Jdef fgColor bgColor
	global fontName Cur SelFg SelBg textFg textBg bSuffix
	global mBg mText tText tBg tCur sFg sBg lang bSuf
	global tcl_platform
	global l10n

	if {$tcl_platform(platform)=="macintosh"} {
		if {[file exists "$Jdef:Muggy"]} {
			source "$Jdef:Muggy"
		}
	} else {
		if {[file exists "$Jdef/Muggy"]} {
			source "$Jdef/Muggy"
		}
	}


	if {$lang=="ja"} {
		set strC "kstring"
		set locale ja
	} else {
		set strC "string"
		set locale en
	}

	set fgColor $mText
	set bgColor $mBg
	set textFg $tText
	set textBg $tBg
	set Cur $tCur
	set SelFg $sFg
	set SelBg $sBg
	set bSuffix $bSuf

	muggy_Locale $locale

	foreach i {.upper .middle .upper.u .upper.m .upper.l} {
		$i configure -bg $bgColor}
	foreach i {file edit search} {
		.upper.u.$i configure -fg $fgColor -bg $bgColor}
	foreach i {.upper.u.help .upper.m.mode .upper.m.file} {
		$i configure -fg $fgColor -bg $bgColor}
	foreach i {.upper.m.find .upper.m.prev .upper.m.next} {
		$i configure -bg $bgColor}
	foreach i {.upper.m.logo .upper.l.cut .upper.l.copy} {
		$i configure -bg $bgColor}
	foreach i {.upper.l.paste .upper.l.save .upper.l.load} {
		$i configure -bg $bgColor}
	foreach i {.upper.l.ball .middle.bed .middle.bed.f} {
		$i configure -bg $bgColor}

	.middle.bed.f.sb configure -bg $bgColor

	.middle.bed.f.text configure -width 80 -height 24\
		-font $fontName -fg $textFg -bg $textBg \
		-selectforeground $SelFg -selectbackground $SelBg \
		-insertbackground $Cur
}

proc muggy_Pref {} {
	set ret [muggy_Preference]

	if {$ret=="0"} {
		muggy_rePref
	}
}

proc muggy_makeSkelton {} {
	global locale Current argv0 Jlib muggyMode muggy_textName id
	global fontName bgColor fgColor Cur SelFg SelBg textFg textBg

	wm title . $muggy_textName($Current)
	wm group . .
	wm command . "Muggy.app"

	. configure -relief flat -bg $bgColor

	frame .upper -bg $bgColor -relief flat
	frame .upper.u -bg $bgColor -relief raise -bd 1
	frame .upper.m -bg $bgColor -height 48 -relief raise -bd 1
	frame .upper.l -bg $bgColor -relief raise -bd 1
	frame .middle -bg $bgColor
	frame .lower -bg $bgColor

	pack .upper -fill both
	pack .middle -fill both -expand 1
	pack .upper.u -fill both
	pack .upper.m .upper.l -fill both

	foreach i {file edit search} {
		menubutton .upper.u.$i -fg $fgColor -bg $bgColor \
			-menu .upper.u.$i.menu
		pack .upper.u.$i -side left -fill both -padx 10
	}

	menubutton .upper.u.help -fg $fgColor -bg $bgColor -menu .upper.u.help.menu
	pack .upper.u.help -side right -fill both -padx 10

	button .upper.m.mode -bg $bgColor -image muggy$muggyMode \
		-command muggy_modeChange
	muggy_coolbutton .upper.m.mode

	button .upper.m.file -bg $bgColor -image muggyFile \
		-command "muggy_file {} open"
	muggy_coolbutton .upper.m.file

	button .upper.m.find -bg $bgColor -image muggyFind \
		-command "SearchString .search Search .middle.bed.f.text 0"
	muggy_coolbutton .upper.m.find

	button .upper.m.prev -bg $bgColor -state disabled -image muggyArrL \
		-command "muggy_hist p"
	muggy_coolbutton .upper.m.prev

	button .upper.m.next -bg $bgColor -state disabled -image muggyArrR \
		 -command "muggy_hist n"
	muggy_coolbutton .upper.m.next

	button .upper.m.logo -bg $bgColor -image muggyLogo \
		-command "muggy_help" -bd 3 -highlightthickness 0

	pack .upper.m.mode .upper.m.file .upper.m.find \
		.upper.m.prev .upper.m.next -padx 5 -side left
	pack .upper.m.logo -side right

	button .upper.l.cut   -bg $bgColor -image MmuggyCut -width 48 \
		-command "muggy_cutString .middle.bed.f.text"
	muggy_coolbutton .upper.l.cut

	button .upper.l.copy  -bg $bgColor -image MmuggyCopy -width 48 \
		-command "muggy_copyString .middle.bed.f.text"
	muggy_coolbutton .upper.l.copy
	button .upper.l.paste -bg $bgColor -image MmuggyPaste -width 48 \
		-command "muggy_pasteString .middle.bed.f.text"
	muggy_coolbutton .upper.l.paste
	button .upper.l.save  -bg $bgColor -image MmuggySave -width 48 \
		-command "muggy_popFile saveas"
	muggy_coolbutton .upper.l.save
	button .upper.l.load  -bg $bgColor -image MmuggyLoad -width 48 \
		-command "muggy_popFile open"
	muggy_coolbutton .upper.l.load

	label .upper.l.ball  -relief flat -bg $bgColor -image MmuggyGBall

	pack .upper.l.cut .upper.l.copy .upper.l.paste \
		.upper.l.save .upper.l.load -padx 10 -side left

	pack .upper.l.ball -padx 10 -side right

	frame .middle.bed -bg $bgColor -relief raise -bd 1
	pack .middle.bed -fill both -expand 1

	frame .middle.bed.f -bg $bgColor -relief flat -bd 5
	pack .middle.bed.f -fill both -expand 1

	scrollbar .middle.bed.f.sb -command ".middle.bed.f.text yview" \
		-orient vertical -relief sunken \
		-bg $bgColor
	text .middle.bed.f.text -relief sunken -bd 2 -width 80 -height 24\
		-yscrollcommand ".middle.bed.f.sb set" \
		-font $fontName -fg $textFg -bg $textBg \
		-selectforeground $SelFg -selectbackground $SelBg \
		-insertbackground $Cur
	pack .middle.bed.f.sb -side left -fill both
	pack .middle.bed.f.text -expand 1 -side left -fill both

	frame .lower.bed -bg $bgColor -relief raise -bd 1
	pack .lower.bed -fill both -expand 1

	frame .lower.bed.f -bg $bgColor -relief flat -bd 5
	pack .lower.bed.f -fill both -expand 1

	scrollbar .lower.bed.f.sb -command ".lower.bed.f.text yview" \
		-orient vertical -relief sunken \
		-bg $bgColor
	text .lower.bed.f.text -relief sunken -bd 2 -width 80 -height 12\
		-yscrollcommand ".lower.bed.f.sb set" \
		-font $fontName -fg $textFg -bg $textBg \
		-selectforeground $SelFg -selectbackground $SelBg \
		-insertbackground $Cur
	pack .lower.bed.f.sb -side left -fill both
	pack .lower.bed.f.text -expand 1 -side left -fill both

	set id [new textUndoer .middle.bed.f.text]
}

#######################################################################
#
# Main routine
#                       Wed Sep  2 21:52:28 JST 1998:Jun Wakaya
#

set l10n 0;set step 0

set mText black;set mBg #c0c0c0
set tText black;set tBg #c0c0c0
set lang en
set fontName "a14"
set tCur black
set sFg white;set sBg black
set bSuf "~"

if {$tcl_platform(platform) == "unix"} {
	set Jlib "/usr/X11R6/JDE/Muggy/"
	set Jdef "~/GNUstep/Defaults"

	set temp [lindex [file split [set tk_library]] end]

	if {[string first step $temp]!="-1"} {set step 1} else {set step 0}
	if {[string first jp $temp]!="-1"} {set l10n 1} else {set l10n 0}

	if {![file exists "$Jdef/Muggy"]} {
		file mkdir $Jdef
		file copy -force -- $Jlib/defaults/Muggy $Jdef
	}

}  elseif {$tcl_platform(platform) == "macintosh"} {
	set Jlib "/usr/X11R6/JDE/Muggy/"
	set Jdef "Macintosh HD:Muggy:defaults"
} else {
	set Jlib "/usr/X11R6/JDE/Muggy/"
	set Jdef "/Program Files/Muggy/defaults/"
}

if {$l10n=="1"} {
	set strC "kstring"
	set locale ja
	set muggy_textCodes(0) EUC
} else {
	set strC "string"
	set locale en
}

set Current 0
set Max $Current
set muggy_textName($Current) Untitled.txt
set muggy_textBuffer($Current) {}
set muggyMode edit
set muggy_textModes($Current) $muggyMode
set muggy_textModified($Current) 0
set fgColor $mText
set bgColor $mBg
set buffer {}
set textFg $tText
set textBg $tBg
set Cur $tCur
set SelFg $sFg
set SelBg $sBg
set bSuffix $bSuf
set id {}
set isAlt 0

set modPath [file nativename $Jlib/modules]

source $modPath/PrefMuggy.m
source $modPath/Search.m
source $modPath/Undo.m/new.tcl
source $modPath/Undo.m/lifo.tcl
source $modPath/Undo.m/textundo.tcl
source $modPath/MuggyIcons.m

muggy_makeSkelton
muggy_binding
muggy_Locale $locale

if {$argc!=0} {
	for {set i 0} {$i<$argc} {incr i} {
	        if {[file exists [lindex $argv $i]]==1} {
			set fPath [file dirname [lindex $argv $i]]
			set fTail [file tail [lindex $argv $i]]

			if {$fPath=="."} {
				set fName [pwd]/$fTail
			} elseif {$fPath==".."} {
				cd ..
				set fName [pwd]/$fTail
			} elseif {[string range $fPath 0 0]!="/"} {
				set fName $fPath/[lindex $argv $i]
			} else {
				set fName [lindex $argv $i]
			}

			set fName [file nativename $fName]
			set muggyMode view
			muggy_viewMode

			muggy_file $fName newopen
	        } else {
			muggy_newBuffer [pwd]/[lindex $argv $i]
	        }
	}
}

muggy_rePref
cd $env(HOME)

