#ifndef INCL_DLIST_H
#define INCL_DLIST_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>

struct node
{
	struct node *next;
	struct node *prev;
	int			number;
	char        *text;
};

class dlist
{
	int			numbered:1,
				freebit:1;
	struct node *last_node;
	int			last_number;
	int			count;

public:
	struct node *head;
	struct node *terminator;
	struct node *tail;

	dlist();
	~dlist();
	
	void AddHead(struct node *);
	void AddTail(struct node *);
	void Insert(struct node *,struct node *before);
	void AddAlpha(struct node *);
	
	struct node *RemHead(void);
	struct node *RemTail(void);
	void Remove(struct node*);

	int Find(struct node*);
	struct node *Find(int);
	struct node *FindText(char *text,struct node *start);
	struct node *FindText(char *text);
	struct node *FindTextNC(char *text,struct node *start); // nocase
	struct node *FindTextNC(char *text); 					// nocase
	
	int Count(void);

	int IsEmpty(void);
	int IsMember(struct node*);

	void Sort(int (*func)(struct node*,struct node*));
};

#endif
