#ifndef INCL_MESSAGE_H
#define INCL_MESSAGE_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/dlist.h>
#include <Xclasses/callable.h>

class message
{
	dlist	gadgets;
public:

	message();
	virtual ~message();

	virtual void Msg(gadget *,int t);

	void Add(gadget *,class msg_get *,class msg_conv *,class msg_set *,class msg_conv *);
	void Add(gadget &g,class msg_get *m1,class msg_conv *m2,class msg_set *m3,class msg_conv *m4)
			{ Add(&g,m1,m2,m3,m4); };
	void Remove(class gadget *);
	void Remove(class gadget &g) { Remove(&g); };

	void Set(void *);
	void Set(int v) { Set((void*)&v); };
	void Set(char *v) { Set((void*)v); };

	void *Get(void);
};

// -------------------------------------------------------------------
// abstract classes

class msg_get
{
protected:
	callable *classptr;
	void (callable::*classfunc)(void);
public:
	msg_get(callable *classptr,void (callable::*)(void));
	virtual ~msg_get();

	virtual void *get(void) =0;
};
class msg_set
{
protected:
	callable *classptr;
	void (callable::*classfunc)(void);
public:
	msg_set(callable *classptr,void (callable::*)(void));
	virtual ~msg_set();

	virtual void set(void *) =0;
};
class msg_conv
{
public:
	msg_conv();
	virtual ~msg_conv();

	virtual void *conv(void*) =0;
};

#define MSG_CHANGE		1
#define MSG_FINAL		2

#define MSGCAST		(void (*)(void))

// call the class callback:
// try this: (classptr->*(void (callable::*)(char*))classfunc)(buf);

#endif
