#ifndef INCL_TREEVIEW_H
#define INCL_TREEVIEW_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/listview.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/callable.h>
#include <Xclasses/dlist.h>
#include <Xclasses/gfx_object.h>

class treeview : public listview
{
friend class ptreeview;
	class ptreeview *p;

public:
    treeview();
    virtual ~treeview();

	int GActivate(XEvent *,int);
	int Create();

	void SetRoot(class tv_tree *);

	void Selected(class tv_tree *);
	tv_tree *Selected(void);
};

class tv_tree : public node
{
	unsigned int	opened:1,
					hassub:1,
					newtext:1,
					opening:1,
					closing:1,
					pad:1;
	int 			level;

friend class treeview;
friend class ptreeview;
	char 			*text;
	unsigned int 	width;
	gfx_object		*icon;
public:
	tv_tree 		*parent;	// Read-Only
	dlist 			sub;		// Read-Only to scan tree items

	unsigned int 	user;		// free to use

	tv_tree(void);
	tv_tree(char *text);
	virtual ~tv_tree();

	void Text(char *);
	void Icon(gfx_object *);

	virtual void Open(void);
	virtual void Close(void);
	int IsOpen(void) { return opened; };
	int HasSub(void) { return hassub; };

	void AddHead(tv_tree *);
	void AddTail(tv_tree *);
	void Insert(tv_tree *,tv_tree *before);

	void Remove(tv_tree *);
	void Remove(void) { if (parent) parent->Remove(this); };
	void RemoveAll(unsigned int flags=0);

	int Level(void);

	virtual void Update(tv_tree *);
	void SetHasSub(void) { hassub=1; };
	void SetHasNoSub(void) { hassub=0; };
};

// RemoveAll flags:
#define RAF_DELETE	0x00000001		// delete tree item

#endif
