# OpenVerse InitGlobal Variables
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Init Global Variables
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Main Module
#
# Modifications by KaosBeetl:
#    Room History, 01/16/2000, revised 02/07/2000, again 02/09/2000
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.


#
# THIS IS THE DEFAULT SERVER AND PORT
#
set MV(default_host) "world.openverse.org";	# Setup uses this one so as not to adopt the current host as the default host each time setup is pressed.
set MV(default_port) "7000";			# Setup uses this one so as not to adopt the current port as the default port each time setup is pressed.
set MV(roomhost) "world.openverse.org";		# This is our default server hostname.
set MV(roomport) "7000";			# This is our default server port.
#
# Significant RunTime Variables
#
# The following variables will have an effect on 
# OpenVerse at runtime. Others will not affect OpenVerse
# visibly and are listed after this block.
#
# Directories and files
#
set MV(personal.image) "$MV(homedir)/icons/pinfo.gif";	# The default image to use for personal info.
set MV(bookmarks) "$MV(homedir)/passageways.txt";	# Our bookmarks file.
set MV(languagedir) "$MV(libbase)/language";		# Where our language file is kept.
set MV(configfile) "$MV(homedir)/MetaV.cfg";		# The name of our configuration file.
set MV(history) "$MV(homedir)/history.txt";		# The name of the file which holds our room history.
set MV(rem_images) "$MV(homedir)/rimages";		# The dir where we keep remote  avatar images.
set MV(plugindir) "$MV(homedir)/plugins";		# The directory where plugins are placed.
set MV(objects) "$MV(homedir)/objects";			# Where do we store server object images?
set MV(paneldir) "$MV(homedir)/panels";			# Where we keep our panel files.
set MV(images) "$MV(homedir)/images";			# The dir where we keep our own avatar images.
set MV(icondir) "$MV(homedir)/icons";			# Where do we store the application's icon files?
set MV(roomdir) "$MV(homedir)/rooms";			# The dir where we store room images.
set MV(anims) "$MV(homedir)/anims";			# The directory where .av files are stored.
set MV(avatar) "default.gif";				# Your avatar's image name.
set MV(anim) "default.av";				# Your avatar's .av file name.
# MV(helpdir);						# The directory we keep our help files in, OpenVerse.tcl sets this platform specific variable.
# MV(libbase);						# Used with UNIX type machines to copy files from the central install location.
# MV(libdir);						# The directory we keep our library files in, OpenVerse.tcl sets this platform specific  variable. 

#
# Strings
#
set MV(personal.info) "Type Information About Yourself Here!";	# Info about us as displayed in our personal information section.
set MV(personal.homepage) "http://openverse.org/";		# Our home page as displayed in our personal info.
set MV(personal.email) "myemail@example.com";	# Our email address as displayed in our personal info.
set MV(download_dir) "$MV(homedir)/download";	# Where do we download files to.
set MV(roomname) "Welcome To The OpenVerse";	# The name of the room which we are currently in.
set MV(personal.realname) "My Real Name";	# Our real name as displayed in our personal info.
set MV(personal.availability) "Never";		# How to make our personal information available to other users.
set MV(font.balloon.style) "normal";		# The style of the font we use in balloons.
set MV(browser_cmd) "netscape";			# This is the command to run our web browser from.
set MV(personal.sex) "Other";			# The sex which is displayed in our personal Info.
set MV(ChtButState) "show";			# Is the chat button bar shown or hidden?
set MV(language) "English";			# The language which this user is using.
set MV(nick) "Guest";				# Your nick name!
#
# Numeric Variables
#
set MV(use_windowmanager_colors) 0;	# Do we use our own colors or do we let the window manager set the colors.
set MV(connect_on_startup) 0;		# boolean for connect on startup to the default server
set MV(font.balloon.size) 12;		# The font size to use in balloons.
set MV(download_avatars) 1;		# Do we download avatars?
set MV(name_y_offset) 40;		# Our name tag's Y offset (from the image's center)
set MV(anim.baloon_x) 24;		# Our default X offset for our chat balloon.
set MV(sort_bookmarks) 0;		# Do we sort our bookmarks by the time visited?
set MV(name_x_offset) 0;		# Our name tag's X offset (from the image's center)
set MV(anim.baloon_y) 6;		# Our default Y offset for our chat balloon.
set MV(sendbuffer) 4096;		# The buffersize to use when sending and receiving files.
set MV(honor_effects) 1;		# Do we honor avatar effects?
set MV(font.balloon) -1;		# The font you will use in balloons.
set MV(history_max) 10;			# Maximum entries in the history list.
set MV(dcctimeout) 180;			# How many seconds do we allow a DCC to not get data for before we kill it.
set MV(anim.y_off) 20;			# Our default Y offset for our nametag
set MV(keep_images) 3;			# How many days do we keep other user's images for?
set MV(honor_exits) 1;			# Do we honor the server's EXIT protocol commands?
set MV(urltimeout) 30;			# Seconds URLs will stay on the screen for.
set MV(anim.x_off) 0;			# Our default X offset for our nametag
set MV(honor_call) 1;			# Do we honnor calls?
set MV(chatsave) 200;			# How many lines of chat history do we save?
set MV(prevsave) 100;			# How many items will be stored in the history for things we sent to the server.
set MV(TCCommand) 0;			# Special Chat Type Selected.
set MV(timestamp) 0;			# Do we display time stamps?
set MV(staytime) 10;			# How many seconds balloons stay on the screen for.
set MV(movespeed) 1;			# how fast do we move?
set MV(tooltips) 1;			# Do we setup tooltips for the buttons?
set MV(nosort) 0;			# Overrides Passageway Sorting.
set MV(rot13) 0;			# Are we using ROt13 encoding?
set MV(bell) 1;				# Do we beep on sound events?
set MV(img) -1;				# Our Avatar image's ID number on the canvas.
set MV(x) 320;				# Our X location on the canvas.
set MV(y) 200;				# Our Y location on the canvas.
#
# The following variables initalize various runtime states and should not
# be changed at all!! DO NOT CHANGE VARIABLES WITHIN THIS BLOCK.
#
# Begin State Initialization Section.
#
# Strings
#
set MV(version) "0.8-4";	# OpenVerse Version Number
set MV(MyIpAddress) "0.0.0.0";	# This will be set to your correct IP Address once you download something.
#
# List Variables
#
set MV(server_objects) {};	# A list of generic objects (multiple types)
set MV(server_queries) {};	# Used when querying servers. Contains a list of numbers for servers queried.
set MV(ignore.avatar) {};	# A list of users who's avatars we are ignoring.
set MV(ignore.effect) {};	# A list of users who we are ignoring effects for.
set MV(ignore.speech) {};	# A list of users who we are not listening to.
set MV(server_links) {};	# A list of LINK objects.
set MV(server_tells) {};	# A list of server TELL objects.
set MV(server_exits) {};	# A list of EXIT_OBJ objects.
set MV(ignore.move) {};		# A list of users who's MOVE protocol commands are ignored.
set MV(ignore.sub) {};		# A list of uasers who's SUB protocol commands we are ignoring.
set MV(ignore.url) {};		# A list od users who's URLs we are ignoring.
set MV(ignore.all) {};		# A list of the people who we have chosen to ignore ALL types of messages from.
set MV(downloads) {};		# A list of downloads in progress.
set MV(roomloads) {};		# A list of room images which are downloading.
set MV(plugins) {};		# A list of plugins installed.
set MV(people) {};		# A list of user names for everyone who is connected.
set MV(chats) {};		# This is the chat history, defaults to 200 lines.
set MV(moves) {};		# A list of users moves which are qued up.
set MV(prev) {};		# A list of all the stuff we've sent to the server.
set MV(dcc_list) {};		# A list of active downloads.
#
# Numeric Variables
#
set MV(default_avatar_number) 0;	# Which avatar in the list is our default one?
set MV(debug.scroll.other) 1;	# Do we scroll the debug 'other' section?
set MV(debug.scroll.prot) 1;	# Do we scroll the debug 'protocol' section?
set MV(current_exits_id) 0;	# What is the id for the next exit object we create.
set MV(downloadingroom) 0;	# Are we downloading a room image?
set MV(textwindow.lock) 0;	# Our scroll lock option within the Text Chat window.
set MV(current_link_id) 0;	# What is the id for the next link object we create. 
set MV(current_tell_id) 0;	# What is the id for the next tell object we create.
set MV(anim.current) -1;	# The avtar number which we are wearing.
set MV(popup_window) 0;		# Used for error dialogs. Incrementing number.
set MV(anim.running) 0;		# If our avatar is animated, is it currently running?
set MV(pwq.queries) 0;		# Used by the Passageways module and is the number of queries which we activated to the servers.
set MV(textwindow) 0;		# Is the Text Chat window open?
set MV(killsteam) 0;		# ID used for holding the name of the person who belongs to a steam image.
set MV(killnotes) 0;		# ID used for holding the name of the person who belongs to a music notes image.
set MV(killsmile) 0;		# ID used for holding the name of the person who belongs to a smile image.
set MV(killfrown) 0;		# ID used for holding the name of the person who belongs to a frown image.
set MV(anim.stop) 1;		# Are we going to stop the animation next time it's scheduled to run?
set MV(killhigh) 0;		# ID used for holding the name of the person who belongs to a chat balloon.
set MV(killlove) 0;		# ID used for holding the name of the person who belongs to a love image.
set MV(killidea) 0;		# ID used for holding the name of the person who belongs to a idea image.
set MV(killwink) 0;		# ID used for holding the name of the person who belongs to a wink image.
set MV(curprev) -1;		# This tells us if we are scrolling forwards or backwards in our sent chat history.
set MV(dcc_num) 0;		# The number of the next DCC transfer we will do.
set MV(moving) 0;		# Are we moving?
set MV(names) 1;		# Do we show user nametags?
set MV(sock) -1;		# This is our socket to the server.
set MV(debug) 0;		# Are we in debug mode?
set MV(log) 0;			# Are we logging things?
#
# Window name variables.
#
set MV(avatar_menu) "ERROR";		# This is the container for the avatars menu button. Your pannel should set this.
set MV(chat_entry) "ERROR";		# This is the container for the chat entry widget. Your pannel should set this.
set MV(connect_button) "ERROR";		# This is the container for the connect button widget. Your pannel should set this.
set MV(names_menu) "ERROR";		# This is the container for the Names menu button widget. Your pannel should set this.
set MV(passageways_menu) "ERROR";	# This is the container for the Passageways menu button widget. Your pannel should set this.
set MV(plugin_frame) "ERROR";		# This is the container for plugins to use to put any buttons they may need. Your pannel should set this.
#
# End State Initialization Section.
#

#
# Panel Related
#
set MV(panel) "Fun";			# The name of the Panel which we are using.

# ------------------------------------------------------------------------
#                          Plugin Specific Variables.
# ------------------------------------------------------------------------

# ------------------------------------
# ProcChat {who what system balloon}
# ------------------------------------
set MV(plugin.traps.ProcChat.pre) {}
set MV(plugin.traps.ProcChat.post) {}

# ------------------------------------
# endDCC {transfer_type download_index success_flag message}
# ------------------------------------
set MV(plugin.traps.endDCC.pre) {}
set MV(plugin.traps.endDCC.post) {}

# ------------------------------------
# ChangeAvatar {filename}
# ------------------------------------
set MV(plugin.traps.ChangeAvatar) {}

# ------------------------------------
# ChangeNick {newnick}
# ------------------------------------
set MV(plugin.traps.ChangeNick) {}

# ------------------------------------
# ChangeUserAvatar {who filename name_x name_y filesize baloon_x baloon_y}
# ------------------------------------
set MV(plugin.traps.ChangeUserAvatar) {}

# ------------------------------------
# Disconnect {}
# ------------------------------------
set MV(plugin.traps.Disconnect) {}

# ------------------------------------
# Debug_memory {file_descriptor}
# ------------------------------------
set MV(plugin.traps.Debug_memory) {}

# ------------------------------------
# Names {} (Called once, for options which affect ALL users)
# ------------------------------------
set MV(plugin.traps.Names) {}

# ------------------------------------
# DoNames {widget who idx} (will call for each name in list.)
# ------------------------------------
set MV(plugin.traps.DoNames) {}

# ------------------------------------
# Exit {host port}
# ------------------------------------
set MV(plugin.traps.Exit.pre) {}
set MV(plugin.traps.Exit.post) {}

# ------------------------------------
# ShowName {who}
# ------------------------------------
set MV(plugin.traps.ShowName) {}

# ------------------------------------
# ShowNames {who} (will process for each user.)
# ------------------------------------
set MV(plugin.traps.ShowNames) {}

# ------------------------------------
# KillNames {who} (will process for each user.)
# ------------------------------------
set MV(plugin.traps.KillNames) {}

# ------------------------------------
# ProcURL {who url type}
# ------------------------------------
set MV(plugin.traps.ProcURL) {}

# ------------------------------------
# RightClick {x y}
# ------------------------------------
set MV(plugin.traps.RightClick) {}

# ------------------------------------
# MoveTo {x y}
# ------------------------------------
set MV(plugin.traps.MoveTo.Pre) {}
set MV(plugin.traps.MoveTo.Post) {}

# ------------------------------------
# Pushed {x y}
# ------------------------------------
set MV(plugin.traps.Pushed.Pre) {}
set MV(plugin.traps.Pushed.Post) {}

# ------------------------------------
# MoveUser {who x y speed}
# ------------------------------------
set MV(plugin.traps.MoveUser.Pre) {}
set MV(plugin.traps.MoveUser.Post) {}

# ------------------------------------
# NewPerson {who x y filename name_x name_y filesize baloon_x baloon_y}
# ------------------------------------
set MV(plugin.traps.NewPerson) {}

# ------------------------------------
# ProcessCommand {original cmd parms rest}
# ------------------------------------
set MV(plugin.traps.ProcessCommand) {}

# ------------------------------------------------------------------------
#                       Our URL Type Handlers.
# ------------------------------------------------------------------------
set MV(URLS.x) {20 60 100 140 180 220 260 300 340 380 420 460 500 540 580 620}
set MV(URLS.y) {20 60 100 140 180 220 260 300 340 380 420}
for {set c 0} {$c < 16} {incr c} {
	for {set d 0} {$d < 12} {incr d} {
		set MV(URLS.$c.$d) 0
	}
}

# ------------------------------------------------------------------------
#                       Our default color scheme.
# ------------------------------------------------------------------------

# ------------------------------------
# PersonLeft {who}
# ------------------------------------
set MV(plugin.traps.PersonLeft) {}

# ------------------------------------
# ProcessInput {original_text cmd parms rest}
# ------------------------------------
set MV(plugin.traps.ProcessInput.pre) {}
set MV(plugin.traps.ProcessInput.post) {}

# ------------------------------------
# SendText {text_to_send}
# ------------------------------------
set MV(plugin.traps.SendText) {}

# ------------------------------------------------------------------------
#                       Balloon Fonts available.
# ------------------------------------------------------------------------
#
# Build a list from available fonts.
#
set MV(font.balloon.-1.name) ""
set MV(font.balloon.-1.normal) ""
set MV(font.balloon.-1.bold) "-weight bold"
set MV(font.balloon.-1.italic) "-slant italic"
set MV(font.balloon.-1.bold_italic) "-slant italic -weight bold"
set MV(font_max) 0
foreach family [lsort [font families]] {
	set MV(font.balloon.$MV(font_max).name) "$family"
	set MV(font.balloon.$MV(font_max).normal) "-family \"$family\""
	set MV(font.balloon.$MV(font_max).bold) "-family \"$family\" -weight bold"
	set MV(font.balloon.$MV(font_max).italic) "-family \"$family\" -slant italic"
	set MV(font.balloon.$MV(font_max).bold_italic) "-family \"$family\" -slant italic -weight bold"
	incr MV(font_max)
}
incr MV(font_max) -1

# ------------------------------------------------------------------------
#                       Our default color scheme.
# ------------------------------------------------------------------------
# Colors of text in balloons.
set MV(color.0) "white"
set MV(color.1) "black"
set MV(color.2) "navy blue"
set MV(color.3) "dark green"
set MV(color.4) "red"
set MV(color.5) "brown"
set MV(color.6) "magenta"
set MV(color.7) "orange"
set MV(color.8) "yellow"
set MV(color.9) "green"
set MV(color.00) "white"
set MV(color.01) "black"
set MV(color.02) "navy blue"
set MV(color.03) "dark green"
set MV(color.04) "red"
set MV(color.05) "brown"
set MV(color.06) "magenta"
set MV(color.07) "orange"
set MV(color.08) "yellow"
set MV(color.09) "green"
set MV(color.10) "#00808"
set MV(color.11) "cyan"
set MV(color.12) "blue"
set MV(color.13) "hot pink"
set MV(color.14) "dark grey"
set MV(color.15) "light grey"
set MV(color.16) "white"
set MV(color.99) "black"
# Baloons.
set MV(colors.chat.baloon) "white"
set MV(colors.chat.text) "black"
set MV(colors.privmsg.baloon) "light blue"
set MV(colors.privmsg.text) "black"
set MV(colors.system.baloon) "white"
set MV(colors.system.text) "red"
set MV(colors.whois.baloon) "light green"
set MV(colors.whois.text) "black"

# ------------------------------------
# Main Window Buttons, entry points. (Button Mode)
# ------------------------------------
set MV(colors.buttons.quit.bg) "light blue"
set MV(colors.buttons.quit.fg) "black"
set MV(colors.buttons.quit.abg) "light blue"
set MV(colors.buttons.quit.afg) "red"
# ------------------------------------
set MV(colors.buttons.textchat.bg) "light blue"
set MV(colors.buttons.textchat.fg) "black"
set MV(colors.buttons.textchat.abg) "light blue"
set MV(colors.buttons.textchat.afg) "red"
# ------------------------------------
set MV(colors.buttons.help.bg) "light blue"
set MV(colors.buttons.help.fg) "black"
set MV(colors.buttons.help.abg) "light blue"
set MV(colors.buttons.help.afg) "red"
# ------------------------------------
set MV(colors.buttons.setup.bg) "light blue"
set MV(colors.buttons.setup.fg) "black"
set MV(colors.buttons.setup.abg) "light blue"
set MV(colors.buttons.setup.afg) "red"
# ------------------------------------
set MV(colors.buttons.passageways.bg) "light blue"
set MV(colors.buttons.passageways.fg) "black"
set MV(colors.buttons.passageways.abg) "light blue"
set MV(colors.buttons.passageways.afg) "red"
# ------------------------------------
set MV(colors.buttons.aved.bg) "light blue"
set MV(colors.buttons.aved.fg) "black"
set MV(colors.buttons.aved.abg) "light blue"
set MV(colors.buttons.aved.afg) "red"
# ------------------------------------
set MV(colors.buttons.animate.bg) "light blue"
set MV(colors.buttons.animate.fg) "black"
set MV(colors.buttons.animate.abg) "light blue"
set MV(colors.buttons.animate.afg) "red"
# ------------------------------------
set MV(colors.buttons.avatars.bg) "light blue"
set MV(colors.buttons.avatars.fg) "black"
set MV(colors.buttons.avatars.abg) "light blue"
set MV(colors.buttons.avatars.afg) "red"
# ------------------------------------
set MV(colors.buttons.sound.bg) "light blue"
set MV(colors.buttons.sound.fg) "black"
set MV(colors.buttons.sound.abg) "light blue"
set MV(colors.buttons.sound.afg) "red"
# ------------------------------------
set MV(colors.buttons.names.bg) "light blue"
set MV(colors.buttons.names.fg) "black"
set MV(colors.buttons.names.abg) "light blue"
set MV(colors.buttons.names.afg) "red"
# ------------------------------------
set MV(colors.buttons.names.chk.bg) "light blue"
set MV(colors.buttons.names.chk.fg) "black"
set MV(colors.buttons.names.chk.abg) "light blue"
set MV(colors.buttons.names.chk.afg) "red"
# ------------------------------------
set MV(colors.buttons.send.bg) "light blue"
set MV(colors.buttons.send.fg) "black"
set MV(colors.buttons.send.abg) "light blue"
set MV(colors.buttons.send.afg) "red"
# ------------------------------------
set MV(colors.buttons.connect.bg) "light blue"
set MV(colors.buttons.connect.fg) "black"
set MV(colors.buttons.connect.abg) "light blue"
set MV(colors.buttons.connect.afg) "red"
# ------------------------------------
# Main Window Entry Boxes
# ------------------------------------
set MV(colors.buttons.entry.bg) "light blue"
set MV(colors.buttons.entry.fg) "black"
# ------------------------------------
# Main Window Frames
# ------------------------------------
set MV(colors.frames.chat.bg) "light blue"
set MV(colors.frames.topbar.bg) "light blue"
set MV(colors.frames.canvas.bg) "light blue"
set MV(colors.frames.menu.bg) "light blue"
set MV(colors.frames.menu.bord.bg) "light blue"
set MV(colors.frames.menu.top.bg) "light blue"
set MV(colors.frames.menu.bot.bg) "light blue"
set MV(colors.frames.names.bg) "light blue"
# ------------------------------------
# Passageways Entries.
# ------------------------------------
set MV(colors.pw.bg) "light blue"
set MV(colors.pw.fg) "black"
set MV(colors.pw.abg) "light blue"
set MV(colors.pw.afg) "red"
# ------------------------------------
# Avatars Entries.
# ------------------------------------
set MV(colors.av.bg) "light blue"
set MV(colors.av.fg) "black"
set MV(colors.av.abg) "light blue"
set MV(colors.av.afg) "red"
# ------------------------------------
# Names Entries.
# ------------------------------------
set MV(colors.name.bg) "light blue"
set MV(colors.name.fg) "black"
set MV(colors.name.abg) "light blue"
set MV(colors.name.afg) "red"
# ------------------------------------
# URL Offer information Window.
# ------------------------------------
set MV(colors.url.frames.bg) "light blue"
set MV(colors.url.labels.fg) "black"
set MV(colors.url.labels.bg) "light blue"
set MV(colors.url.entries.fg) "light green"
set MV(colors.url.entries.bg) "black"
set MV(colors.url.buttons.bg) "light blue"
set MV(colors.url.buttons.abg) "light blue"
set MV(colors.url.buttons.fg) "black"
set MV(colors.url.buttons.afg) "red"
# ------------------------------------
# Download information Window.
# ------------------------------------
set MV(colors.dl.frames.bg) "light blue"
set MV(colors.dl.labels.bg) "light blue"
set MV(colors.dl.labels.fg) "black"
set MV(colors.dl.entries.bg) "black"
set MV(colors.dl.entries.fg) "light green"
set MV(colors.dl.buttons.bg) "light blue"
set MV(colors.dl.buttons.fg) "black"
set MV(colors.dl.buttons.abg) "light blue"
set MV(colors.dl.buttons.afg) "red"



#
# Build our download window array and set all items to 0ff
#
for {set c 0} {$c < 26} {incr c} {
	for {set s 1} {$s < 4} {incr s} {
		set MV(dls.$c.$s) 0;		# Status Window ID.
		set MV(dlcps.$c.$s) 0;		# CPS for this transfer.
		set MV(dlactive.$c.$s) 0;	# Is this download active?
	}
}
global tl
set tl(-1) 0


# ------------------------------------
# Personal Server Settings
# ------------------------------------
set MVS(serving) 0
set MVS(users) 0
