/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Random;
import java.util.Vector;

public class GDCanvas
extends Canvas
implements Runnable {
    Random dice = new Random(0L);
    GDViewer boss;
    Vector datavect;
    Image offscreen = null;
    Dimension offscreensize;
    Graphics offgraphics;
    Thread relaxer;
    int animetime = 200;
    FontMetrics fm;
    FontMetrics boldfm;
    Font font;
    Font boldfont;
    int charHeight;
    int charDescent;
    int charLeading;
    int charAscent;
    int lineHeight;
    int hgap = 3;
    int vgap = 3;
    double vmax = 20.0;
    double vminmax = 10.0;
    double hmax = 10.0;
    double hminmax = 10.0;
    double hmin = 0.1;
    double chismax = 10.0;
    int dwidth;
    int dheight;
    int inmargin = 20;
    int outmargin = 15;
    int markrad = 4;
    boolean centerflag = true;
    boolean drawArrowFlag = true;
    boolean blinkflag = true;
    boolean hiCurFlag = true;
    boolean snowflag = true;
    boolean rightflag;
    boolean leftflag;
    boolean upflag;
    boolean downflag;
    boolean[] arrowflag = new boolean[4];
    Polygon[] arrowpol = new Polygon[]{null, null, null, null};
    static final int A_UP = 0;
    static final int A_DOWN = 1;
    static final int A_RIGHT = 2;
    static final int A_LEFT = 3;
    int[] lcount = new int[32];
    int tracx;
    int tracy;

    public GDCanvas(GDViewer gDViewer) {
        this.boss = gDViewer;
        this.datavect = new Vector();
        this.setFont(10);
        this.initlcount();
        SymMouse symMouse = new SymMouse();
        this.addMouseListener(symMouse);
        SymComponent symComponent = new SymComponent();
        this.addComponentListener(symComponent);
    }

    private void initlcount() {
        int n = 0;
        while (n < this.lcount.length) {
            this.lcount[n] = 10 - (int)(this.dice.nextDouble() * 8.0);
            ++n;
        }
    }

    public void setAnimeTime(int n) {
        this.animetime = n;
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.relaxer.start();
        this.relaxer.setPriority(1);
    }

    public void stop() {
        if (this.relaxer != null) {
            this.relaxer.stop();
        }
    }

    public void suspend() {
        if (this.relaxer != null) {
            this.relaxer.suspend();
        }
    }

    public void resume() {
        if (this.relaxer != null) {
            this.relaxer.resume();
        }
    }

    public void run() {
        while (true) {
            this.repaint();
            try {
                Thread.sleep(this.animetime);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void setFont(int n) {
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        this.font = new Font(stringArray[1], 0, n);
        this.boldfont = new Font(stringArray[1], 1, n);
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.boldfm = Toolkit.getDefaultToolkit().getFontMetrics(this.boldfont);
        this.charHeight = this.fm.getHeight();
        this.charDescent = this.fm.getDescent();
        this.charAscent = this.fm.getAscent();
        this.charLeading = this.fm.getLeading();
        this.lineHeight = this.charHeight + 2 * this.vgap;
    }

    public void setCenterLineFlag(boolean bl) {
        this.centerflag = bl;
    }

    public void setDrawArrowFlag(boolean bl) {
        this.drawArrowFlag = bl;
    }

    public void setHiCurFlag(boolean bl) {
        this.hiCurFlag = bl;
    }

    public void setBlinkFlag(boolean bl) {
        this.blinkflag = bl;
    }

    public void setSnowFlag(boolean bl) {
        this.snowflag = bl;
    }

    public void setData(Vector vector) {
        this.datavect.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            ResultData resultData = (ResultData)vector.elementAt(n);
            int n2 = (int)(this.dice.nextDouble() * (double)SkyCanvas.maxCircleLevel);
            PlotData plotData = new PlotData(n2, SkyCanvas.maxCircleLevel, resultData);
            plotData.setColor(resultData.getColorName());
            this.datavect.addElement(plotData);
            ++n;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offscreensize = dimension;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.offgraphics.setColor(Color.black);
        this.offgraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.paintGrid(this.offgraphics);
        this.resetArrowFlag();
        this.paintData(this.offgraphics);
        if (this.drawArrowFlag) {
            this.paintArrow(this.offgraphics);
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    private void paintGrid(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        String string = DoubleFormat.toString(this.vmax, 1);
        int n5 = this.fm.stringWidth(string) + this.hgap * 2;
        if (this.inmargin < n5) {
            this.inmargin = n5;
        }
        if (this.inmargin < this.charHeight) {
            this.inmargin = this.charHeight + this.outmargin;
        }
        this.dwidth = this.getSize().width - this.inmargin - this.outmargin;
        this.dheight = this.getSize().height - this.inmargin - this.outmargin;
        Polygon polygon = new Polygon();
        Polygon polygon2 = new Polygon();
        double d = 2.0 + 1.5 * this.hmin;
        while (d < this.chismax) {
            double d2 = (d - 2.0) / 1.5;
            Point point = this.getConvPt(d2, d);
            polygon.addPoint(point.x, point.y);
            if (d > this.chismax / 2.0) {
                polygon2.addPoint(point.x, point.y);
            }
            d += 0.3;
        }
        Point point = this.getConvPt((this.chismax - 2.0) / 1.5, this.chismax);
        polygon.addPoint(point.x, point.y);
        polygon2.addPoint(point.x, point.y);
        point = this.getConvPt(this.hmax, this.chismax);
        polygon.addPoint(this.dwidth + this.inmargin + this.outmargin, point.y);
        point = this.getConvPt(this.hmax, 0.0);
        polygon.addPoint(this.dwidth + this.inmargin + this.outmargin, point.y);
        point = this.getConvPt(this.hmin, 0.0);
        polygon.addPoint(point.x, point.y);
        graphics.setColor(Color.blue);
        graphics.fillPolygon(polygon);
        if (this.snowflag) {
            graphics.setColor(Color.white);
            n4 = polygon2.xpoints[polygon2.npoints - 1];
            int n6 = this.dwidth + this.inmargin + this.outmargin;
            n3 = n4;
            while (n3 < n6) {
                double d3 = (double)(n6 - n3) / (double)(n6 - n4);
                n2 = this.lcount[n3 % this.lcount.length];
                int n7 = polygon2.npoints - 1;
                while (n7 > n2) {
                    graphics.drawLine(n6 - (int)((double)(n6 - polygon2.xpoints[n7]) * d3), polygon2.ypoints[n7], n6 - (int)((double)(n6 - polygon2.xpoints[n7 - 1]) * d3), polygon2.ypoints[n7 - 1]);
                    --n7;
                }
                ++n3;
            }
        }
        n4 = 3;
        graphics.setColor(Color.white);
        graphics.drawLine(this.inmargin, 0, this.inmargin, this.dheight + this.outmargin);
        int n8 = 1;
        while (n8 <= 4) {
            n3 = this.dheight / 4 * n8;
            graphics.drawLine(this.inmargin, this.dheight + this.outmargin - n3, this.inmargin + n4, this.dheight + this.outmargin - n3);
            String string2 = DoubleFormat.toString(this.vmax / 4.0 * (double)n8, 1);
            n = this.fm.stringWidth(string2);
            graphics.drawString(string2, this.inmargin - n - 2 * this.hgap, this.dheight + this.outmargin - n3 + this.charHeight / 2);
            ++n8;
        }
        graphics.drawString("Fit", this.inmargin + n4, this.charHeight);
        graphics.drawLine(this.inmargin, this.dheight + this.outmargin, this.dwidth + this.inmargin + this.outmargin, this.dheight + this.outmargin);
        double d4 = this.hmin;
        n = 0;
        while (n <= 2) {
            n2 = this.dwidth / 2 * n;
            graphics.drawLine(this.inmargin + n2, this.dheight + this.outmargin, this.inmargin + n2, this.dheight + this.outmargin - n4);
            String string3 = Double.toString(d4);
            int n9 = this.fm.stringWidth(string3);
            graphics.drawString(string3, this.inmargin + n2 - n9 / 2, this.dheight + this.outmargin + this.charHeight);
            d4 *= 10.0;
            ++n;
        }
        String string4 = "Power";
        graphics.drawString(string4, this.inmargin + this.dwidth - this.fm.stringWidth(string4), this.outmargin + this.dheight);
    }

    private void paintData(Graphics graphics) {
        int n = 0;
        while (n < this.datavect.size()) {
            PlotData plotData = (PlotData)this.datavect.elementAt(n);
            if (plotData.getBgChisq() != 0.0) {
                plotData.addLevel();
                if (plotData.getVisible()) {
                    Point point;
                    this.markrad = 4;
                    if (!plotData.getFinished() || plotData.getPt() == null) {
                        point = this.getConvPt(plotData);
                        plotData.setPt(point);
                    } else {
                        point = plotData.getPt();
                    }
                    if (this.setArrowFlag(point)) {
                        Object object;
                        if (!plotData.getFinished() && this.hiCurFlag) {
                            int n2 = 0;
                            while (n2 < plotData.getLevel()) {
                                int n3 = this.markrad + 2 + n2 * 3;
                                graphics.setColor(Color.cyan);
                                graphics.drawOval(point.x - n3 / 2, point.y - n3 / 2, n3, n3);
                                n2 += 2;
                            }
                            if (plotData.getTop()) {
                                graphics.setColor(Color.red);
                            } else {
                                graphics.setColor(Color.cyan);
                            }
                            graphics.fillOval(point.x - this.markrad / 2, point.y - this.markrad / 2, this.markrad, this.markrad);
                        } else {
                            if (plotData.getTop()) {
                                plotData.setColor("Red");
                            } else {
                                plotData.setColor("White");
                            }
                            object = plotData.getColor();
                            if (this.blinkflag) {
                                float[] fArray = new float[3];
                                fArray = Color.RGBtoHSB(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), fArray);
                                Color color = Color.getHSBColor(fArray[0], fArray[1], (float)(1.0 - (double)((float)plotData.getLevel() / (float)SkyCanvas.maxCircleLevel)));
                                graphics.setColor(color);
                            } else {
                                graphics.setColor((Color)object);
                            }
                            graphics.fill3DRect(point.x - this.markrad / 2, point.y - this.markrad / 2, this.markrad, this.markrad, true);
                        }
                        object = "(" + Double.toString(plotData.getBgPower()) + " , " + Double.toString(plotData.getBgChisq()) + ")";
                        if (plotData.getSelected() && this.centerflag) {
                            Point point2 = this.paintCrossLine(graphics, plotData, this.tracx, this.tracy);
                            this.tracx = point2.x;
                            this.tracy = point2.y;
                        }
                    }
                }
            }
            ++n;
        }
    }

    private Point getConvPt(PlotData plotData) {
        return this.getConvPt(plotData.getBgPower(), plotData.getBgChisq());
    }

    private Point getConvPt(double d, double d2) {
        int n = this.outmargin + (int)((1.0 - d2 / this.vmax) * (double)this.dheight);
        int n2 = this.inmargin + (int)((Math.log(d) - Math.log(this.hmin)) / (Math.log(this.hmax) - Math.log(this.hmin)) * (double)this.dwidth);
        return new Point(n2, n);
    }

    private boolean setArrowFlag(Point point) {
        boolean bl = true;
        if (point.x < 0) {
            bl = false;
        } else if (point.x > this.getSize().width) {
            bl = false;
            this.arrowflag[2] = true;
        }
        if (point.y < 0) {
            bl = false;
            this.arrowflag[0] = true;
        } else if (point.y > this.getSize().height) {
            bl = false;
        }
        if (this.vmax > this.vminmax) {
            this.arrowflag[1] = true;
        }
        if (this.hmax > this.hminmax) {
            this.arrowflag[3] = true;
        }
        return bl;
    }

    private void resetArrowFlag() {
        int n = 0;
        while (n < this.arrowflag.length) {
            this.arrowflag[n] = false;
            ++n;
        }
    }

    private void paintArrow(Graphics graphics) {
        int n = 0;
        while (n < this.arrowpol.length) {
            this.arrowpol[n] = null;
            ++n;
        }
        int n2 = 20;
        int n3 = 10;
        Dimension dimension = this.getSize();
        this.arrowpol[0] = new Polygon();
        this.arrowpol[0].addPoint(dimension.width / 2 - n2 / 2, n3);
        this.arrowpol[0].addPoint(dimension.width / 2, 0);
        this.arrowpol[0].addPoint(dimension.width / 2 + n2 / 2, n3);
        this.arrowpol[1] = new Polygon();
        this.arrowpol[1].addPoint(dimension.width / 2 - n2 / 2, n3 + this.vgap);
        this.arrowpol[1].addPoint(dimension.width / 2, n3 * 2 + this.vgap);
        this.arrowpol[1].addPoint(dimension.width / 2 + n2 / 2, n3 + this.vgap);
        this.arrowpol[2] = new Polygon();
        this.arrowpol[2].addPoint(dimension.width, dimension.height / 2);
        this.arrowpol[2].addPoint(dimension.width - n3, dimension.height / 2 - n2 / 2);
        this.arrowpol[2].addPoint(dimension.width - n3, dimension.height / 2 + n2 / 2);
        this.arrowpol[3] = new Polygon();
        this.arrowpol[3].addPoint(dimension.width - n3 * 2 - this.hgap, dimension.height / 2);
        this.arrowpol[3].addPoint(dimension.width - n3 - this.hgap, dimension.height / 2 - n2 / 2);
        this.arrowpol[3].addPoint(dimension.width - n3 - this.hgap, dimension.height / 2 + n2 / 2);
        graphics.setColor(Color.yellow);
        int n4 = 0;
        while (n4 < this.arrowpol.length) {
            if (this.arrowflag[n4]) {
                graphics.drawPolygon(this.arrowpol[n4]);
            }
            ++n4;
        }
    }

    private Point paintCrossLine(Graphics graphics, PlotData plotData, int n, int n2) {
        Point point = this.getConvPt(plotData);
        Dimension dimension = this.getSize();
        graphics.setColor(Color.pink);
        int n3 = this.markrad * 2;
        double d = 0.7;
        n = (int)((double)point.x * d + (double)n * (1.0 - d));
        n2 = (int)((double)point.y * d + (double)n2 * (1.0 - d));
        graphics.drawRect(n - (int)((double)n3 * 0.5), n2 - (int)((double)n3 * 0.5), n3, n3);
        graphics.drawLine(n, 0, n, n2 - (int)((double)n3 * 0.5));
        graphics.drawLine(n, dimension.height, n, n2 + (int)((double)n3 * 0.5));
        graphics.drawLine(0, n2, n - (int)((double)n3 * 0.5), n2);
        graphics.drawLine(dimension.width, n2, n + (int)((double)n3 * 0.5), n2);
        return new Point(n, n2);
    }

    private void clearPtData() {
        int n = 0;
        while (n < this.datavect.size()) {
            PlotData plotData = (PlotData)this.datavect.elementAt(n);
            plotData.setPt(null);
            ++n;
        }
    }

    void GDCanvas_MouseClicked(MouseEvent mouseEvent) {
        PlotData plotData;
        Point point = mouseEvent.getPoint();
        int n = this.markrad * 2;
        Rectangle rectangle = new Rectangle(point.x - n, point.y - n, n * 2, n * 2);
        Vector<PlotData> vector = new Vector<PlotData>();
        int n2 = 0;
        while (n2 < this.datavect.size()) {
            plotData = (PlotData)this.datavect.elementAt(n2);
            Point point2 = plotData.getPt();
            if (point2 != null && rectangle.contains(point2)) {
                vector.addElement(plotData);
            }
            ++n2;
        }
        plotData = null;
        if (vector.size() == 1) {
            plotData = (PlotData)vector.elementAt(0);
        } else {
            int n3 = n * 2 * (n * 2);
            int n4 = 0;
            while (n4 < vector.size()) {
                PlotData plotData2 = (PlotData)vector.elementAt(n4);
                if (!plotData2.getSelected()) {
                    Point point3 = this.getConvPt(plotData2);
                    int n5 = point.x - point3.x;
                    int n6 = point.y - point3.y;
                    int n7 = n5 * n5 + n6 * n6;
                    if (n7 < n3) {
                        n3 = n7;
                        plotData = plotData2;
                    }
                }
                ++n4;
            }
        }
        if (plotData != null) {
            this.boss.selectData(plotData.getOrgData());
        } else {
            this.clickForScroll(point);
        }
        this.boss.resetSleepThread();
    }

    private void clickForScroll(Point point) {
        int n = 0;
        while (n < this.arrowpol.length) {
            Polygon polygon = this.arrowpol[n];
            if (this.arrowflag[n] && polygon != null && polygon.contains(point)) {
                switch (n) {
                    case 0: {
                        this.vmax += 10.0;
                        break;
                    }
                    case 1: {
                        this.vmax -= 10.0;
                        if (!(this.vmax < this.vminmax)) break;
                        this.vmax = this.vminmax;
                        break;
                    }
                    case 2: {
                        this.hmax *= 10.0;
                        break;
                    }
                    case 3: {
                        this.hmax /= 10.0;
                        if (!(this.hmax < this.hminmax)) break;
                        this.hmax = this.hminmax;
                        break;
                    }
                }
                this.clearPtData();
                this.repaint();
                break;
            }
            ++n;
        }
    }

    void GDCanvas_ComponentResized(ComponentEvent componentEvent) {
        this.clearPtData();
    }

    class SymMouse
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == GDCanvas.this) {
                GDCanvas.this.GDCanvas_MouseClicked(mouseEvent);
            }
        }

        SymMouse() {
        }
    }

    class SymComponent
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == GDCanvas.this) {
                GDCanvas.this.GDCanvas_ComponentResized(componentEvent);
            }
        }

        SymComponent() {
        }
    }
}

