/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;

public class GDViewer
extends Frame {
    boolean fComponentsAdjusted = false;
    boolean startUpFlag = true;
    SETISupport boss;
    GDCanvas maincanvas;
    GDPrefValue pref = FileAnalyzer.readGDPrefs();
    MenuBar mainMenuBar;
    Menu menu1;
    Menu menu2;
    MenuItem miExit;
    CheckboxMenuItem miCrossLine;
    CheckboxMenuItem miArrow;
    CheckboxMenuItem miHiCur;
    CheckboxMenuItem miBlink;
    CheckboxMenuItem miSnow;

    public GDViewer(SETISupport sETISupport) {
        this.boss = sETISupport;
        this.initLayout();
        this.setData();
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymComponent symComponent = new SymComponent();
        this.addComponentListener(symComponent);
    }

    public void setData() {
        Vector vector = new Vector();
        this.boss.setMxData(vector);
        this.maincanvas.setData(vector);
    }

    public void initLayout() {
        this.setTitle("SETI@Support Gaussian Distribution");
        Rectangle rectangle = this.pref.getBound();
        int n = rectangle.width;
        int n2 = rectangle.height;
        ((Component)this).setLocation(rectangle.x, rectangle.y);
        this.setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        ((Component)this).setSize(n, n2);
        this.maincanvas = new GDCanvas(this);
        this.maincanvas.start();
        this.add("Center", this.maincanvas);
        this.mainMenuBar = new MenuBar();
        this.menu1 = new Menu("File");
        this.miExit = new MenuItem("Close");
        this.menu1.add(this.miExit);
        this.menu2 = new Menu("Setting");
        boolean bl = this.pref.getClPref() != 0;
        this.miCrossLine = new CheckboxMenuItem("Cross Line", bl);
        this.miCrossLineAction(bl);
        this.menu2.add(this.miCrossLine);
        bl = this.pref.getArPref() != 0;
        this.miArrow = new CheckboxMenuItem("Arrow", bl);
        this.miArrowAction(bl);
        this.menu2.add(this.miArrow);
        bl = this.pref.getHiCurPref() != 0;
        this.miHiCur = new CheckboxMenuItem("Highlight analyzing data", bl);
        this.miHiCurAction(bl);
        this.menu2.add(this.miHiCur);
        bl = this.pref.getBlinkPref() != 0;
        this.miBlink = new CheckboxMenuItem("Blink", bl);
        this.miBlinkAction(bl);
        this.menu2.add(this.miBlink);
        bl = this.pref.getSnowPref() != 0;
        this.miSnow = new CheckboxMenuItem("View", bl);
        this.miSnowAction(bl);
        if (new File("goro").exists()) {
            this.menu2.add(this.miSnow);
        }
        this.mainMenuBar.add(this.menu1);
        this.mainMenuBar.add(this.menu2);
        this.setMenuBar(this.mainMenuBar);
        SymAction symAction = new SymAction();
        this.miExit.addActionListener(symAction);
        SymItem symItem = new SymItem();
        this.miCrossLine.addItemListener(symItem);
        this.miArrow.addItemListener(symItem);
        this.miHiCur.addItemListener(symItem);
        this.miBlink.addItemListener(symItem);
        this.miSnow.addItemListener(symItem);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + dimension.width, this.getInsets().top + this.getInsets().bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(this.getInsets().left, this.getInsets().top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.fComponentsAdjusted = true;
    }

    public void setBoundPref(Rectangle rectangle) {
        this.pref.setBound(rectangle);
    }

    private void fileOutPref() {
        FileAnalyzer.fileOutGDPrefs(this.pref);
    }

    public void setAnimeTime(int n) {
        this.maincanvas.setAnimeTime(n);
    }

    public void resetSleepThread() {
        this.boss.resetSleepThread();
    }

    void miExit_Action(ActionEvent actionEvent) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
    }

    private void miCrossLineAction(boolean bl) {
        this.maincanvas.setCenterLineFlag(bl);
    }

    private void miArrowAction(boolean bl) {
        this.maincanvas.setDrawArrowFlag(bl);
    }

    private void miHiCurAction(boolean bl) {
        this.maincanvas.setHiCurFlag(bl);
    }

    private void miBlinkAction(boolean bl) {
        this.maincanvas.setBlinkFlag(bl);
    }

    private void miSnowAction(boolean bl) {
        this.maincanvas.setSnowFlag(bl);
    }

    void GDViewer_WindowClosing(WindowEvent windowEvent) {
        this.setBoundPref(this.getBounds());
        this.fileOutPref();
        this.setVisible(false);
        this.dispose();
        this.boss.clearGdx();
    }

    public void update() {
        this.maincanvas.repaint();
    }

    void GDViewer_WindowOpened(WindowEvent windowEvent) {
    }

    void GDViewer_WindowActivated(WindowEvent windowEvent) {
        this.resetSleepThread();
    }

    void GDViewer_WindowDeactivated(WindowEvent windowEvent) {
        this.boss.SETISupport_WindowDeactivated(null);
    }

    void GDViewer_ComponentMoved(ComponentEvent componentEvent) {
    }

    void GDViewer_ComponentShown(ComponentEvent componentEvent) {
        if (this.startUpFlag) {
            this.startUpFlag = false;
            Rectangle rectangle = this.pref.getBound();
            if (rectangle.width != 0 && rectangle.height != 0) {
                ((Component)this).setSize(new Dimension(rectangle.width, rectangle.height));
                ((Component)this).setLocation(rectangle.x, rectangle.y);
            } else {
                ((Component)this).setSize(new Dimension(400, 400));
                ((Component)this).setLocation(50, 50);
            }
        }
    }

    public void selectData(ResultData resultData) {
        this.boss.selectFromOutside(resultData, true);
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == GDViewer.this.miExit) {
                GDViewer.this.GDViewer_WindowClosing(null);
            }
        }

        SymAction() {
        }
    }

    class SymItem
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == GDViewer.this.miCrossLine) {
                if (GDViewer.this.miCrossLine.getState()) {
                    GDViewer.this.pref.setClPref(1);
                } else {
                    GDViewer.this.pref.setClPref(0);
                }
                GDViewer.this.miCrossLineAction(GDViewer.this.miCrossLine.getState());
            } else if (object == GDViewer.this.miArrow) {
                if (GDViewer.this.miArrow.getState()) {
                    GDViewer.this.pref.setArPref(1);
                } else {
                    GDViewer.this.pref.setArPref(0);
                }
                GDViewer.this.miArrowAction(GDViewer.this.miArrow.getState());
            } else if (object == GDViewer.this.miHiCur) {
                if (GDViewer.this.miHiCur.getState()) {
                    GDViewer.this.pref.setHiCurPref(1);
                } else {
                    GDViewer.this.pref.setHiCurPref(0);
                }
                GDViewer.this.miHiCurAction(GDViewer.this.miHiCur.getState());
            } else if (object == GDViewer.this.miBlink) {
                if (GDViewer.this.miBlink.getState()) {
                    GDViewer.this.pref.setBlinkPref(1);
                } else {
                    GDViewer.this.pref.setBlinkPref(0);
                }
                GDViewer.this.miBlinkAction(GDViewer.this.miBlink.getState());
            } else if (object == GDViewer.this.miSnow) {
                if (GDViewer.this.miSnow.getState()) {
                    GDViewer.this.pref.setSnowPref(1);
                } else {
                    GDViewer.this.pref.setSnowPref(0);
                }
                GDViewer.this.miSnowAction(GDViewer.this.miSnow.getState());
            }
            GDViewer.this.fileOutPref();
        }

        SymItem() {
        }
    }

    class SymWindow
    extends WindowAdapter {
        public void windowDeactivated(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_WindowDeactivated(windowEvent);
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_WindowActivated(windowEvent);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_WindowClosing(windowEvent);
            }
        }

        public void windowOpened(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_WindowOpened(windowEvent);
            }
        }

        SymWindow() {
        }
    }

    class SymComponent
    extends ComponentAdapter {
        public void componentShown(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_ComponentShown(componentEvent);
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_ComponentMoved(componentEvent);
            }
        }

        SymComponent() {
        }
    }
}

