#! /bin/sh
# the next line restarts using wish8.0 \
exec wish8.0 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /home/ioi/ws/ide1.0/SpecTcl/pref_editor.ui
#   root     is the parent window for this user interface

proc pref_editor_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	checkbutton $base.checkbutton#1 \
		-text {Use an external editor} \
		-variable p(use-external-editor)
	catch {
		$base.checkbutton#1 configure \
			-font -*-Helvetica-Bold-R-Normal-*-*-120-*-*-*-*-*-*
	}

	entry $base.entry#1 \
		-textvariable p(external-editor-command)
	catch {
		$base.entry#1 configure \
			-font -*-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-*
	}

	label $base.explainer \
		-justify left


	# Geometry management

	grid $base.checkbutton#1 -in $root	-row 2 -column 2  \
		-columnspan 2 \
		-sticky w
	grid $base.entry#1 -in $root	-row 3 -column 3  \
		-sticky ew
	grid $base.explainer -in $root	-row 4 -column 2  \
		-columnspan 2 \
		-sticky nesw

	# Resize behavior management

	grid rowconfigure $root 1 -weight 0 -minsize 5
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 0 -minsize 30
	grid rowconfigure $root 4 -weight 0 -minsize 30
	grid rowconfigure $root 5 -weight 1 -minsize 5
	grid columnconfigure $root 1 -weight 0 -minsize 5
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30
	grid columnconfigure $root 4 -weight 0 -minsize 5
# additional interface code
global tcl_platform
if {$tcl_platform(platform) == "windows"} {
    $base.explainer config -text "Under Windows, you must either
use forward slashes '/' to divide
the path, or use four 
backslashes '\' for each path.
Environment variables EDITOR and VISUAL
are respected.
Examples:
c:/windows/notepad.exe
c:\\\\windows\\\\notepad.exe"
} elseif {$tcl_platform(platform) == "unix"} {
    $base.explainer config -text "If the external editor box is
checked, but no command is given,
the EDITOR and VISUAL environment 
are used to figure out what command
to use, in that order."
} else {
    $base.explainer config -text "This doesn't work on this platform
yet, sorry."
}
# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	pref_editor_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing pref_editor_ui"
	    pref_editor_ui .
	}
    }
}
