/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3v2Footer {
    private final String TAG_START;
    private final int FOOT_SIZE;
    private final int NEW_MAJOR_VERSION;
    private final int NEW_MINOR_VERSION;
    private File mp3;
    private boolean footerExists;
    private int majorVersion;
    private int minorVersion;
    private boolean unsynchronisation;
    private boolean extended;
    private boolean experimental;
    private boolean footer;
    private int tagSize;

    private final boolean checkFooter(RandomAccessFile randomAccessFile, int n) throws FileNotFoundException, IOException {
        boolean bl = false;
        randomAccessFile.seek(n);
        byte[] byArray = new byte[10];
        if (randomAccessFile.read(byArray) != 10) {
            throw new IOException("Error encountered finding id3v2 footer");
        }
        String string = new String(byArray);
        if (string.substring(0, "3DI".length()).equals("3DI") && byArray[3] < 255 && byArray[4] < 255 && byArray[6] < 128 && byArray[7] < 128 && byArray[8] < 128 && byArray[9] < 128) {
            bl = true;
        }
        return bl;
    }

    private final void readFooter(RandomAccessFile randomAccessFile, int n) throws FileNotFoundException, IOException {
        randomAccessFile.seek(n);
        byte[] byArray = new byte[10];
        if (randomAccessFile.read(byArray) != 10) {
            throw new IOException("Error encountered reading id3v2 footer");
        }
        this.majorVersion = byArray[3];
        if (this.majorVersion <= 3) {
            this.minorVersion = byArray[4];
            this.unsynchronisation = BinaryParser.bitSet(byArray[5], 7);
            this.extended = BinaryParser.bitSet(byArray[5], 6);
            this.experimental = BinaryParser.bitSet(byArray[5], 5);
            this.footer = BinaryParser.bitSet(byArray[5], 4);
            byte[] byArray2 = new byte[]{byArray[6], byArray[7], byArray[8], byArray[9]};
            this.tagSize = BinaryParser.convertToSynchsafeInt(byArray2);
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[10];
        int n = 0;
        System.arraycopy("3DI".getBytes(), 0, byArray, n, "3DI".length());
        n += "3DI".length();
        byArray[n++] = (byte)this.majorVersion;
        byArray[n++] = (byte)this.minorVersion;
        byArray[n++] = this.getFlagByte();
        System.arraycopy(BinaryParser.convertToSynchsafeBytes(this.tagSize), 0, byArray, n, 4);
        n += 4;
        return byArray;
    }

    private final byte getFlagByte() {
        byte by = 0;
        if (this.unsynchronisation) {
            by = BinaryParser.setBit(by, 7);
        }
        if (this.extended) {
            by = BinaryParser.setBit(by, 6);
        }
        if (this.experimental) {
            by = BinaryParser.setBit(by, 5);
        }
        if (this.footer) {
            by = BinaryParser.setBit(by, 4);
        }
        return by;
    }

    public boolean footerExists() {
        return this.footerExists;
    }

    public int getFooterSize() {
        return 10;
    }

    public int getTagSize() {
        return this.tagSize;
    }

    public void setTagSize(int n) {
        if (n > 0) {
            this.tagSize = n;
            this.footerExists = true;
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean getUnsynchronisation() {
        return this.unsynchronisation;
    }

    public void setUnsynchronisation(boolean bl) {
        this.unsynchronisation = bl;
    }

    public boolean getExtendedFooter() {
        return this.extended;
    }

    public void setExtendedFooter(boolean bl) {
        this.extended = bl;
    }

    public boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(boolean bl) {
        this.experimental = bl;
    }

    public boolean getFooter() {
        return this.footer;
    }

    public void setFooter(boolean bl) {
        this.footer = bl;
    }

    public String toString() {
        return "ID3v2." + this.getMajorVersion() + "." + this.getMinorVersion() + "\n" + "TagSize:\t\t\t" + this.getTagSize() + " bytes\nUnsynchronisation:\t\t" + this.getUnsynchronisation() + "\nExtended Footer:\t\t" + this.getExtendedFooter() + "\nExperimental:\t\t\t" + this.getExperimental() + "\nFooter:\t\t\t\t" + this.getFooter();
    }

    public ID3v2Footer(File file, int n) throws FileNotFoundException, IOException {
        RandomAccessFile randomAccessFile;
        block4: {
            this.TAG_START = "3DI";
            this.FOOT_SIZE = 10;
            this.NEW_MAJOR_VERSION = 3;
            this.NEW_MINOR_VERSION = 0;
            this.mp3 = null;
            this.mp3 = file;
            this.majorVersion = 3;
            this.minorVersion = 0;
            this.unsynchronisation = false;
            this.extended = false;
            this.experimental = false;
            this.footer = false;
            this.tagSize = 0;
            randomAccessFile = null;
            try {
                this.footerExists = this.checkFooter(randomAccessFile, n);
                if (!this.footerExists) break block4;
                this.readFooter(randomAccessFile, n);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                throw throwable;
            }
        }
        Object var5_4 = null;
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
    }
}

