/*
 * Decompiled with CFR 0.152.
 */
package xnap.cmdl;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import org.gnu.readline.Readline;
import org.gnu.readline.ReadlineLibrary;
import xnap.cmdl.Completer;
import xnap.cmdl.IConsole;
import xnap.cmdl.ReadlineCompleter;
import xnap.util.FileHelper;

public class ReadlineConsole
implements IConsole {
    private File history = new File(FileHelper.getHomeDir() + "history");

    public boolean isEchoing() {
        return true;
    }

    public String readLine(String string) {
        try {
            String string2 = Readline.readline(string);
            return string2 == null ? "" : string2;
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void printLine(String string) {
        System.out.print(string);
    }

    public void saveSettings() {
        try {
            Readline.writeHistoryFile(this.history.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Completer getCompleter() {
        return (ReadlineCompleter)Readline.getCompleter();
    }

    public ReadlineConsole() {
        try {
            Readline.load(ReadlineLibrary.GnuReadline);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                Readline.load(ReadlineLibrary.Editline);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                // empty catch block
            }
        }
        try {
            Readline.initReadline("XNap");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Ooops, your Java-Readline Library seems broken. Using pure java.");
            Readline.load(ReadlineLibrary.PureJava);
            Readline.initReadline("XNap");
        }
        Readline.initReadline("XNap");
        Readline.setCompleter(new ReadlineCompleter());
        try {
            if (this.history.exists()) {
                Readline.readHistoryFile(this.history.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

