/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import xnap.XNap;
import xnap.gui.DefaultDialog;
import xnap.gui.GridBagHelper;
import xnap.io.ResumeFile3;
import xnap.io.ResumeRepository;
import xnap.net.AutoDownload;
import xnap.util.SearchFilter;
import xnap.util.SearchFilterData;
import xnap.util.SearchFilterHelper;

public class AutoDownloadEditorDialog
extends DefaultDialog {
    private AutoDownload download;
    private JTextField jtFilename;
    private JTextField jtSearchText;
    private JComboBox jcbMediaType;
    private JComboBox jcbBitrateCompare;
    private JComboBox jcbBitrate;

    private final void initialize(ResumeFile3 resumeFile3) {
        this.setTitle(XNap.tr("Edit search filter"));
        this.setModal(true);
        JPanel jPanel = this.getMainPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagHelper.addLabel(jPanel, XNap.tr("Final Filename"));
        this.jtFilename = new JTextField(resumeFile3.getFinalFilename());
        GridBagHelper.add((Container)jPanel, this.jtFilename);
        SearchFilterData searchFilterData = resumeFile3.getFilterData();
        GridBagHelper.addLabel(jPanel, XNap.tr("Search Text"));
        this.jtSearchText = new JTextField(searchFilterData.searchText);
        GridBagHelper.add((Container)jPanel, this.jtSearchText);
        GridBagHelper.addLabel(jPanel, XNap.tr("Media Type"));
        this.jcbMediaType = new JComboBox<Object>(SearchFilter.media);
        this.jcbMediaType.addActionListener(new MediaTypeSelectionListener());
        GridBagHelper.add((Container)jPanel, this.jcbMediaType);
        GridBagHelper.addLabel(jPanel, XNap.tr("Bitrate"));
        this.jcbBitrateCompare = new JComboBox<Object>(SearchFilter.COMPARES);
        this.jcbBitrateCompare.setSelectedIndex(searchFilterData.bitrateCompare);
        this.jcbBitrate = new JComboBox<Object>(SearchFilter.BITRATES);
        int n = SearchFilterHelper.getIndexFromBitrate(searchFilterData.bitrate);
        this.jcbBitrate.setSelectedIndex(n);
        this.jcbMediaType.setSelectedIndex(searchFilterData.mediaType);
        Box box = Box.createHorizontalBox();
        box.add(this.jcbBitrateCompare);
        box.add(Box.createGlue());
        box.add(this.jcbBitrate);
        GridBagHelper.add((Container)jPanel, box);
        this.pack();
    }

    public static void showDialog(Component component, AutoDownload autoDownload) {
        AutoDownloadEditorDialog autoDownloadEditorDialog = new AutoDownloadEditorDialog(autoDownload);
        if (component != null) {
            autoDownloadEditorDialog.setLocationRelativeTo(component);
        }
        autoDownloadEditorDialog.show();
    }

    public void apply() {
        ResumeFile3 resumeFile3 = this.download.getResumeFile();
        resumeFile3.setFinalFilename(this.jtFilename.getText());
        resumeFile3.getFilterData().searchText = this.jtSearchText.getText();
        resumeFile3.getFilterData().mediaType = this.jcbMediaType.getSelectedIndex();
        if (this.jcbBitrateCompare.isEnabled()) {
            resumeFile3.getFilterData().bitrateCompare = this.jcbBitrateCompare.getSelectedIndex();
            int n = this.jcbBitrate.getSelectedIndex();
            resumeFile3.getFilterData().bitrate = SearchFilter.getBitrateFromIndex(n);
        }
        this.download.updatedSearchFilter();
        ResumeRepository.getInstance().updateLater();
    }

    private AutoDownloadEditorDialog(AutoDownload autoDownload) {
        this.download = autoDownload;
        this.initialize(autoDownload.getResumeFile());
    }

    private class MediaTypeSelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = AutoDownloadEditorDialog.this.jcbMediaType.getSelectedIndex();
            if (n == 0 || n == 1) {
                AutoDownloadEditorDialog.this.jcbBitrateCompare.setEnabled(true);
                AutoDownloadEditorDialog.this.jcbBitrate.setEnabled(true);
            } else {
                AutoDownloadEditorDialog.this.jcbBitrateCompare.setEnabled(false);
                AutoDownloadEditorDialog.this.jcbBitrate.setEnabled(false);
            }
        }

        MediaTypeSelectionListener() {
        }
    }
}

