/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import xnap.XNap;
import xnap.gui.Dialogs;
import xnap.gui.text.EmacsKeyBindings;
import xnap.net.IChannel;
import xnap.util.Notifier;
import xnap.util.Preferences;
import xnap.util.Updater;
import xnap.util.event.ChatListener;
import xnap.util.event.StatusListener;

public class GUINotifier
extends Notifier
implements PropertyChangeListener {
    protected ChatListener chatListener;
    protected Object chatListenerLock = new Object();
    protected StatusListener listener;
    protected Object listenerLock = new Object();
    protected boolean guiVisible = false;
    protected Object guiVisibleLock = new Object();
    protected Preferences prefs = Preferences.getInstance();
    private Component mainComponent;
    private boolean canPurge = true;
    private static /* synthetic */ Class class$Lxnap$gui$GUINotifier;

    public static Notifier getInstance() {
        if (Notifier.singleton == null) {
            Class clazz = class$Lxnap$gui$GUINotifier != null ? class$Lxnap$gui$GUINotifier : (class$Lxnap$gui$GUINotifier = GUINotifier.class$("xnap.gui.GUINotifier"));
            synchronized (clazz) {
                if (Notifier.singleton == null) {
                    Notifier.singleton = new GUINotifier();
                }
            }
        }
        return Notifier.singleton;
    }

    public static GUINotifier getGUIInstance() {
        return (GUINotifier)GUINotifier.getInstance();
    }

    public void setChatListener(ChatListener chatListener) {
        Object object = this.chatListenerLock;
        synchronized (object) {
            this.chatListener = chatListener;
        }
    }

    public void channelAdded(IChannel iChannel) {
        Object object = this.chatListenerLock;
        synchronized (object) {
            if (this.chatListener != null) {
                this.chatListener.channelAdded(iChannel);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canPurgeResumeRepository() {
        Runnable runnable = new Runnable(this){
            private final /* synthetic */ GUINotifier this$0;

            public final void run() {
                GUINotifier.access$2(this.this$0, JOptionPane.showConfirmDialog(GUINotifier.access$1(this.this$0), XNap.tr("The resume repository format has changed.\nPress Yes to save your repository. Then quit\nand launch the previous XNap version to resume\nyour downloads.\nIf you hit No, your resumes will be lost."), XNap.tr("Keep Resume Repository"), 0, 3) == 1);
            }
            {
                this.this$0 = gUINotifier;
                this.constructor$0(gUINotifier);
            }

            private final void constructor$0(GUINotifier gUINotifier) {
            }
        };
        Object object = this.guiVisibleLock;
        synchronized (object) {
            while (!this.guiVisible) {
                try {
                    this.guiVisibleLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
            return this.canPurge;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.canPurge;
    }

    public void setGUIVisible(Component component, boolean bl) {
        this.mainComponent = component;
        if (Updater.hasMacOSXModalDialogBug()) {
            Dialogs.showNotification(this.mainComponent, "MacOSXModalDialogBug", XNap.tr("Mac OS Java Bug"), XNap.tr("Your operating system might have a bug that affects modal dialogs. If any dialogs come up blank, please update to Mac OS X 10.2 (Jaguar)"));
        }
        if (Updater.hasMacOSXToolTipsBug() && !this.prefs.getShowToolTips()) {
            Dialogs.showNotification(this.mainComponent, "MacOSXModalTooltipsBug", XNap.tr("Mac OS Java Bug"), XNap.tr("Your operating system might have a bug that causes freezes when showing tooltips. Therefore tooltips have been disabled. You can reenable them in the preferences dialog."));
        }
        if (Updater.isMacOSX()) {
            Dialogs.showNotification(this.mainComponent, "MacOSXApplicationMenu", XNap.tr("Mac OS"), XNap.tr("Please do not exit XNap through the Mac OS application menu. XNap will not be able to cleanly shutdown if you do. Please use the Exit item in the File menu instead."));
        }
        if (this.prefs.getOldVersion() >= 0 && this.prefs.getOldVersion() < 8) {
            Dialogs.showFullPathSharing(this.mainComponent);
        }
        Object object = this.guiVisibleLock;
        synchronized (object) {
            this.guiVisible = true;
            this.guiVisibleLock.notifyAll();
        }
    }

    public void setStatus(String string) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listener != null) {
                this.listener.setStatus(string);
            }
        }
    }

    public void setStatusListener(StatusListener statusListener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listener = statusListener;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("useEmacsKeyBindings")) {
            this.updateEmacsKeyBindings();
        } else if (string.equals("showToolTips")) {
            this.updateToolTips();
        }
    }

    private final void updateEmacsKeyBindings() {
        if (this.prefs.getUseEmacsKeyBindings()) {
            EmacsKeyBindings.loadEmacsKeyBindings();
        }
    }

    private final void updateToolTips() {
        ToolTipManager.sharedInstance().setEnabled(this.prefs.getShowToolTips());
    }

    static /* synthetic */ boolean access$0(GUINotifier gUINotifier) {
        return gUINotifier.canPurge;
    }

    static /* synthetic */ Component access$1(GUINotifier gUINotifier) {
        return gUINotifier.mainComponent;
    }

    static /* synthetic */ void access$2(GUINotifier gUINotifier, boolean bl) {
        gUINotifier.canPurge = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected GUINotifier() {
        this.updateEmacsKeyBindings();
        this.updateToolTips();
        this.prefs.addPropertyChangeListener(this);
    }
}

