/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import xnap.XNap;
import xnap.gui.AbstractPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.UserEditorPanel;
import xnap.gui.XNapFrame;
import xnap.gui.event.PopupListener;
import xnap.gui.event.UserSupport;
import xnap.gui.menu.UserMenu;
import xnap.gui.table.HotlistTableModel;
import xnap.net.IUser;
import xnap.user.UserManager;

public class HotlistPanel
extends AbstractPanel
implements ActionListener,
ListSelectionListener,
UserSupport {
    private JTable jtaHotlist;
    private HotlistTableModel htm;
    private JSplitPane jsp;
    private JComboBox jcbFilter;
    private JScrollPane jspRight;
    private JPanel jpUserEditor;
    private UserEditorPanel uep;
    private RemoveAction acRemove = new RemoveAction();

    private final void initialize() {
        JPanel jPanel = new JPanel(new BorderLayout());
        UserMenu userMenu = new UserMenu(this, true);
        userMenu.add(new JMenuItem(this.acRemove));
        userMenu.addSeparator();
        this.htm = new HotlistTableModel();
        this.jtaHotlist = this.htm.createJTable();
        this.jtaHotlist.addMouseListener(new PopupListener(userMenu));
        this.jtaHotlist.getSelectionModel().addListSelectionListener(this);
        this.jtaHotlist.setShowGrid(false);
        jPanel.add((Component)new JScrollPane(this.jtaHotlist), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add(new JLabel(XNap.tr("Show")));
        jPanel2.add(Box.createHorizontalStrut(5));
        Object[] objectArray = this.getFilters();
        this.jcbFilter = new JComboBox<Object>(objectArray);
        this.jcbFilter.addActionListener(this);
        jPanel2.add(this.jcbFilter);
        this.jspRight = new JScrollPane();
        this.uep = new UserEditorPanel();
        this.jpUserEditor = new JPanel(new GridBagLayout());
        GridBagHelper.add((Container)this.jpUserEditor, this.uep);
        GridBagHelper.add(this.jpUserEditor, new JButton(new ApplyAction()), GridBagHelper.COMPONENT_INSETS, false, 12);
        GridBagHelper.addVerticalSpacer(this.jpUserEditor);
        this.jsp = new JSplitPane(1);
        this.jsp.add((Component)jPanel, "left");
        this.jsp.add((Component)this.jspRight, "right");
        this.jsp.setDividerLocation(AbstractPanel.prefs.getHotlistDividerLocation());
        this.jsp.setResizeWeight(0.0);
        this.jsp.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jsp, "Center");
        this.htm.setFilter((HotlistTableModel.UserFilter)this.jcbFilter.getSelectedItem());
    }

    public void savePrefs() {
        AbstractPanel.prefs.setHotlistDividerLocation(this.jsp.getDividerLocation());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.htm.setFilter((HotlistTableModel.UserFilter)this.jcbFilter.getSelectedItem());
    }

    public AbstractAction[] getActions() {
        return new AbstractAction[]{this.acRemove};
    }

    public Object[] getFilters() {
        HotlistTableModel.CategoryFilter categoryFilter = new HotlistTableModel.CategoryFilter(XNap.tr("Hotlist"));
        HotlistTableModel.CategoryFilter categoryFilter2 = new HotlistTableModel.CategoryFilter(XNap.tr("Banned"));
        HotlistTableModel.UserFilter[] userFilterArray = new HotlistTableModel.UserFilter[]{categoryFilter, categoryFilter2};
        return new Object[]{categoryFilter, categoryFilter2, new HotlistTableModel.OtherFilter(userFilterArray), new HotlistTableModel.AllFilter()};
    }

    public IUser[] getUsers() {
        int[] nArray = this.jtaHotlist.getSelectedRows();
        IUser[] iUserArray = new IUser[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            iUserArray[n] = this.htm.get(nArray[n]);
            ++n;
        }
        return iUserArray;
    }

    public void reload() {
        this.jspRight.setViewportView(null);
        this.htm.reload();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (this.jspRight.getViewport().getView() == this.jpUserEditor && this.uep.hasChanged()) {
            Object[] objectArray = new Object[]{XNap.tr("The settings have been changed."), XNap.tr("Do you want to save your changes?")};
            int n2 = JOptionPane.showConfirmDialog(this, objectArray, XNap.tr("Edit User"), 0);
            if (n2 == 0) {
                this.uep.apply();
            } else if (n2 == 2) {
                return;
            }
        }
        if ((n = this.jtaHotlist.getSelectedRow()) == -1 || this.jtaHotlist.getSelectedRowCount() != 1) {
            this.jspRight.setViewportView(null);
        } else {
            this.uep.setUser(this.htm.get(n));
            this.jspRight.setViewportView(this.jpUserEditor);
        }
    }

    public HotlistPanel() {
        this.initialize();
    }

    private class RemoveAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            IUser[] iUserArray = HotlistPanel.this.getUsers();
            int n = 0;
            while (n < iUserArray.length) {
                UserManager.reset(iUserArray[n]);
                ++n;
            }
            HotlistPanel.this.reload();
        }

        public RemoveAction() {
            this.putValue("Name", XNap.tr("Remove"));
            this.putValue("ShortDescription", XNap.tr("Remove user(s) from hotlist"));
            this.putValue("SmallIcon", XNapFrame.getIcon("eraser.png"));
            this.putValue("MnemonicKey", new Integer(82));
        }
    }

    private class UpdateAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            HotlistPanel.this.reload();
        }

        public UpdateAction() {
            this.putValue("Name", XNap.tr("Update"));
            this.putValue("ShortDescription", XNap.tr("updatedescr"));
            this.putValue("SmallIcon", XNapFrame.getIcon("reload.png"));
            this.putValue("MnemonicKey", new Integer(85));
        }
    }

    private class ApplyAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            IUser iUser = HotlistPanel.this.uep.getUser();
            HotlistPanel.this.uep.apply();
            HotlistPanel.this.reload();
            int n = HotlistPanel.this.htm.indexOf(iUser);
            if (n != -1) {
                HotlistPanel.this.jtaHotlist.setRowSelectionInterval(n, n);
            }
        }

        public ApplyAction() {
            this.putValue("Name", XNap.tr("Apply"));
            this.putValue("ShortDescription", XNap.tr("Applies changes."));
        }
    }
}

