/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractSortableTableModel
extends AbstractTableModel {
    protected int[] indexes = new int[0];
    protected int[] revIndexes = new int[0];
    protected Vector sortingColumns = new Vector();
    protected boolean ascending = true;
    protected int compares;
    protected int lastSortedColumn = -1;
    protected boolean maintainSortOrder;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes(tableModelEvent);
        if (this.maintainSortOrder && this.sort()) {
            return;
        }
        if (tableModelEvent.getType() == -1 || tableModelEvent.getType() == 0 && tableModelEvent.getLastRow() >= this.revIndexes.length) {
            super.fireTableChanged(new TableModelEvent(this));
        } else {
            int n = tableModelEvent.getFirstRow();
            while (n <= tableModelEvent.getLastRow()) {
                TableModelEvent tableModelEvent2 = new TableModelEvent(this, this.revIndexes[n], this.revIndexes[n], tableModelEvent.getColumn(), tableModelEvent.getType());
                super.fireTableChanged(tableModelEvent2);
                ++n;
            }
        }
    }

    public abstract Object get(int var1, int var2);

    public int getLastSortedColumn() {
        return this.lastSortedColumn;
    }

    public Object getValueAt(int n, int n2) {
        int[] nArray = this.indexes;
        synchronized (this.indexes) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.get(this.indexes[n], n2);
        }
    }

    public boolean isSortedAscending() {
        return this.ascending;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int mapToDtmIndex(int n) {
        return this.mapToIndex(n);
    }

    public int mapToIndex(int n) {
        return this.indexes[n];
    }

    public void set(Object object, int n, int n2) {
    }

    public void setMaintainSortOrder(boolean bl) {
        this.maintainSortOrder = bl;
    }

    public void setSortedAscending(boolean bl) {
        this.ascending = bl;
    }

    public void setValueAt(Object object, int n, int n2) {
        int[] nArray = this.indexes;
        synchronized (this.indexes) {
            this.set(object, this.indexes[n], n2);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public void sortByColumn(int n, boolean bl) {
        this.sortingColumns.clear();
        this.sortingColumns.add(new Integer(n));
        if (!this.sort() && bl) {
            this.ascending = !this.ascending;
            this.sort();
        }
        this.lastSortedColumn = n;
    }

    public boolean sortByColumn(int n) {
        if (this.lastSortedColumn != n) {
            this.ascending = this.getColumnClass(n) == (class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractSortableTableModel.class$("java.lang.String")));
        }
        this.sortByColumn(n, this.lastSortedColumn == n);
        return this.ascending;
    }

    public boolean resort() {
        return this.lastSortedColumn != -1 ? this.sortByColumn(this.lastSortedColumn) : false;
    }

    protected void checkModel() {
        if (this.indexes.length != this.getRowCount()) {
            System.err.println("Tablesorter didnt get informed of a change in model!! ");
        }
    }

    protected int compare(int n, int n2) {
        ++this.compares;
        int n3 = 0;
        while (n3 < this.sortingColumns.size()) {
            Integer n4 = (Integer)this.sortingColumns.elementAt(n3);
            int n5 = this.compareRowsByColumn(n, n2, n4);
            if (n5 != 0) {
                return this.ascending ? n5 : -n5;
            }
            ++n3;
        }
        return 0;
    }

    protected int compareRowsByColumn(int n, int n2, int n3) {
        Class<?> clazz = this.getColumnClass(n3);
        Object object = this.get(n, n3);
        Object object2 = this.get(n2, n3);
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (clazz.equals(class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractSortableTableModel.class$("java.lang.String")))) {
            String string = (String)object;
            String string2 = (String)object2;
            int n4 = string.compareToIgnoreCase(string2);
            if (string.length() == 0 ^ string2.length() == 0) {
                n4 = -n4;
            }
            return n4;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        if (clazz == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = AbstractSortableTableModel.class$("java.lang.Boolean")))) {
            boolean bl;
            boolean bl2 = (Boolean)object;
            if (bl2 == (bl = ((Boolean)object2).booleanValue())) {
                return 0;
            }
            if (bl2) {
                return 1;
            }
            return -1;
        }
        return object.toString().compareTo(object2.toString());
    }

    /*
     * Unable to fully structure code
     */
    protected void reallocateIndexes(TableModelEvent var1_1) {
        var2_2 = this.getRowCount();
        if (var2_2 == this.indexes.length) {
            return;
        }
        var3_3 = new int[var2_2];
        var4_4 = new int[var2_2];
        var5_5 = this.indexes;
        synchronized (this.indexes) {
            block15: {
                block14: {
                    var7_6 = 0;
                    if (var1_1 == null || var1_1.getType() != -1) break block14;
                    var8_7 = 0;
                    while (var7_6 < this.indexes.length) {
                        var9_9 = 0;
                        var10_10 = false;
                        var11_11 = var1_1.getFirstRow();
                        while (var11_11 <= var1_1.getLastRow()) {
                            if (var11_11 < this.indexes[var7_6]) {
                                ++var9_9;
                            } else if (var11_11 == this.indexes[var7_6]) {
                                var10_10 = true;
                            }
                            ++var11_11;
                        }
                        if (var10_10) {
                            ++var8_7;
                        } else {
                            var3_3[var7_6 - var8_7] = this.indexes[var7_6] - var9_9;
                            var4_4[this.indexes[var7_6] - var9_9] = var7_6 - var8_7;
                        }
                        ++var7_6;
                    }
                    break block15;
                }
                if (var1_1 == null || var1_1.getType() != 0 || var1_1.getLastRow() < this.indexes.length) ** GOTO lbl44
                var8_8 = 0;
                while (var8_8 < var2_2) {
                    var3_3[var8_8] = var8_8;
                    var4_4[var8_8] = var8_8;
                    ++var8_8;
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    var3_3[var7_6] = this.indexes[var7_6];
                    var4_4[var7_6] = this.revIndexes[var7_6];
                    ++var7_6;
lbl44:
                    // 2 sources

                    ** while (var7_6 < this.indexes.length && var7_6 < var2_2)
                }
lbl45:
                // 2 sources

                while (var7_6 < var2_2) {
                    var3_3[var7_6] = var7_6;
                    var4_4[var7_6] = var7_6;
                    ++var7_6;
                }
            }
            this.indexes = var3_3;
            this.revIndexes = var4_4;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    protected void reallocateIndexes() {
        this.reallocateIndexes(null);
    }

    protected boolean sort() {
        int[] nArray = this.indexes;
        synchronized (this.indexes) {
            this.compares = 0;
            if (this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length)) {
                int n = 0;
                while (n < this.indexes.length) {
                    this.revIndexes[this.indexes[n]] = n;
                    ++n;
                }
                super.fireTableChanged(new TableModelEvent(this));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    public boolean shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        boolean bl = false;
        int n3 = (n + n2) / 2;
        bl |= this.shuttlesort(nArray2, nArray, n, n3);
        bl |= this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4) {
            if (this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
                int n6 = n;
                while (n6 < n2) {
                    nArray2[n6] = nArray[n6];
                    ++n6;
                }
                return bl;
            }
            if (this.compare(nArray[n2 - 1], nArray[n]) < 0) {
                int n7 = n;
                while (n5 < n2) {
                    nArray2[n7++] = nArray[n5];
                    ++n5;
                }
                while (n7 < n2) {
                    nArray2[n7] = nArray[n4++];
                    ++n7;
                }
                return bl;
            }
        }
        int n8 = n;
        while (n8 < n2) {
            if (n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0) {
                nArray2[n8] = nArray[n4++];
            } else {
                bl |= n4 < n3;
                nArray2[n8] = nArray[n5++];
            }
            ++n8;
        }
        return bl;
    }

    public void n2sort() {
        int n = 0;
        while (n < this.getRowCount()) {
            int n2 = n + 1;
            while (n2 < this.getRowCount()) {
                if (this.compare(this.indexes[n], this.indexes[n2]) == -1) {
                    this.swap(n, n2);
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public AbstractSortableTableModel(boolean bl) {
        this.maintainSortOrder = bl;
    }

    public AbstractSortableTableModel() {
        this(false);
    }
}

