/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.FilesizeCellRenderer;
import xnap.gui.table.StringCellRenderer;
import xnap.gui.table.TimeCellRenderer;
import xnap.io.FileHandler;
import xnap.io.RepositoryFile;
import xnap.util.FileHelper;
import xnap.util.Preferences;

public class LibraryTableModel
extends AbstractDynamicTableModel {
    public static final int NAME = 0;
    public static final int FULLNAME = 1;
    public static final int PATH = 2;
    public static final int TYPE = 3;
    public static final int SIZE = 4;
    public static final int MODIFIED = 5;
    public static final int INFO = 6;
    private static Logger logger = Logger.getLogger(class$Lxnap$gui$table$LibraryTableModel != null ? class$Lxnap$gui$table$LibraryTableModel : (class$Lxnap$gui$table$LibraryTableModel = LibraryTableModel.class$("xnap.gui.table.LibraryTableModel")));
    protected Column[] columns = new Column[]{new Column(XNap.tr("Name"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = LibraryTableModel.class$("java.lang.String")), new StringCellRenderer()), new Column(XNap.tr("Fullname"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = LibraryTableModel.class$("java.lang.String")), new StringCellRenderer()), new Column(XNap.tr("Path"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = LibraryTableModel.class$("java.lang.String")), new StringCellRenderer()), new Column(XNap.tr("Type"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = LibraryTableModel.class$("java.lang.String"))), new Column(XNap.tr("Size"), class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = LibraryTableModel.class$("java.lang.Long")), new FilesizeCellRenderer()), new Column(XNap.tr("Modified"), class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = LibraryTableModel.class$("java.lang.Long")), new TimeCellRenderer()), new Column(XNap.tr("Info"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = LibraryTableModel.class$("java.lang.String")), new StringCellRenderer())};
    private ArrayList data = new ArrayList();
    private ParseThread pt;
    private long totalSize;
    private int editableColumn = -1;
    private int editableRow = -1;
    private File currentDir;
    private static /* synthetic */ Class class$Lxnap$gui$table$LibraryTableModel;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Long;

    public void add(File file) {
        if (file.isDirectory()) {
            this.add(file.listFiles());
            this.currentDir = file;
        } else {
            this.addFile(file);
        }
    }

    public void add(File[] fileArray) {
        int n = this.data.size();
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (fileArray[n2].isFile()) {
                this.addFile(fileArray[n2]);
            }
            ++n2;
        }
        this.fireTableRowsInserted(n, this.data.size() - 1);
        if (this.pt != null) {
            this.pt.die = true;
        }
        this.pt = new ParseThread();
        this.pt.start();
    }

    public void addFile(File file) {
        if (!(file instanceof RepositoryFile)) {
            file = FileHandler.handle(file, false);
        }
        this.data.add(file);
        this.totalSize += file.length();
    }

    public boolean delete(File file) {
        int n = this.data.indexOf(file);
        if (n != -1 && file.delete()) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.pt != null) {
            this.pt.die = true;
        }
        int n = this.data.size() - 1;
        this.data.clear();
        this.fireTableRowsDeleted(0, n);
        this.totalSize = 0L;
    }

    public RepositoryFile get(int n) {
        return (RepositoryFile)this.data.get(this.mapToIndex(n));
    }

    public int getRowCount() {
        return this.data.size();
    }

    public Object get(int n, int n2) {
        if (n >= this.data.size()) {
            return null;
        }
        RepositoryFile repositoryFile = (RepositoryFile)this.data.get(n);
        if (repositoryFile == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return repositoryFile.getName();
            }
            case 1: {
                return repositoryFile.getPath();
            }
            case 2: {
                return repositoryFile.getParent();
            }
            case 4: {
                return new Long(repositoryFile.length());
            }
            case 3: {
                return FileHelper.extension(repositoryFile.getName());
            }
            case 5: {
                return new Long(repositoryFile.lastModified());
            }
            case 6: {
                return repositoryFile.getInfo();
            }
        }
        return null;
    }

    public String getTableName() {
        return XNap.tr("Library Table");
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public boolean isCellEditable(int n, int n2) {
        return n == this.editableRow && n2 == this.editableColumn;
    }

    public void remove(int n) {
        this.data.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void setCellEditable(int n, int n2) {
        this.editableRow = n;
        this.editableColumn = n2;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!(object instanceof String)) {
            return;
        }
        String string = (String)object;
        RepositoryFile repositoryFile = this.get(n);
        if (string.length() > 0 && repositoryFile.canWrite()) {
            try {
                repositoryFile = FileHandler.handle(FileHelper.moveUnique(repositoryFile, repositoryFile.getParent(), string), false);
                this.data.set(this.mapToIndex(n), repositoryFile);
                this.fireTableRowsUpdated(n, n);
            }
            catch (IOException iOException) {
                logger.debug("Could not rename file", iOException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public LibraryTableModel() {
        super("library", Preferences.getInstance());
        this.setColumns(this.columns);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
        defaultCellEditor.setClickCountToStart(Integer.MAX_VALUE);
        this.columns[0].setCellEditor(defaultCellEditor);
    }

    protected class ParseThread
    extends Thread {
        public boolean die;

        public void run() {
            this.die = false;
            this.parseWholeTable();
        }

        private final void parseWholeTable() {
            int n = 0;
            while (n < LibraryTableModel.this.data.size() && !this.die) {
                RepositoryFile repositoryFile = (RepositoryFile)LibraryTableModel.this.data.get(n);
                repositoryFile.parse();
                if (!this.die) {
                    LibraryTableModel.this.fireTableRowsUpdated(n, n);
                }
                ++n;
            }
        }
    }
}

