/*
 * Decompiled with CFR 0.152.
 */
package xnap.net;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import xnap.net.IChannel;
import xnap.net.IChatServer;
import xnap.net.IUser;
import xnap.net.event.ChannelListener;
import xnap.net.event.ChannelSupport;

public abstract class AbstractChannel
implements IChannel {
    protected ChannelSupport cs = new ChannelSupport(this);
    protected List users = Collections.synchronizedList(new ArrayList());
    protected String name;
    protected IChatServer chatServer;
    protected String topic;
    protected int userCount;

    public synchronized void add(IUser iUser) {
        this.users.add(iUser);
        this.cs.fireUserAdded(iUser);
    }

    public void addChannelListener(ChannelListener channelListener) {
        this.cs.addChannelListener(channelListener);
    }

    public void removeChannelListener(ChannelListener channelListener) {
        this.cs.removeChannelListener(channelListener);
    }

    public void close() {
        this.cs.fireChannelClosed();
    }

    public String getName() {
        return this.name;
    }

    public IChatServer getServer() {
        return this.chatServer;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String string) {
        this.topic = string;
        this.cs.fireTopicChanged(this.topic);
    }

    public int getUserCount() {
        return this.userCount;
    }

    public void setUserCount(int n) {
        this.userCount = n;
    }

    public abstract void join() throws IOException;

    public void messageReceived(IUser iUser, String string) {
        this.cs.fireMessageReceived(iUser, string, 1);
    }

    public void errorReceived(String string) {
        this.cs.fireMessageReceived(string, 3);
    }

    public void infoReceived(String string) {
        this.cs.fireMessageReceived(string, 2);
    }

    public void topicChanged(String string) {
        this.cs.fireTopicChanged(string);
    }

    public IUser[] getUsers() {
        IUser[] iUserArray = new IUser[this.users.size()];
        System.arraycopy(this.users.toArray(), 0, iUserArray, 0, iUserArray.length);
        return iUserArray;
    }

    public synchronized void remove(IUser iUser) {
        this.users.remove(iUser);
        this.cs.fireUserRemoved(iUser);
    }

    public abstract boolean canChangeTopic();

    public abstract void changeTopic(String var1) throws IOException;

    public abstract void sendMessage(String var1) throws IOException;

    public AbstractChannel(IChatServer iChatServer, String string, String string2, int n) {
        this.chatServer = iChatServer;
        this.name = string;
        this.topic = string2;
        this.userCount = n;
    }
}

