/*
 * Decompiled with CFR 0.152.
 */
package xnap.net;

import java.io.IOException;
import xnap.net.IDownload;
import xnap.net.IDownloadContainer;
import xnap.net.IUser;

public abstract class AbstractDownload
implements IDownload {
    protected IUser user;
    protected long filesize;
    protected long lastTry = -1L;
    private int tryCount = 0;
    private int queuePos = -1;
    private IDownloadContainer parent;

    public boolean equals(Object object) {
        if (object instanceof AbstractDownload) {
            AbstractDownload abstractDownload = (AbstractDownload)object;
            return this.getFilesize() == abstractDownload.getFilesize() && this.getUser().equals(abstractDownload.getUser());
        }
        return false;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public long getLastTry() {
        return this.lastTry;
    }

    public int getQueuePos() {
        return this.queuePos;
    }

    public IDownloadContainer getParent() {
        return this.parent;
    }

    public IUser getUser() {
        return this.user;
    }

    public void setParent(IDownloadContainer iDownloadContainer) {
        this.parent = iDownloadContainer;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void reset() {
        this.tryCount = 0;
        this.lastTry = -1L;
    }

    public void start() {
        ++this.tryCount;
        this.lastTry = System.currentTimeMillis();
    }

    protected void setQueuePos(int n) {
        this.queuePos = n;
        this.parent.setQueuePos(this, this.queuePos);
    }

    public String toString() {
        return "download @" + this.getUser().getName();
    }

    public abstract int available() throws IOException;

    public abstract void close();

    public abstract boolean connect(long var1) throws IOException;

    public abstract void dequeue();

    public abstract void enqueue(IDownloadContainer var1);

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public AbstractDownload(IUser iUser, long l) {
        this.user = iUser;
        this.filesize = l;
    }
}

