/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin;

import java.io.File;
import java.util.Hashtable;
import xnap.XNap;
import xnap.gui.SplashWindow;
import xnap.gui.ViewerPanel;
import xnap.plugin.IPlugin;
import xnap.plugin.IViewerPlugin;
import xnap.plugin.PluginManager;
import xnap.util.FileHelper;

public class GUIPluginManager
extends PluginManager {
    protected Hashtable viewers = new Hashtable();

    public static synchronized PluginManager getInstance() {
        if (PluginManager.singleton == null) {
            PluginManager.singleton = new GUIPluginManager();
        }
        return PluginManager.singleton;
    }

    public static synchronized GUIPluginManager getGUIInstance() {
        return (GUIPluginManager)GUIPluginManager.getInstance();
    }

    public synchronized void setEnabled(IPlugin iPlugin, boolean bl) {
        if (bl) {
            SplashWindow.setText(XNap.tr("Loading", 0, 1) + iPlugin.getName() + " plugin");
            SplashWindow.incProgress(10);
        }
        super.setEnabled(iPlugin, bl);
    }

    public boolean isValidPlugin(Class clazz) {
        return true;
    }

    public synchronized void installViewer(String string, IViewerPlugin iViewerPlugin) {
        this.viewers.put(string, iViewerPlugin);
    }

    public synchronized void installViewer(String[] stringArray, IViewerPlugin iViewerPlugin) {
        int n = 0;
        while (n < stringArray.length) {
            this.installViewer(stringArray[n], iViewerPlugin);
            ++n;
        }
    }

    public synchronized void removeViewer(String string, IViewerPlugin iViewerPlugin) {
        if (this.viewers.get(string) == iViewerPlugin) {
            this.viewers.remove(string);
        }
    }

    public synchronized void removeViewer(String[] stringArray, IViewerPlugin iViewerPlugin) {
        int n = 0;
        while (n < stringArray.length) {
            this.removeViewer(stringArray[n], iViewerPlugin);
            ++n;
        }
    }

    public synchronized ViewerPanel getViewer(File file) {
        String string = FileHelper.extension(file.getName());
        IViewerPlugin iViewerPlugin = (IViewerPlugin)this.viewers.get(string);
        if (iViewerPlugin != null) {
            return iViewerPlugin.handle(file);
        }
        return null;
    }

    protected GUIPluginManager() {
    }
}

