/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.util.StringTokenizer;

public class ServerVersion {
    public static final ServerVersion OPENNAP044 = new ServerVersion("opennap 0.44.0", null);
    public static final ServerVersion SLAVANAP1 = new ServerVersion("slavanap 1.0.0", null);
    public static final ServerVersion SLAVANAP2 = new ServerVersion("slavanap 2.0.0", SLAVANAP1);
    public static final ServerVersion UNKNOWN = new ServerVersion("", null);
    public static final ServerVersion[] TOP_VERSIONS = new ServerVersion[]{OPENNAP044, SLAVANAP2};
    public String software;
    public int[] versions;
    public ServerVersion nextVersion;

    public ServerVersion getClosestVersion() {
        int n = 0;
        while (n < TOP_VERSIONS.length) {
            ServerVersion serverVersion = TOP_VERSIONS[n];
            if (this.software.equalsIgnoreCase(serverVersion.software)) {
                while (serverVersion != null) {
                    if (this.isCompatibleTo(serverVersion)) {
                        return serverVersion;
                    }
                    serverVersion = serverVersion.getNextVersion();
                }
            }
            ++n;
        }
        return null;
    }

    public ServerVersion getNextVersion() {
        return this.nextVersion;
    }

    public boolean isOpenNap() {
        return this.software.equalsIgnoreCase("opennap");
    }

    public boolean isSlavaNap() {
        return this.software.equalsIgnoreCase("slavanap");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.software);
        if (this.versions.length > 0) {
            stringBuffer.append(" ");
        }
        int n = 0;
        while (n < this.versions.length) {
            stringBuffer.append(this.versions[n]);
            if (n < this.versions.length - 1) {
                stringBuffer.append(".");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isCompatibleTo(ServerVersion serverVersion) {
        int n = 0;
        while (n < this.versions.length && n < serverVersion.versions.length) {
            if (this.versions[n] > serverVersion.versions[n]) {
                return true;
            }
            if (this.versions[n] < serverVersion.versions[n]) {
                return false;
            }
            ++n;
        }
        return this.versions.length >= serverVersion.versions.length;
    }

    protected void parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " .");
        this.software = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        this.versions = new int[stringTokenizer.countTokens()];
        if (stringTokenizer.hasMoreTokens()) {
            int n = 0;
            while (n < this.versions.length) {
                try {
                    this.versions[n] = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    this.versions[n] = 0;
                }
                ++n;
            }
        }
    }

    public ServerVersion(String string, ServerVersion serverVersion) {
        this.parse(string);
        this.nextVersion = serverVersion;
    }

    public ServerVersion(String string) {
        this.parse(string);
        this.nextVersion = this.getClosestVersion();
        if (this.nextVersion == null) {
            this.nextVersion = OPENNAP044;
        }
    }
}

