/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.AltDirectBrowseUpload;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.DirectBrowseAckMessage;
import xnap.plugin.nap.net.msg.server.InvalidMessageException;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.util.QuotedStringTokenizer;
import xnap.util.StringHelper;

public class DirectBrowseRequestMessage
extends ServerMessage {
    public static final int TYPE = 640;
    public String nick;
    public String ip;
    public int port;

    protected void parse(QuotedStringTokenizer quotedStringTokenizer) {
        this.nick = quotedStringTokenizer.nextToken();
        this.ip = quotedStringTokenizer.hasMoreTokens() ? StringHelper.parseIP(quotedStringTokenizer.nextToken()) : null;
        this.port = quotedStringTokenizer.hasMoreTokens() ? Integer.parseInt(quotedStringTokenizer.nextToken()) : 0;
    }

    public void received() {
        if (this.ip != null && this.port > 0) {
            MessageHandler.send(this.server, new DirectBrowseAckMessage(this.nick));
            AltDirectBrowseUpload altDirectBrowseUpload = new AltDirectBrowseUpload(this.server, this.ip, this.port);
            altDirectBrowseUpload.start();
        } else if (this.server.getLocalPort() != 0) {
            MessageHandler.addBrowseRequest(this.server);
            MessageHandler.send(this.server, new DirectBrowseAckMessage(this.nick));
        }
    }

    public DirectBrowseRequestMessage(String string) throws InvalidMessageException {
        super(640, string, 1);
    }
}

