/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg.server;

import java.util.LinkedList;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.server.MessageListener;
import xnap.plugin.nap.net.msg.server.ServerMessage;

public class MessageStream
implements MessageListener {
    protected Object lock = new Object();
    protected LinkedList queue = new LinkedList();
    protected Server server;

    public synchronized void messageReceived(ServerMessage serverMessage) {
        if (this.isCompetent(serverMessage.getServer())) {
            this.queue.addLast(serverMessage);
            this.wakeup();
        }
    }

    public boolean isCompetent(Server server) {
        return server == null || this.server == server;
    }

    public boolean hasNext(long l) {
        if (this.hasNext()) {
            return true;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                if (l > 0L) {
                    this.lock.wait(l);
                } else {
                    this.lock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.hasNext();
    }

    public synchronized boolean hasNext() {
        return this.queue.size() > 0;
    }

    public synchronized ServerMessage next() {
        return (ServerMessage)this.queue.removeFirst();
    }

    public void wakeup() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public MessageStream(Server server) {
        this.server = server;
    }

    public MessageStream() {
        this(null);
    }
}

