/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Logger;
import xnap.util.prefs.Validator;

public abstract class PreferencesSupport {
    public static final String ARRAY_SEPARATOR = ";";
    protected static Logger logger = Logger.getLogger(class$Lxnap$util$PreferencesSupport != null ? class$Lxnap$util$PreferencesSupport : (class$Lxnap$util$PreferencesSupport = PreferencesSupport.class$("xnap.util.PreferencesSupport")));
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected boolean changedFlag = false;
    protected File prefsFile;
    protected int version;
    protected int oldVersion = -1;
    protected String namespace;
    protected Properties props = new Properties();
    private Hashtable validatorsByKey = new Hashtable();
    private static /* synthetic */ Class class$Lxnap$util$PreferencesSupport;

    public String getFilename() {
        return this.prefsFile.getAbsolutePath();
    }

    /*
     * Loose catch block
     */
    public void read(File file) {
        block17: {
            FileInputStream fileInputStream;
            block16: {
                logger.info("reading " + file);
                fileInputStream = null;
                fileInputStream = new FileInputStream(file);
                this.props.load(fileInputStream);
                try {
                    this.oldVersion = Integer.parseInt(this.props.getProperty("props.ver", "-1"));
                }
                catch (NumberFormatException numberFormatException) {
                    this.oldVersion = -1;
                }
                if (this.oldVersion == -1 || this.oldVersion >= this.getVersion()) break block16;
                logger.debug("converting from version " + this.oldVersion + " to " + this.getVersion());
                this.convert(this.oldVersion);
            }
            Object var4_6 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block17;
            }
            catch (Exception exception) {}
            break block17;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    Object var4_7 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block17;
                    }
                    catch (Exception exception) {}
                    break block17;
                }
                catch (IOException iOException) {
                    Object var4_8 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block17;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void read() {
        this.read(this.prefsFile);
    }

    /*
     * Loose catch block
     */
    public boolean write() {
        block12: {
            if (!this.changedFlag) {
                logger.info("nothing changed, not writing " + this.prefsFile);
                return true;
            }
            logger.info("writing " + this.prefsFile);
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(this.prefsFile);
            ((Hashtable)this.props).put("props.ver", this.version + "");
            this.props.store(fileOutputStream, "This file was automatically generated.");
            Object var3_2 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block12;
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (IOException iOException) {
                    boolean bl = false;
                    Object var3_3 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.changedFlag = false;
        return true;
    }

    public int getOldVersion() {
        return this.oldVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public abstract void convert(int var1);

    public abstract void defaults();

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChange.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        int n = string.lastIndexOf(".");
        if (string.length() > n + 1) {
            string = string.substring(n + 1);
        }
        this.propertyChange.firePropertyChange(string, object, object2);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean getBoolean(String string) {
        String string2 = this.getProperty(string, "false");
        return string2.equalsIgnoreCase("true");
    }

    public int getInt(String string) {
        try {
            return Integer.parseInt(this.getProperty(string, "0"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public long getLong(String string) {
        try {
            return Long.parseLong(this.getProperty(string, "0"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public String get(String string) {
        return this.getProperty(string, "");
    }

    public void set(String string, String string2) {
        String string3 = this.get(string);
        if (!PreferencesSupport.areObjectsEqual(string2, string3)) {
            this.setProperty(string, string2);
            this.firePropertyChange(string, string3, string2);
        }
    }

    public void set(String string, boolean bl) {
        boolean bl2 = this.getBoolean(string);
        if (bl != bl2) {
            this.setProperty(string, bl + "");
            this.firePropertyChange(string, new Boolean(bl2), new Boolean(bl));
        }
    }

    public void set(String string, int n) {
        int n2 = this.getInt(string);
        if (n != n2) {
            this.setProperty(string, n + "");
            this.firePropertyChange(string, new Integer(n2), new Integer(n));
        }
    }

    public void set(String string, long l) {
        long l2 = this.getLong(string);
        if (l != l2) {
            this.setProperty(string, l + "");
            this.firePropertyChange(string, new Long(l2), new Long(l));
        }
    }

    public void setDefault(String string, String string2, Validator validator) {
        if (this.getProperty(string, null) == null) {
            this.setProperty(string, string2, false);
        } else if (validator != null) {
            this.validatorsByKey.put(this.namespace + string, validator);
            try {
                validator.validate(this.getProperty(string, ""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.debug("invalid value: " + this.namespace + string + " = " + this.getProperty(string, "") + " [" + string2 + "]", illegalArgumentException);
                this.setProperty(string, string2, false);
            }
        }
    }

    public void setDefault(String string, String string2) {
        this.setDefault(string, string2, null);
    }

    public void removeProperty(String string) {
        ((Hashtable)this.props).remove(string);
        this.changedFlag = true;
    }

    public void renameProperty(String string, String string2) {
        Object v;
        String string3 = this.props.getProperty(string, null);
        if (string3 != null && (v = ((Hashtable)this.props).remove(string)) != null) {
            this.props.setProperty(string2, string3);
            this.changedFlag = true;
        }
    }

    protected String getProperty(String string, String string2) {
        String string3 = this.props.getProperty(this.namespace + string, string2);
        return string3;
    }

    protected void setProperty(String string, String string2, boolean bl) {
        Validator validator;
        if (bl && (validator = (Validator)this.validatorsByKey.get(this.namespace + string)) != null) {
            try {
                validator.validate(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.debug("invalid value: " + this.namespace + string + " = " + string2, illegalArgumentException);
                return;
            }
        }
        this.props.setProperty(this.namespace + string, string2);
        this.changedFlag = true;
    }

    protected void setProperty(String string, String string2) {
        this.setProperty(string, string2, true);
    }

    public static boolean areObjectsEqual(Object object, Object object2) {
        if (object != null) {
            return object.equals(object2);
        }
        return object == object2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PreferencesSupport(String string, int n, String string2) {
        this.prefsFile = new File(string);
        this.version = n;
        if (!string2.endsWith(".")) {
            string2 = string2 + ".";
        }
        this.namespace = string2;
    }
}

