/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import xnap.net.ISearchResult;
import xnap.net.SearchResultContainer;
import xnap.util.Debug;
import xnap.util.EventVector;
import xnap.util.Grouper;
import xnap.util.ISearchResultCollector;
import xnap.util.Preferences;
import xnap.util.SearchFilter;

public class SearchResultCollector
implements ISearchResultCollector {
    protected EventVector data = new EventVector();
    protected SearchFilter filter;
    protected Vector filteredData = new Vector();
    protected Grouper grouper;
    protected EventVector groupedData = new EventVector();

    /*
     * Enabled aggressive block sorting
     */
    public synchronized boolean add(ISearchResult iSearchResult) {
        int n = this.data.indexOf(iSearchResult);
        if (n != -1 && Preferences.getInstance().getRemoveDuplicateResults()) {
            if (iSearchResult.getScore() > ((ISearchResult)this.data.get(n)).getScore()) {
                Debug.log("SearchResultCollector: replacing " + iSearchResult);
                this.data.set(n, iSearchResult);
                this.filteredData.remove(iSearchResult);
                this.filterAdd(iSearchResult);
                return true;
            }
            Debug.log("SearchResultCollector: already contains " + iSearchResult);
            return false;
        }
        this.data.add(iSearchResult);
        this.filterAdd(iSearchResult);
        return true;
    }

    public synchronized void clear() {
        this.data.clear();
        this.rebuildFilteredData();
    }

    public EventVector getData() {
        return this.data;
    }

    public EventVector getGroupedData() {
        return this.groupedData;
    }

    public SearchFilter getFilter() {
        return this.filter;
    }

    public synchronized void setFilter(SearchFilter searchFilter) {
        this.filter = searchFilter;
        this.rebuildFilteredData();
    }

    public synchronized void setGrouper(Grouper grouper) {
        this.grouper = grouper;
        this.grouper.setData(this.groupedData);
        this.rebuildGroupedData();
    }

    public ISearchResult[] getResults() {
        ISearchResult[] iSearchResultArray = new ISearchResult[this.data.size()];
        System.arraycopy(this.data.toArray(), 0, iSearchResultArray, 0, iSearchResultArray.length);
        return iSearchResultArray;
    }

    public SearchResultContainer[] getGroupedResults() {
        SearchResultContainer[] searchResultContainerArray = new SearchResultContainer[this.groupedData.size()];
        System.arraycopy(this.groupedData.toArray(), 0, searchResultContainerArray, 0, searchResultContainerArray.length);
        return searchResultContainerArray;
    }

    public void remove(ISearchResult iSearchResult) {
        this.data.remove(iSearchResult);
    }

    protected void filterAdd(ISearchResult iSearchResult) {
        if (this.filter == null || this.filter.matches(iSearchResult)) {
            this.filteredData.add(iSearchResult);
            this.grouperAdd(iSearchResult);
        }
    }

    protected void grouperAdd(ISearchResult iSearchResult) {
        this.grouper.add(iSearchResult);
    }

    protected void rebuildFilteredData() {
        this.filteredData.clear();
        this.grouper.clear();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            this.filterAdd((ISearchResult)iterator.next());
        }
    }

    protected void rebuildGroupedData() {
        this.grouper.clear();
        Iterator iterator = ((AbstractList)this.filteredData).iterator();
        while (iterator.hasNext()) {
            this.grouperAdd((ISearchResult)iterator.next());
        }
    }

    public SearchResultCollector(SearchFilter searchFilter, Grouper grouper) {
        this.filter = searchFilter;
        this.grouper = grouper;
        this.grouper.setData(this.groupedData);
    }

    public SearchResultCollector(Grouper grouper) {
        this(null, grouper);
    }
}

