eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID2 system
# Agent name:        ConnSameHost
# Agent description: Check multiple connections from the same host
# Author:            Diego Zamboni
#
# History of modifications:
# 
# Known bugs:
# 
# Things to do:
# 
# Future work:
# 
# Suggestions made by people:
# 
# Generated automatically by ../bin/makeagent.pl on Tue Sep  7 23:55:47 1999.
# 
###### AUTOMATICALLY GENERATED FILE --- DO NOT EDIT ##########
#

# 10 "ConnSameHost.aas"
package ConnSameHost;

# Version number
# 13 "ConnSameHost.aas"
$VERSION=eval {do { my @r = (q$Revision: 1.6 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "Check multiple connections from the same host",
             CheckPeriod        => eval {undef},
# 30 "ConnSameHost.aas"
             CheckPeriod => 10,
             SumPeriod   => 60,
# 27 "ConnSameHost.aas"
             FiltersNeeded => {   Ftcpw => [{ All => 1}, 'Check'], }
            );

# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;


use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 ConnSameHost


This agent returns in the message field the maximum number of connections
from the same host that have occured in the last 'SumPeriod' seconds.

Both successful and unsuccessful connections are reported, and of any
service.

The status value does not make much sense for now, it is the max
number of connections, but truncated at 10.

=cut

# Preamble code
# 34 "ConnSameHost.aas"
  use Data::Dumper;
  use Util::NumQueue;

# Provide an Init function.
sub Init {
  my $self=checkref(shift);
# 38 "ConnSameHost.aas"
  $self->setParameter(MyHostQueues => {});
  return $self;
}

# The Check function.
sub Check {
  my $self=checkref(shift);
# 41 "ConnSameHost.aas"
  my ($filter, $fh, $line)=@_;
  my ($month,$day,$hour,$min,$sec,$host,$prog,$t1,$t2,$wherefrom);

  my $qs=$Params{"MyHostQueues"};
  if ($line) {
    ($month,$day,$hour,$min,$sec,$host,$prog,$t1,$t2,$wherefrom)=
      split(/[\s:]+/, $line);
    if ($wherefrom =~ /@/) {
      $wherefrom=(split(/@/, $wherefrom))[1];
    }
    $self->Log("debug", "Got a connection from $wherefrom\n");
    if (!exists($qs->{$wherefrom})) {
      $self->Log("debug", "Creating a queue for it\n");
      my $queue=Util::NumQueue->new;
      $queue->timelength($Params{SumPeriod});
      $qs->{$wherefrom}=$queue;
    }
    $qs->{$wherefrom}->add(1);
  }
  # Update all the queues
  my $k;
  my @conns;
  foreach $k (keys %$qs) {
    $self->Log("debug", "Updating queue for $k\n");
    $qs->{$k}->update;
    # Delete if they become empty
    if ($qs->{$k}->isEmpty) {
      $self->Log("debug", "Queue for $k became empty, removing.\n");
      delete $qs->{$k};
    }
    else {
      push @conns, [$qs->{$k}->sum, $k];
    }
  }
  $self->Log("debug", "List of connections: ".Dumper(\@conns)."\n");
  # Sort
  @conns=sort { $b->[0] <=> $a->[0] } @conns;
  $self->Log("debug", "Sorted list of connections: ".Dumper(\@conns)."\n");

  my $winner=$conns[0];
  my $winconn=$winner->[0] || 0;
  my $status=$winconn>10?10:$winconn;
  my $winhost=$winner->[1] || "no host";
  $status=10 if $status>10;
  return ($status, $winconn." ($winhost)");
}
# Agent commands

# End of entity marker
_EndOfEntity;
