eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID project, CERIAS, 1999.
#
# Mahesh Tripunitara, Sep 6, 1999.
#
# $Id: IllegalIPPackets.pm,v 1.1 1999/09/07 01:13:32 zamboni Exp $
#
# NOTE: This file is in Perl's POD format. For more information, see the 
#       manual page for perlpod(1).
#

package IllegalIPPackets;

# Version number
$VERSION=eval {0.1}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "An agent that watches for certain types of illegal IP packets",
             CheckPeriod        => eval {undef},
             FiltersNeeded => { LibpcapFilter => [{ Expr => '(ip[1] & 0x1e > 0x10) or (ip[1] & 0xe > 8) or (ip[1] & 0x6 > 4) or (ip[1] & 0x1 = 1) or (ip[6] & 0x80 = 0x80) or (ip[6:2] & 0x3fff > 0x1fff)', InterfaceName => 'hme0', NumPackets => -1, All => 1 }, 'Check' ] }
            );

# Note the parameters for the Libpcap filter:
# Expr gives an expression used to specify what type of packets to capture.
# It is a string, and it is better to enclose it in single quotes.
# InterfaceName gives the name of an interface to get packets from.
# One of the to-do things is to automate this in the filter so the agent
# doesn't have to worry. See the commented-out code for the subroutine
# Init_log_old in the Libpcap.pm filter code for how to use the ifconfig
# command to get a list of the possible interface names.
# NumPackets specifies when the filter will return (and stop capturing).
# A negative value means "forever."
# All => 1 means that you want all the packets that match Expr to be
# sent to the agent. This parameter is not specific to the Libpcap filter
# and should probably be set to 1 always.


# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;
use Net::Pcap;

use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 IllegalIPPackets

This agent looks for certain types of illegal IP packets. Such packets
should not be sent or received by any host, and such reception indicates
possible cause for alarm. The types of packets monitored, as expressed
in the parameter called "Expr," are:

1. Illegal Type of Service values:
(ip[1] & 0x1e > 0x10) or (ip[1] & 0xe > 8) or (ip[1] & 0x6 > 4) indicates
that at most one of the 4 meaningful TOS bits can be set.

(ip[1] & 0x1 = 1) indicates that the reserved TOS bit should be clear.

2. Illegal fragmentation information:
(ip[6] & 0x80 = 0x80) indicates that the reserved bit in the flags should be
clear.

(ip[6:2] & 0x3fff > 0x1fff) indicates that the "more fragments" bit cannot
be set when this is the last possible fragment.

See the manual page for tcpdump on how to construct such (legal)
expressions.

Also, see the Perl documentation in this file to find out how and what
to specify for the Libpcap filter.

=cut

# Preamble code


# Provide an Init function.
sub Init {
  my $self=checkref(shift);

    # Nothing to do in here

  return $self;
}

# The runtime initialization function.
sub runtimeInit {
  my $self=checkref(shift);

  return $self;
}

# The Check function.
sub Check {
    my $self=checkref(shift);
    my ($filter, $fh, $line)=@_;

    my $msg = "Got an illegal IP packet!";
    my $val = ($self->getParameter('Status')||0)+1;

    $self->Log("debug", "Getting out of check routine.\n");
    return($val, $msg);
}

# The Cleanup function
sub Cleanup {
  my $self=checkref(shift);
  my $reason=shift;

}

# Agent commands

# End of entity marker
_EndOfEntity;
