eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID project, CERIAS, 1999.
#
# Mahesh Tripunitara, Sep 6, 1999.
#
# $Id: Land.pm,v 1.3 1999/09/07 01:14:31 zamboni Exp $
#
# NOTE: This file is in Perl's POD format. For more information, see the 
#       manual page for perlpod(1).
#

package Land;

# Version number
$VERSION=eval {0.1}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "An agent that watches for the Land attack",
             CheckPeriod        => eval {undef},
             FiltersNeeded => { LibpcapFilter => [{ Expr => '(ip[12:4] = ip[13:4]) & (tcp[13:1] & 0x2 = 0x2)', InterfaceName => 'hme0', NumPackets => -1, All => 1 }, 'Check' ] }
            );

# Note the parameters for the Libpcap filter:
# Expr gives an expression used to specify what type of packets to capture.
# It is a string, and it is better to enclose it in single quotes.
# InterfaceName gives the name of an interface to get packets from.
# One of the to-do things is to automate this in the filter so the agent
# doesn't have to worry. See the commented-out code for the subroutine
# Init_log_old in the Libpcap.pm filter code for how to use the ifconfig
# command to get a list of the possible interface names.
# NumPackets specifies when the filter will return (and stop capturing).
# A negative value means "forever."
# All => 1 means that you want all the packets that match Expr to be
# sent to the agent. This parameter is not specific to the Libpcap filter
# and should probably be set to 1 always.


# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;
use Net::Pcap;

use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 Land

This agent watched for the "Land" attack, which is a TCP connection
request with the source address set to the same as the destination
address, which is our address.

See the manual page for tcpdump on how to construct such (legal)
expressions.

Also, see the Perl documentation in this file to find out how and what
to specify for the Libpcap filter.

=cut

# Preamble code


# Provide an Init function.
sub Init {
  my $self=checkref(shift);

    # Nothing to do in here

  return $self;
}

# The runtime initialization function.
sub runtimeInit {
  my $self=checkref(shift);

  return $self;
}

# The Check function.
sub Check {
    my $self=checkref(shift);
    my ($filter, $fh, $line)=@_;

    # $line contains the packet contents as a byte stream
    # sprintf() can be used to extract & study pieces of it

    my $msg = "Being subjected to the Land attack!";
    my $val = ($self->getParameter('Status')||0)+1;

    $self->Log("debug", "Getting out of check routine.\n");
    return($val, $msg);
}

# The Cleanup function
sub Cleanup {
  my $self=checkref(shift);
  my $reason=shift;

}

# Agent commands

# End of entity marker
_EndOfEntity;
