eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID2 system
# Agent name:        WeirdConn
# Agent description: Detect connections to unusual ports
# Author:            Diego Zamboni
#
# History of modifications:
# 
# Known bugs:
# 
# Things to do:
# 
# Future work:
# 
# Suggestions made by people:
# 
# Generated automatically by ../bin/makeagent.pl on Tue Sep  7 23:55:58 1999.
# 
###### AUTOMATICALLY GENERATED FILE --- DO NOT EDIT ##########
#

# 10 "WeirdConn.aas"
package WeirdConn;

# Version number
# 13 "WeirdConn.aas"
$VERSION=eval {do { my @r = (q$Revision: 1.6 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "Detect connections to unusual ports",
             CheckPeriod        => eval {undef},
# 22 "WeirdConn.aas"
             MyWeirdPortTCP => 9824,
             Message => "0",
             FiltersNeeded => {  }
            );

# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;
# 25 "WeirdConn.aas"
use IO::Socket;

use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 WeirdConn


This agent attempts to detect connections to unusual ports by opening
a socket in an unusual TCP port. If a connection is received, it
signals an alert.

=cut

# Preamble code


# The runtime initialization function.
sub runtimeInit {
  my $self=checkref(shift);
# 28 "WeirdConn.aas"
  # Open the socket
  my $port=$Params{MyWeirdPortTCP};
  my $sock=IO::Socket::INET->new(Listen		=> 10,
				 LocalAddr	=> undef,
				 LocalPort	=> $port,
				 Proto		=> 'tcp',
				 Reuse		=> 1
				);
  return undef unless $sock;
  $Params{MyServerSocket}=$sock;
  Comm::Reactor::add_acceptor($sock, sub { $self->_do_Check(@_); } );
  # Schedule the first one
  Comm::Reactor::add_event(time(), sub { $self->_do_Check(undef, 1); });
  return $self;
}

# The Check function.
sub Check {
  my $self=checkref(shift);
# 43 "WeirdConn.aas"
  my $fh=shift;
  my $noaccept=shift;
  
  if ($noaccept) {
    return (0, "0");
  }

  my $new=$fh->accept;
  $self->Log("debug", "Got new connection on server socket, from ".
	     scalar(gethostbyaddr($new->peeraddr, AF_INET)) . "\n");
  my $peer=scalar(gethostbyaddr($new->peeraddr, AF_INET));
  $new->close;
  # Schedule an immediate event to go back to normal.
  Comm::Reactor::add_event(time()+1, sub { $self->_do_Check(undef, 1); } );
  return (1, "1 ($peer)");
}
# Agent commands

# End of entity marker
_EndOfEntity;
