eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID2 system
# Agent name:        CPUload
# Agent description: Check CPU load average
# Author:            Diego Zamboni
#
# History of modifications:
# 
# Known bugs:
# 
# Things to do:
# 
# Future work:
# 
# Suggestions made by people:
# 
# Generated automatically by ../bin/makeagent.pl on Tue Sep  7 23:55:41 1999.
# 
###### AUTOMATICALLY GENERATED FILE --- DO NOT EDIT ##########
#

# 10 "CPUload.aas"
package CPUload;

# Version number
# 13 "CPUload.aas"
$VERSION=eval {do { my @r = (q$Revision: 1.6 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "Check CPU load average",
             CheckPeriod        => eval {undef},
# 44 "CPUload.aas"
             MyThreshold_1min      => 5,
             MyThreshold_5min      => 4,
             MyThreshold_15min     => 3,
             Add_1min              => 1,
             Add_5min              => 2,
             Add_15min             => 3,
             Add_all               => 0,
             Sub_1min              => 0,
             Sub_5min              => 0,
             Sub_15min             => 0,
             Sub_all               => 1,
             ReportIfMessageChanges => 0,
# 41 "CPUload.aas"
             FiltersNeeded => {   CPUload => [{ All=>1 }, 'Check'] }
            );

# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;


use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 CPUload


This agent works as follows:

The system loads as reported on a Unix system by uptime are analyzed.
The agent has three thresholds: one for the shorter-term load (1 minute),
one for the medium-term load (5 minutes) and one for the long-term load
(15 minutes). Whenever the short term load exceeds its threshold, 1 is
added to the status. Whenever the medium term load exceeds its threshold,
2 is added to the status, and if the long term load exceeds its threshold,
3 is added to the status. The idea is that short-duration "spikes" in load
are not very worrysome, but a long-term heavy load demands more attention.
The status is decreased by 1 each time the three loads are below their
thresholds. The status message contains "System load: l1 l2 l3" where the
l's are the loads.

The amounts to be added and substracted can be controlled using the
C<Add_*> and C<Sub_*> parameters. The C<Add_all> and C<Sub_all> parameters
specify a quantity to be added or substracted from the status if all
the loads are above or below their thresholds, respectively. These two
parameters apply on top of the individual adds/substracts for each load.

This version of the agent reports every change in the loads (not only
in the status) because its purpose is to collect raw data.

=cut

# Preamble code


# The Check function.
sub Check {
  my $self=checkref(shift);
# 58 "CPUload.aas"
  my ($filter, $fh, $line)=@_;
  my @thr=($Params{MyThreshold_1min},
	   $Params{MyThreshold_5min},
	   $Params{MyThreshold_15min});
  my @add=($Params{Add_1min},
           $Params{Add_5min},
           $Params{Add_15min});
  my @sub=($Params{Sub_1min},
           $Params{Sub_5min},
           $Params{Sub_15min});
  my $add_all=$Params{Add_all};
  my $sub_all=$Params{Sub_all};
  my $status=$Params{Status};
  my $i;
  # The $line is of the form "load1min load5min load15min";
  my @load=splitList($line);
  # Check the three thresholds.
  my $nabove=0;
  my $nbelow=0;
  for ($i=0; $i<3; $i++) {
    if ($load[$i]>=$thr[$i]) {
      $status+=$add[$i];
      $nabove++;
    }
    else {
      $status-=$sub[$i];
      $nbelow++;
    }
  }
  if ($nabove==3) {
    $status+=$add_all;
  }
  if ($nbelow==3) {
    $status-=$sub_all;
  }
  $status=0 if $status<0;
  $status=10 if $status>10;
  return ($status, "Loads: @load");
}
# Agent commands

# End of entity marker
_EndOfEntity;
