eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID2 system
# Agent name:        GroupFilesChecker
# Agent description: checks the group file(s), as supplied in MyGroupFiles
# Author:            Penka Vassileva Markova
#
# History of modifications:
# 
# Known bugs:
# 
# Things to do:
# 
# Future work:
# 
# Suggestions made by people:
# 
# Generated automatically by ../bin/makeagent.pl on Tue Sep  7 23:55:50 1999.
# 
###### AUTOMATICALLY GENERATED FILE --- DO NOT EDIT ##########
#

# 10 "GroupFilesChecker.aas"
package GroupFilesChecker;

# Version number
# 12 "GroupFilesChecker.aas"
$VERSION=eval {1.0}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "checks the group file(s), as supplied in MyGroupFiles",
             CheckPeriod        => eval {10},

             FiltersNeeded => {  }
            );

# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;


use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 GroupFilesChecker



=cut

# Preamble code


# Provide an Init function.
sub Init {
  my $self=checkref(shift);
# 17 "GroupFilesChecker.aas"
  $self->Log_activate("debug");
  $max_status = 10 ;
  $min_status =  0 ;

  $Params{MyGroupFiles}{ '/etc/group'} = {'file'} ;

  $Params{MyWeights}={} ;
  $Params{MyWeights}={  blank_lines => 1,
			not_enough_fields =>1,
			not_only_ld_grp =>1,
			only_digits_group=>1,
			has_passwd =>7,
			nonnumeric_gid => 3, 
			negat_gid => 3,
			user_more => 1,
			group_more =>2,
			not_opened => 5,
                    ,
                   } ;
  return $self;
}

# The Check function.
sub Check {
  my $self=checkref(shift);
# 38 "GroupFilesChecker.aas"
  my $message="" ;
  my $status = $min_status ;
  my $GRP ;
  my $line ;

  foreach $file( sort keys %{$Params{MyGroupFiles}})
	{ 
  $message.= "File => $file : ";
  $GRP = "GRP";
  my $opened;
  my (  $blank_lines,  $not_enough_fields, $not_only_ld_usr,$only_digits_user, $no_passwd,$negat_uid, $nonnumeric_uid,$root_nonroot, $negat_gid, $nonnumeric_gid, $bad_home, $unknown_shell, $users_more, $not_opened ) = 0;

  if ( $Params{MyGroupFiles} eq "not_file")
	{ $opened = open($GRP, `$file`) && ( defined ($GRP));}
  else
	{$opened = ( (-e $file) && (open($GRP, "< $file")) && (defined ($GRP)));}

  unless ( $opened )
	 { $status = $Params{Weights}{not_opened}; $message .= "Couldn't open $file  ";
	   goto END_CHECK_PASSWD_FILE;
	}

#users in different files would not constitute a douplicate
    my $group_once={};
    my $group_more={} ;  
    my $blank_lines=0 ;

    while ($line = <$GRP>) {
      next if ( $line =~ m/^[-+]/);    # skip YP lines

	if ( $line =~ m/^\s*/ )
	{  $blank_lines++;  next ;}

	my ($group,$passwd,$gid,$users) = split /':'/, $line;
 
	if (@_ != 4)
	{ $not_enough_fields++; next; }

	if ( defined ($group_once{$group}) ) 
	{ $group_more{$group} = 1; }  
	else
	{ $group_more{$group} = 1; }  
	   
 
	if ( $group !~ m/^[A-Za-z0-9]+$/ )
	{ $status += $Params{MyWeights}{not_only_ld_grp} ; $not_only_ld_grp.= "$group, ";}

	if ( $group =~ /^\d+$/ )
	{ $status += $Params{MyWeights}{only_digits_group} ; $only_digits_group.= "$group, ";}

	if ($passwd || ( $passwd eq "")) 
	{ $status += $Params{MyWeights}{no_passwd} ; $has_passwd.= "$group, ";}


	if ($gid !~ /^\d+$/) {
	    if ($gid < 0) 
		{ $status+= $Params{MyWeights}{negat_gid} ; $negat_gid.= "$gid: $group, ";}
	} 
	else 
	    { $status+= $Params{MyWeights}{nonnumeric_gid} ; $nonnumeric_gid.= "$gid: $group, ";}

    @users = split ( /\s*,\s*/, $users);
    %user_more = {}; %user_once = {};
    foreach $current_user(@users) 
	{ if ( ( defined ($user_once{$current_user}) ) && ($user_once{$current_user} == 1 ) ) 
		{$user_more{$current_user }=1;}
	  else
		{$user_once{$current_user} = 1}
	}

  if ( ${%user_more} > 0)
	{
	$status += ${%user_more}*$Params{MyWeights}{user_more};
	$message.= "Duplicate users in group $group: ";
	foreach $u ( keys %user_more )
	{$message.= "$u, ";}
	}
    }

close GRP ;  

END_CHECK_PASSWD_FILE:

  unless ( $blank_lines <= 0 )
	{ $status += $blank_lines*$Params{MyWeights}{blank_lines}; $message.= "Blank lines: $blank_lines; ";}

  unless ( $not_enough_fields <= 0 )
	{ $status += $not_enough_fields*$Params{MyWeights}{not_enough_fields};
	  $message.= "Lines with missing fields: $not_enough_fields; " ;}

  unless ( $not_only_ld_grp eq "" ) {
	$message.= "Group names containing other than digits and letters: $not_only_ld_grp; "};

  $message.= "Group names containing only digits: $only_digits_group; " unless ( $only_digits_group eq "" );
  $message.= "Groups with password: $has_passwd; " unless ( $has_passwd eq "" );
  $message.= "Negative group ID: $negat_gid; " unless ( $negat_gid eq "" );
  $message.= "Not numeric group ID: $nonnumeric_gid; " unless ( $nonnumeric_gid eq "" );

  if ( ${%group_more} > 0)
	{
	$status += ${%group_more}*$Params{MyWeights}{group_more};
	$message.= "Duplicate groups: ";
	foreach $u ( keys %group_more )
	{$message.= "$u, "}
	}

  if ( $message eq "" )    {$message = "OK";}
  else  { chop $message; chop $message ; $message.="."; }
return ($message);
}
 if ( $status > $max_status ) 
      { $status = $max_status; } 

   return ($status, $message);


#======================================================================================
}
# Agent commands

sub command_ADD_FILE {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{Info}) && 1) {
    my $Info = $p{Info};
# 171 "GroupFilesChecker.aas"
    my @list = splitList($Info);
    my $file_name = shift (@list ) ;
    my $value = "file";# default 
    if ( scalar @list > 0 ){ $value = shift(@list);
    $Params{MyGroupFiles}{$file_name}= $value ;
    }
  $self->Log('debug', "Adding group file $file_name\n");
    # By default, return undef
    return undef;
  }
}

sub command_FILES_RECORD {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{Info}) && 1) {
    my $Info = $p{Info};
# 187 "GroupFilesChecker.aas"
  my @Name= splitList($Info) ;
  my $result ;

  foreach $name(@Name)
  {
    if ( defined ($Params{MyGroupFiles}{$name}))
	{
	    $result.= "File name => $name;  Content = > $Params{MyGroupFiles} ;";
	}
    else
    {
	$result.= "File name => $name; Content = > ;";
    }
  }  
  $self->Log('debug', "Showing data fields for group files\n"); 
  return { Group_Files_Values => $result };
    # By default, return undef
    return undef;
  }
}

sub command_LIST_WEIGHT_FIELDS {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (1) {
    
# 163 "GroupFilesChecker.aas"
  my $list = "";
  foreach $file (  keys %{$Params{MyWeights}}) 
		{ $list.= ":: $file => $Params{MyWeights}{$file} "; }
  $self->Log('debug', "Listing the ftpgroups files\n"); 
  return {WEIGHT_FIELDS => $list } ;

#==============================================================
    # By default, return undef
    return undef;
  }
}

sub command_DELETE_ALL {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (1) {
    
# 214 "GroupFilesChecker.aas"
	$Params{MyGroupFiles} = {};
     $self->Log('debug', "Removing ALL files from group files list\n"); 

#=========================================================================
    # By default, return undef
    return undef;
  }
}

sub command_CHANGE_WEIGHT_FIELDS {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{Info}) && 1) {
    my $Info = $p{Info};
# 156 "GroupFilesChecker.aas"
  my @list = splitList($Info);
  my $data_name = shift (@list ) ;
	$value = pop @list ;
	$Params{MyWeights}{$data_name} = shift (@list) ;
  $self->Log('debug', "Changing the values for $data_name\n");
    # By default, return undef
    return undef;
  }
}

sub command_DELETE_FILES {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{Info}) && 1) {
    my $Info = $p{Info};
# 205 "GroupFilesChecker.aas"
  my @list = splitList($Info);

  foreach $list( @list )
  {
	 delete $Params{MyGroupFiles}{$list};
  }
  $self->Log('debug', "Removing files from the group files list\n");
    # By default, return undef
    return undef;
  }
}

sub command_LIST_FILES {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (1) {
    
# 180 "GroupFilesChecker.aas"
  my $list ;
  $list = join ( ",", keys %{$Params{MyGroupFiles}}) ;
  $self->Log('debug', "Listing the group files\n"); 
  return {Group_Files => $list } ;
    # By default, return undef
    return undef;
  }
}

# End of entity marker
_EndOfEntity;
