eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID2 system
# Agent name:        LFS
# Agent description: checks the local file systems
# Author:            Penka Vassileva Markova
#
# History of modifications:
# 
# Known bugs:
# 
# Things to do:
# 
# Future work:
# 
# Suggestions made by people:
# 
# Generated automatically by ../bin/makeagent.pl on Tue Sep  7 23:55:51 1999.
# 
###### AUTOMATICALLY GENERATED FILE --- DO NOT EDIT ##########
#

# 10 "LFS.aas"
package LFS;

# Version number
# 12 "LFS.aas"
$VERSION=eval {1.0}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "checks the local file systems",
             CheckPeriod        => eval {10},

             FiltersNeeded => {  }
            );

# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;


use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 LFS



=cut

# Preamble code


# Provide an Init function.
sub Init {
  my $self=checkref(shift);
# 24 "LFS.aas"
  $self->Log_activate("debug");
  $max_status = 10 ;
  $min_status =  0 ;
  $Params{MyUseUnstandardFile} = 0 ;
  $Params{MySystems}={};
# the higher the value in the second level field (1, 2 & 3 now) the earlier it would be checked  
  $Params{MySystems}{Default}{level}{1}  =  60 ;
  $Params{MySystems}{Default}{level}{2}  =  80 ;
  $Params{MySystems}{Default}{level}{3}  =  90 ;
  $Params{MySystems}{Default}{weight}{1} =   3 ;
  $Params{MySystems}{Default}{weight}{2} =   5 ;
  $Params{MySystems}{Default}{weight}{3} =   8 ;
  return $self;
}

# The Check function.
sub Check {
  my $self=checkref(shift);
# 38 "LFS.aas"
  my %fmessage ;  $fmessage{1} = ""; $fmessage{2} = "";  $fmessage{3} = "";
  my $status = $min_status ;
  my $message = "";

  my $list ;
  my @list ;
  $list=`df -l -k` ;
  @list = split /\n/,$list  ;
  my $first_line = shift @list ;

###
## check if the format of the first title line is ok; 
## otherwise the status turns to max and leaves
###
  unless ( $Params{MyUseUnstandardFile} || ( ($first_line =~ m/\A *([^ ]+) +([^ ]+) +([^ ]+) +([^ ]+) +([^ ]+) +([^ ]+) +([^ \n]+)[ \n]*\Z/ )
          && ($1 eq "Filesystem")&&($2 eq "kbytes")&&($3 eq "used")&&($4 eq "avail")
  	  && ($5 eq "capacity")&&($6 eq "Mounted")&&($7 eq "on"))  ) {
      $status = $max_status ;
      $message = "Unexpected content of the first line generated by the unix command df";
      goto END_OF_CHECK;
    }

###
## check each line
###
  foreach $line(@list) {
    if ( $line =~ m/\A *([^ ]+) +([^ ]+) +([^ ]+) +([^ ]+) +([^ %]+)% +([^ \n]+)\Z/ ) 
    {
      foreach $current_level( reverse sort keys %{$Params{MySystems}{Default}{level}}) 
      {

# $1 is the name of the file system, 
# $5 is the percentage  of  normally  available space  that  is  currently  allocated 
#     to all files on the file system

	if (defined ($Params{MySystems}{$1}) && defined ( $Params{MySystems}{$1}{level}{$current_level} ) )  
        { 
	  if ( $5 > $Params{MySystems}{$1}{level}{$current_level} ) 
          {
	    $fmessage{$current_level} .= "$1, ";
	    if (defined ($Params{MySystems}{$1}{weight}{$current_level})) 
		{$status += $Params{MySystems}{$1}{weight}{$current_level}; }
	    else
		{$status += $Params{MySystems}{Default}{weight}{$current_level}; }
	    last ;
	  }
	}
	else 
        { 
	  if ( $5 > $Params{MySystems}{Default}{level}{$current_level} ) 
          {
	    $fmessage{$current_level} .= "$1, ";
	    if (defined ($Params{MySystems}{$1}) && defined ($Params{MySystems}{$1}{weight}{$current_level})) 
		{$status += $Params{MySystems}{$1}{weight}{$current_level}; }
  	    else
		{$status += $Params{MySystems}{Default}{weight}{$current_level}; }
	    last ;
	  }
	}
      }	
    }
    elsif ( $line =~ /[^ \n]+/ ) {
      $status = 10 ;
      $message = "Unexpected result from the unix command df";
      last ;
    }	
  }

END_OF_CHECK:
  if ( $status > $max_status ) 
      { $status = $max_status; } 

  foreach $current_level ( sort keys %fmessage) {
    if ( $fmessage{$current_level} ne "") { 
      chop $fmessage{$current_level} ; chop $fmessage{$current_level} ;
      $message.= "Over level $current_level: $fmessage{$current_level}; ";
    }
  }

  if ( $message eq "" )    {$message = "OK";}
  else  { chop $message; chop $message ; $message.="."; }

  return ( $status, $message ) ;

#====================================================================================
}
# Agent commands

sub command_DELETE_FILESYSTEMS {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{Info}) && 1) {
    my $Info = $p{Info};
# 215 "LFS.aas"
###
## deletes the filesystems in the list
###
  my @list = splitList($Info);

  foreach $list( @list )
  {
	delete $Params{MySystems}{$list} ;
  }
  $self->Log('debug', "Removing filesystems from nondefault treatment\n");
    # By default, return undef
    return undef;
  }
}

sub command_CHANGE_FILESYSTEM {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{Info}) && 1) {
    my $Info = $p{Info};
# 177 "LFS.aas"
##
# same as ADD_FILESYSTEM, however any data for the given filesystem already exists, it
#   will not be changed except if specifically stated 
##
  my @list = splitList($Info);
  my $file_name = shift (@list ) ;

  while ( scalar @list > 0 ) {
	$value = pop @list ;
	$second_level = pop @list ;
	$wl = pop @list ;
	$Params{MySystems}{$file_name}{$wl}{$second_level} = $value ;
  }
  $self->Log('debug', "Changing the values for $file_name\n");
    # By default, return undef
    return undef;
  }
}

sub command_DIFF_DF_FORMAT {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (1) {
    
# 130 "LFS.aas"
###
## the title line of the 'df -l -k' output can be different; 
#     however, a title line should exist and the rest of the output still 
#     should have the expected format
###
	$Params{MyUseUnstandardFile} = 1 ;
    # By default, return undef
    return undef;
  }
}

sub command_DELETE_ALL {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (1) {
    
# 227 "LFS.aas"
###
## deletes all filesystems with special treatment ( 'Default' remains )
###
  foreach $current( keys %{$Params{MySystems}})
	{
	  delete $Params{MySystems}{$current} if ( $current ne 'Default');
	}
  $self->Log('debug', "Removing ALL filesystems from nondefault treatment\n");
    # By default, return undef
    return undef;
  }
}

sub command_LIST_SPECIAL_FILESYSTEMS {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (1) {
    
# 167 "LFS.aas"
##
# lists all filesystems with special values
##  
  my $list ;
  $list = join ( ",", keys %{$Params{MySystems}}) ;
  $list =~ s/Default(, *)*// ;
  $self->Log('debug', "Listing the filesystems with nondefault values\n"); 
  return {Special_FileSystems => $list } ;
    # By default, return undef
    return undef;
  }
}

sub command_ADD_FILESYSTEM {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{Info}) && 1) {
    my $Info = $p{Info};
# 193 "LFS.aas"
###
## adds the data for a filesystem; if the filesystem have existed, all previous data
#    about it would be lost.
## 'Default' is an exception, and for it ADD_FILESYSTEM is same as CHANGE_FILESYSTEM
## the input is expected to be a list with content: file_name, ( 'weight' or 'level', the value of the 
#     second level/1, 2 or 3/, value to be recorded )* as many times as needed/
#####
    my @list = splitList($Info);
    my $file_name = shift (@list ) ;

  if ( $file_name ne 'Default' ) 
	{$Params{MySystems}{$file_name} = {};}

   while ( scalar @list > 0 ) {
        $value = pop @list ;
        $second_level = pop @list ;
        $wl = pop @list ;
        $Params{MySystems}{$file_name}{$wl}{$second_level} = $value ;
    }
  $self->Log('debug', "Adding values for $file_name\n");
    # By default, return undef
    return undef;
  }
}

sub command_FILESYSTEMS_RECORD {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{Info}) && 1) {
    my $Info = $p{Info};
# 138 "LFS.aas"
##
# returns a all the records for the given files, in a specific form
## 

  my @Name= splitList(@_) ;
  my $result ;

  foreach $name(@Name)
  {
    if ( defined ($Params{MySystems}{$name}))
	{
	    $result.= "Filesystem name => :: $name;  Weights= > ";
	    foreach $weigh ( sort keys %{$Params{MySystems}{$name}{weight}})
	        { $result.=":: $weigh : $Params{MySystems}{$name}{weight}{$weigh} ";}
	    $result.="; Levels => ";
	    foreach $lev ( sort keys %{$Params{MySystems}{$name}{level}})
	        { $result.=":: $lev : $Params{MySystems}{$name}{level}{$lev} ";}
	    $result.=";";
	}
    else
    {
	$result.= "File name => :: $name; Weights= > :: ; Levels => :: ;";
    }
  }  
  $self->Log('debug', "Showing data fields for files\n"); 
  return { Filesystem_Record => $result };
    # By default, return undef
    return undef;
  }
}

sub command_SAME_DF_FORMAT {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (1) {
    
# 124 "LFS.aas"
###
## have a title line in the 'df -l -k' output as in the code 
###
	$Params{MyUseUnstandardFile} = 0 ;
    # By default, return undef
    return undef;
  }
}

# End of entity marker
_EndOfEntity;
