" Vim syntax file
" Language:	Aafid Agent Specification
" Maintainer:	Benjamin Kuperman <kuperman@acm.org>
" Last change:	1998 July 1st

" Remove any old syntax stuff hanging around
syn clear

"
" Comments
"

" Let's first snag all the perl stuff
source <sfile>:p:h/perl.vim

" What is specfic for aafids?

"don't worry about the case here
syn case ignore
syn keyword aafidAAFID contained AAFID AAFID2 AAFID3

" Everything should match case
syn case match

"""
" Various 'regions'
"""
"syn region aafidOneLine start="^\(NAME:\|DESCRIPTION:\|VERSION:\|AUTHOR:\|PERIOD:\|PACKAGES:\)"  end="$" contains=aafidOneLineField
syn match aafidOneLine "^\(NAME:\|DESCRIPTION:\|VERSION:\|AUTHOR:\|PERIOD:\|PACKAGES:\).*$" contains=aafidOneLineField,aafidAAFID

" I don't know how to keep the perl syntax properly highlighted within the region
" so we'll skip it for now.
"syn region aafidMLinePerl start="^\(PREAMBLE:\|INIT:\|CHECK:\|PARAMS:\|FILTERS:\)" skip="^[ \t]" end="^\(NAME:\|DESCRIPTION:\|VERSION:\|AUTHOR:\|PERIOD:\|PACKAGES:\|PREAMBLE:\|INIT:\|CHECK:\|PARAMS:\|CHANGELOG:\|BUGS:\|TODO:\|SUGGESTIONS:\|FUTURE:\|COMMAND\|LONGDESCRIPTION:\|FILTERS:\)"me=s-1 contains=aafidMultiLinePerl
syn match aafidMLinePerl "^\(PREAMBLE:\|INIT:\|CHECK:\|PARAMS:\|FILTERS:\)" contains=aafidMultiLinePerl

syn region aafidMLineText start="^\(CHANGELOG:\|BUGS:\|TODO:\|SUGGESTIONS:\|FUTURE:\|LONGDESCRIPTION:\)" skip="^[ \ta-z]" end="^\(NAME:\|DESCRIPTION:\|VERSION:\|AUTHOR:\|PERIOD:\|PACKAGES:\|PREAMBLE:\|INIT:\|CHECK:\|PARAMS:\|CHANGELOG:\|BUGS:\|TODO:\|SUGGESTIONS:\|FUTURE:\|COMMAND\|LONGDESCRIPTION:\|FILTERS:\)"me=s-1 contains=aafidMultiLineText,aafidAAFID

syn region aafidCommandProto start="^COMMAND" end=":"me=e-1 contains=aafidFunProto,aafidCommandDecl
syn match aafidFunProto "([^)]*)" contained

"""
" Various keywords
"""
syn keyword aafidOneLineField contained	NAME DESCRIPTION VERSION AUTHOR PERIOD PACKAGES
syn keyword aafidMultiLinePerl contained PREAMBLE INIT CHECK PARAMS FILTERS
syn keyword aafidMultiLineText contained CHANGELOG BUGS TODO SUGGESTIONS FUTURE LONGDESCRIPTION
syn keyword aafidCommandDecl contained COMMAND

if !exists("did_aafid_syntax_inits")
  let did_aafid_syntax_inits = 1
" hi link 
  hi link aafidOneLine		String
  hi link aafidOneLineField	PreProc
  hi link aafidMultiLinePerl	aafidOneLineField
  hi link aafidMultiLineText	aafidMultiLinePerl
  hi link aafidMLineText	Special
  hi link aafidCommandDecl	Type
  hi link aafidCommandProto	Function
  hi link aafidAAFID		Todo
endif


let b:current_syntax = "aafid"

" vim:ts=8:wm=0
