# Part of the A-A-P recipe executive: A position in a recipe

# Copyright (C) 2002 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING


# A RecPos object contains:
#  name   	- name of the recipe
#  line_nr	- line number in the recipe
#
# This is normally used in a stack, first item is the position where it
# includes the second item, etc.

class RecPos:
    def __init__(self, name, line_nr = 0):
	self.name = name
	self.line_nr = line_nr


def rpcopy(rpstack, line_nr):
    """Make a shallow copy of the stack of RecPos objects and make a copy of
       the item on the top to change its line_nr to "line_nr"."""
    r = rpstack[:]
    if len(r) > 0:
	r[-1] = RecPos(r[-1].name, line_nr)
    else:
	r = [ RecPos("unknown", line_nr) ]

    return r


def rpdeepcopy(rpstack, line_nr):
    """Make a deep copy of the stack of RecPos objects and for the item on the
       top change its line_nr to "line_nr"."""
    r = rpstack[:]
    for i in range(0, len(r) - 1):
	r[i] = RecPos(r[i].name, r[i].line_nr)
    r[-1] = RecPos(r[-1].name, line_nr)
    return r

# vim: set sw=4 sts=4 tw=79 fo+=l:
